/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.enchanment;

import com.mojang.serialization.Codec;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.statdisplay.DoubleResolvableStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.enchanment.FakeEnchantmentManager;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.EitherModuleProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class FakeEitherEnchantmentProperty
extends EitherModuleProperty<Map<class_2960, DoubleOperationResolvable>, Map<class_6880.class_6883<class_1887>, DoubleOperationResolvable>> {
    public static final class_2960 KEY = Miapi.id("fake_enchants");
    public static Codec<Map<class_2960, DoubleOperationResolvable>> CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, DoubleOperationResolvable.CODEC);

    public FakeEitherEnchantmentProperty() {
        super(CODEC);
        FakeEnchantmentManager.transformerList.add((enchantmentHolder, itemStack, oldLevel) -> {
            for (Map.Entry<class_6880.class_6883<class_1887>, DoubleOperationResolvable> location : this.getEnchants(itemStack).entrySet()) {
                if (!enchantmentHolder.method_55838((class_6880)location.getKey())) continue;
                DoubleOperationResolvable resolvable = location.getValue();
                oldLevel = (int)resolvable.evaluate(oldLevel, oldLevel);
            }
            return oldLevel;
        });
        FakeEnchantmentManager.ADD_ENCHANTMENT.register(enchantmentMap -> {
            for (Map.Entry<class_6880.class_6883<class_1887>, DoubleOperationResolvable> location : this.getEnchants(enchantmentMap.referenceStack).entrySet()) {
                if (enchantmentMap.enchantments.contains(location.getKey())) continue;
                enchantmentMap.enchantments.add((class_6880<class_1887>)((class_6880)location.getKey()));
            }
            return EventResult.pass();
        });
        if (Environment.isClient()) {
            this.setupClient();
        }
    }

    @Override
    protected Map<class_6880.class_6883<class_1887>, DoubleOperationResolvable> initializeDecode(Map<class_2960, DoubleOperationResolvable> property, ModuleInstance context) {
        HashMap<class_6880.class_6883<class_1887>, DoubleOperationResolvable> initialized = new HashMap<class_6880.class_6883<class_1887>, DoubleOperationResolvable>();
        property.forEach((id, resolvable) -> {
            if (Miapi.registryAccess != null) {
                FakeEitherEnchantmentProperty.getWithRegistry(Miapi.registryAccess, id, resolvable, initialized, context);
            }
            if (Miapi.clientRegistryAccess != null) {
                FakeEitherEnchantmentProperty.getWithRegistry(Miapi.clientRegistryAccess, id, resolvable, initialized, context);
            }
        });
        return initialized;
    }

    private static void getWithRegistry(class_5455 clientRegistryAccess, class_2960 id, DoubleOperationResolvable resolvable, Map<class_6880.class_6883<class_1887>, DoubleOperationResolvable> initialized, ModuleInstance context) {
        clientRegistryAccess.method_46759(class_7924.field_41265).ifPresentOrElse(enchantmentRegistryInfo -> enchantmentRegistryInfo.method_46746(class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)id)).ifPresentOrElse(holder -> {
            resolvable.setFunctionTransformer(s -> ((String)s.getFirst()).replace("[old_level]", "0"));
            initialized.put((class_6880.class_6883<class_1887>)holder, resolvable.initialize(context));
        }, () -> Miapi.LOGGER.warn("Could not find enchantment " + String.valueOf(id) + " skiping")), () -> Miapi.LOGGER.warn("Enchantment Registries not Found - could not decode enchantments"));
    }

    @Override
    protected Map<class_6880.class_6883<class_1887>, DoubleOperationResolvable> mergeInterpreted(Map<class_6880.class_6883<class_1887>, DoubleOperationResolvable> left, Map<class_6880.class_6883<class_1887>, DoubleOperationResolvable> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType, (e, l, r) -> DoubleOperationResolvable.merge(l, r, mergeType));
    }

    @Override
    protected Map<class_2960, DoubleOperationResolvable> mergeRaw(Map<class_2960, DoubleOperationResolvable> left, Map<class_2960, DoubleOperationResolvable> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType, (e, l, r) -> DoubleOperationResolvable.merge(l, r, mergeType));
    }

    @Override
    protected Map<class_2960, DoubleOperationResolvable> deInitialize(Map<class_6880.class_6883<class_1887>, DoubleOperationResolvable> property) {
        HashMap<class_2960, DoubleOperationResolvable> map = new HashMap<class_2960, DoubleOperationResolvable>();
        property.forEach((id, resolvable) -> map.put(id.method_40237().method_29177(), (DoubleOperationResolvable)resolvable));
        return map;
    }

    public Map<class_6880.class_6883<class_1887>, DoubleOperationResolvable> getEnchants(class_1799 itemStack) {
        return this.getData(itemStack).flatMap(c -> c.right()).orElse(Map.of());
    }

    @net.fabricmc.api.Environment(value=EnvType.CLIENT)
    public void setupClient() {
        StatListWidget.addStatDisplaySupplier(new StatListWidget.StatWidgetSupplier(){

            @Override
            public <T extends InteractAbleWidget> List<T> currentList(class_1799 original, class_1799 compareTo) {
                ArrayList displays = new ArrayList();
                HashMap<Object, DoubleOperationResolvable> enchantments = new HashMap<Object, DoubleOperationResolvable>();
                enchantments.putAll(FakeEitherEnchantmentProperty.this.getEnchants(original));
                enchantments.putAll(FakeEitherEnchantmentProperty.this.getEnchants(compareTo));
                enchantments.forEach((enchantment, data) -> {
                    class_5250 desc = class_2561.method_48321((String)("enchantment." + enchantment.method_40237().method_29177().method_12836() + "." + enchantment.method_40237().method_29177().method_12832() + ".desc"), (String)"");
                    displays.add(DoubleResolvableStatDisplay.builder(s -> Optional.ofNullable(FakeEitherEnchantmentProperty.this.getEnchants((class_1799)s).get(enchantment))).setHoverDescription((class_2561)class_2561.method_43469((String)"miapi.fake_enchant.desc", (Object[])new Object[]{((class_1887)enchantment.comp_349()).comp_2686(), desc})).setName(((class_1887)enchantment.comp_349()).comp_2686()).setMax(((class_1887)enchantment.comp_349()).method_8183()).setFormat("#").setInverse(enchantment.method_40220(class_9636.field_51551)).setMin(0.0).build());
                });
                return displays;
            }
        });
    }
}

