/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.shape;

import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.mining.shape.MiningShape;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public class VeinMiningShape
implements MiningShape {
    public static MapCodec<VeinMiningShape> CODEC = AutoCodec.of(VeinMiningShape.class);
    public static class_2960 ID = Miapi.id("vein");
    public int size = 5;
    @CodecBehavior.Optional
    public DoubleOperationResolvable max = new DoubleOperationResolvable(15.0);

    @Override
    public List<class_2338> getMiningBlocks(class_1937 world, class_2338 pos, class_2350 face) {
        ArrayList<class_2338> miningBlocks = new ArrayList<class_2338>();
        if (this.max.getValue() < 1.0) {
            return miningBlocks;
        }
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        ArrayList<class_2338> visited = new ArrayList<class_2338>();
        queue.add(pos);
        visited.add(pos);
        class_2680 centerState = world.method_8320(pos);
        while (!queue.isEmpty() && miningBlocks.size() < this.size * this.size * this.size && (double)miningBlocks.size() < this.max.getValue()) {
            class_2338 currentPos = (class_2338)queue.poll();
            miningBlocks.add(currentPos);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        class_2338 neighborPos = currentPos.method_10069(dx, dy, dz);
                        int dx1 = neighborPos.method_10263() - pos.method_10263() + this.size;
                        int dy1 = neighborPos.method_10264() - pos.method_10264() + this.size;
                        int dz1 = neighborPos.method_10260() - pos.method_10260() + this.size;
                        if (Math.abs(dx1 - this.size) > this.size || Math.abs(dy1 - this.size) > this.size || Math.abs(dz1 - this.size) > this.size || visited.contains(neighborPos)) continue;
                        visited.add(neighborPos);
                        class_2680 neighborState = world.method_8320(neighborPos);
                        if (!neighborState.method_26204().equals(centerState.method_26204())) continue;
                        queue.add(neighborPos);
                    }
                }
            }
        }
        return miningBlocks;
    }

    @Override
    public class_2960 getID() {
        return ID;
    }

    @Override
    public MiningShape initialize(MiningShape property, ModuleInstance context) {
        VeinMiningShape miningShape = new VeinMiningShape();
        miningShape.max = ((VeinMiningShape)property).max.initialize(context);
        miningShape.size = ((VeinMiningShape)property).size;
        return miningShape;
    }
}

