/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.onHit;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_9135;
import net.minecraft.class_9331;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.events.MeleeModularAttackEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class NemesisProperty
extends DoubleProperty
implements CraftingProperty {
    public static final class_2960 KEY = Miapi.id("nemesis");
    public static NemesisProperty property;
    public static Codec<NemesisData> CODEC;
    public static class_9331<NemesisData> NEMESIS_COMPONENT;
    public DecimalFormat modifierFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("##.#"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public NemesisProperty() {
        super(KEY);
        this.setupLore();
        property = this;
        EntityEvent.LIVING_DEATH.register((livingEntity, damageSource) -> {
            class_1799 weapon = MiapiEvents.LivingHurtEvent.getMainCausingStack(damageSource);
            if (ModularItem.isModularItem(weapon) && !livingEntity.method_37908().method_8608()) {
                double nemesisScale = this.getValue(weapon).orElse(0.0);
                if (nemesisScale == 0.0) {
                    return EventResult.pass();
                }
                NemesisData data = (NemesisData)weapon.method_57825(NEMESIS_COMPONENT, (Object)new NemesisData("", 0));
                class_1299 attackedType = livingEntity.method_5864();
                if (data != null && nemesisScale > 0.0) {
                    data = data.clone();
                    Optional entityType1 = class_1299.method_5898((String)data.entityType);
                    if (entityType1.isPresent()) {
                        class_1299 targetType = (class_1299)entityType1.get();
                        if (attackedType.equals(targetType)) {
                            ++data.kills;
                        } else {
                            data.kills -= 5;
                            if (data.kills < 0) {
                                data.kills = 0;
                                data.entityType = "";
                            }
                        }
                    } else {
                        data.entityType = class_1299.method_5890((class_1299)attackedType).toString();
                        data.kills = 1;
                    }
                } else {
                    data.entityType = class_1299.method_5890((class_1299)attackedType).toString();
                    data.kills = 1;
                }
                if (livingEntity.method_6030().equals(weapon)) {
                    weapon.method_57379(NEMESIS_COMPONENT, (Object)data);
                    if (livingEntity instanceof class_1657) {
                        class_1657 player = (class_1657)livingEntity;
                        player.method_6122(player.method_6058(), weapon);
                    }
                } else {
                    weapon.method_57379(NEMESIS_COMPONENT, (Object)data);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(listener -> {
            class_1799 weapon = listener.getMainCausingStack();
            if (ModularItem.isModularItem(weapon)) {
                double nemesisScale = this.getValue(weapon).orElse(0.0);
                NemesisData data = (NemesisData)weapon.method_57824(NEMESIS_COMPONENT);
                if (data != null && nemesisScale > 0.0) {
                    class_1299 attackedType = listener.defender.method_5864();
                    Optional entityType1 = class_1299.method_5898((String)data.entityType);
                    if (entityType1.isPresent()) {
                        class_1299 targetType = (class_1299)entityType1.get();
                        if (attackedType.equals(targetType)) {
                            double factor = NemesisProperty.scale(data.kills, nemesisScale);
                            listener.amount += (float)factor * listener.amount;
                        } else {
                            double factor = NemesisProperty.scale(data.kills, nemesisScale);
                            factor = Math.min(0.95, factor);
                            listener.amount -= (float)factor * listener.amount;
                        }
                    }
                }
            }
            return EventResult.pass();
        });
        MeleeModularAttackEvents.ATTACK_DAMAGE_BONUS.register((target, weapon, baseDamage, damageSource, bonusDamage) -> {
            if (ModularItem.isModularItem(weapon)) {
                double nemesisScale = this.getValue(weapon).orElse(0.0);
                NemesisData data = (NemesisData)weapon.method_57824(NEMESIS_COMPONENT);
                if (data != null && nemesisScale > 0.0) {
                    class_1299 attackedType = target.method_5864();
                    Optional entityType1 = class_1299.method_5898((String)data.entityType);
                    if (entityType1.isPresent()) {
                        class_1299 targetType = (class_1299)entityType1.get();
                        if (attackedType.equals(targetType)) {
                            double factor = NemesisProperty.scale(data.kills, nemesisScale);
                            bonusDamage.add((Number)(factor * (double)baseDamage));
                        } else {
                            double factor = NemesisProperty.scale(data.kills, nemesisScale);
                            factor = Math.min(0.95, factor);
                            bonusDamage.add((Number)(factor * (double)baseDamage));
                        }
                    }
                }
            }
            return EventResult.pass();
        });
    }

    public void setupLore() {
        LoreProperty.loreSuppliers.add((weapon, tooltip, context, tooltipType) -> {
            double nemesisScale = this.getValue(weapon).orElse(0.0);
            NemesisData data = (NemesisData)weapon.method_57824(NEMESIS_COMPONENT);
            if (data != null && nemesisScale > 0.0) {
                double factor = NemesisProperty.scale(data.kills, nemesisScale) * 100.0f - 1.0f;
                Optional entityType1 = class_1299.method_5898((String)data.entityType);
                class_5250 entity = class_2561.method_43471((String)"miapi.lore.nemesis.no_entity");
                if (entityType1.isPresent() && data.kills != 0) {
                    entity = ((class_1299)entityType1.get()).method_5897();
                }
                class_5250 blueNumber = class_2561.method_43470((String)(this.modifierFormat.format(factor) + "%")).method_27696(class_2583.field_24360.method_10977(class_124.field_1078));
                class_5250 redNumber = class_2561.method_43470((String)(this.modifierFormat.format(factor / 2.0) + "%")).method_27696(class_2583.field_24360.method_10977(class_124.field_1061));
                class_5250 whiteNumber = class_2561.method_43470((String)String.valueOf(data.kills)).method_27696(class_2583.field_24360.method_10977(class_124.field_1068));
                entity = class_2561.method_43470((String)entity.getString()).method_27696(class_2583.field_24360.method_10977(class_124.field_1080));
                tooltip.add(class_2561.method_43469((String)"miapi.lore.nemesis.0", (Object[])new Object[]{whiteNumber, entity}));
                if (factor != 0.0) {
                    tooltip.add(class_2561.method_43469((String)"miapi.lore.nemesis.1", (Object[])new Object[]{blueNumber, class_2561.method_43470((String)entity.getString()).method_27696(class_2583.field_24360.method_10977(class_124.field_1078))}));
                    tooltip.add(class_2561.method_43469((String)"miapi.lore.nemesis.2", (Object[])new Object[]{redNumber, class_2561.method_43470((String)entity.getString()).method_27696(class_2583.field_24360.method_10977(class_124.field_1061))}));
                }
            }
        });
    }

    public static float scale(int rawValue, double scale) {
        double factor = (Math.log(Math.pow(rawValue + 1, 5.0)) + 1.0) * scale;
        if (rawValue < 0) {
            factor = 0.0;
        }
        return (float)factor / 100.0f;
    }

    @Override
    public class_1799 preview(class_1799 old, class_1799 crafting, class_1657 player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<class_1799> inventory, Map<class_2960, JsonElement> data) {
        crafting.method_57379(NEMESIS_COMPONENT, (Object)new NemesisData("", 0));
        return crafting;
    }

    static {
        CODEC = AutoCodec.of(NemesisData.class).codec();
        NEMESIS_COMPONENT = class_9331.method_57873().method_57881(CODEC).method_57882(class_9135.method_56368(CODEC)).method_57880();
    }

    public static class NemesisData {
        @AutoCodec.Name(value="entity_type")
        public String entityType;
        public int kills;

        public NemesisData(String entityType, int kills) {
            this.entityType = entityType;
            this.kills = kills;
        }

        public NemesisData() {
        }

        public NemesisData clone() {
            return new NemesisData(this.entityType, this.kills);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NemesisData that = (NemesisData)o;
            return this.kills == that.kills && Objects.equals(this.entityType, that.entityType);
        }

        public int hashCode() {
            return Objects.hash(this.entityType, this.kills);
        }
    }
}

