/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.onHit.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Helper;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.statdisplay.DoubleResolvableStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public abstract class GenericEntityStrengthProperty
extends CodecProperty<Map<class_2960, EntityContext>> {
    protected GenericEntityStrengthProperty() {
        super(Codec.unboundedMap(Miapi.ID_CODEC, EntityContext.CODEC));
        if (Platform.getEnv() == EnvType.CLIENT) {
            this.setupToolTip();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void setupToolTip() {
        StatListWidget.addStatDisplaySupplier(new StatListWidget.StatWidgetSupplier(){

            @Override
            public <T extends InteractAbleWidget> List<T> currentList(class_1799 original, class_1799 compareTo) {
                ArrayList displays = new ArrayList();
                HashMap map = new HashMap(GenericEntityStrengthProperty.this.getData(original).orElse(Map.of()));
                map.putAll(GenericEntityStrengthProperty.this.getData(compareTo).orElse(Map.of()));
                map.forEach((id, edit) -> {
                    class_1299<?> exampleType = edit.firstType();
                    if (exampleType != null) {
                        displays.add(DoubleResolvableStatDisplay.builder(s -> GenericEntityStrengthProperty.this.getData((class_1799)s).filter(a -> a.containsKey(id)).map(a -> ((EntityContext)a.get(id)).strength())).setMax(8.0).setName(edit.name().orElse(GenericEntityStrengthProperty.this.getFallbackName(exampleType))).setHoverDescription(stack -> {
                            class_5250 component = class_2561.method_43473();
                            component.method_10852(edit.name().orElse(GenericEntityStrengthProperty.this.getFallbackName(exampleType))).method_27693("\n").method_10852(GenericEntityStrengthProperty.this.getBaseDescription(GenericEntityStrengthProperty.this.getData(stack).filter(a -> a.containsKey(id)).map(a -> ((EntityContext)a.get(id)).strength().getValue()).orElse(0.0))).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"miapi.property.entity.source")).method_27693("\n");
                            edit.entities().forEach(context -> {
                                if (context instanceof class_6885.class_6888) {
                                    class_6885.class_6888 named = (class_6885.class_6888)context;
                                    component.method_10852(Helper.getTranslation(named.method_40251())).method_27693("\n");
                                } else if (context instanceof class_6885.class_6887) {
                                    class_6885.class_6887 listBacked = (class_6885.class_6887)context;
                                    listBacked.forEach(type -> component.method_10852(((class_1299)type.comp_349()).method_5897()).method_27693("\n"));
                                }
                            });
                            return component;
                        }).build());
                    }
                });
                return displays;
            }
        });
    }

    public abstract class_2561 getFallbackName(class_1299<?> var1);

    public abstract class_2561 getBaseDescription(double var1);

    public double strengthForEntity(class_6880<class_1299<?>> entity, class_1799 itemStack) {
        return this.getData(itemStack).map(a -> {
            double value = 0.0;
            for (EntityContext context : a.values()) {
                if (!context.contains(entity)) continue;
                value += context.strength().getValue();
            }
            return value;
        }).orElse(0.0);
    }

    public double strengthForEntity(class_6880<class_1299<?>> entity, Iterable<class_1799> stacks) {
        double strength = 0.0;
        for (class_1799 itemStack : stacks) {
            strength += this.strengthForEntity(entity, itemStack);
        }
        return strength;
    }

    @Override
    public Map<class_2960, EntityContext> merge(Map<class_2960, EntityContext> left, Map<class_2960, EntityContext> right, MergeType mergeType) {
        MergeAble.mergeMap(left, right, mergeType, (key, l, r) -> new EntityContext(MergeAble.mergeList(l.entities(), r.entities(), mergeType), r.strength().merge(l.strength(), mergeType), MergeAble.decideLeftRight(r.name(), l.name(), mergeType)));
        return Map.of();
    }

    @Override
    public Map<class_2960, EntityContext> initialize(Map<class_2960, EntityContext> property, ModuleInstance context) {
        HashMap<class_2960, EntityContext> init = new HashMap<class_2960, EntityContext>();
        property.forEach((id, entityContext) -> init.put((class_2960)id, new EntityContext(entityContext.entities, entityContext.strength.initialize(context), entityContext.name)));
        return init;
    }

    public record EntityContext(List<class_6885<class_1299<?>>> entities, DoubleOperationResolvable strength, Optional<class_2561> name) {
        public static final Codec<EntityContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Miapi.toListOrSimple(class_6895.method_40340((class_5321)class_7924.field_41266)).optionalFieldOf("entities", List.of()).forGetter(EntityContext::entities), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("strength", (Object)new DoubleOperationResolvable(0.0)).forGetter(EntityContext::strength), (App)class_8824.field_46597.optionalFieldOf("name").forGetter(EntityContext::name)).apply((Applicative)instance, EntityContext::new));

        public boolean contains(class_6880<class_1299<?>> entity) {
            for (class_6885<class_1299<?>> holders : this.entities()) {
                if (!holders.method_40241(entity)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public class_1299<?> firstType() {
            for (class_6885<class_1299<?>> holder : this.entities()) {
                class_6885.class_6887 listBacked;
                Optional<class_1299> type;
                if (!(holder instanceof class_6885.class_6887) || !(type = (listBacked = (class_6885.class_6887)holder).method_40239().findFirst().map(class_6880::comp_349)).isPresent()) continue;
                return type.get();
            }
            return null;
        }
    }
}

