/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.projectile;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import dev.architectury.event.EventResult;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5362;
import smartin.miapi.Miapi;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeType;

public class ExplosionProperty
extends CodecProperty<ExplosionInfo> {
    public static final class_2960 KEY = Miapi.id("explosion_projectile");
    public static final Codec<ExplosionInfo> codec = AutoCodec.of(ExplosionInfo.class).codec();
    public static ExplosionProperty property;

    public ExplosionProperty() {
        super(codec);
        property = this;
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.register(event -> {
            Optional info = this.getData(event.projectile.method_7445());
            if (info.isPresent()) {
                if (!event.projectile.method_37908().method_8608()) {
                    ((ExplosionInfo)info.get()).explode(event.projectile.method_37908(), (class_1297)event.projectile, event.projectile.method_19538());
                    event.projectile.method_31472();
                }
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_PROJECTILE_BLOCK_HIT.register(event -> {
            Optional info = this.getData(event.projectile.method_7445());
            if (info.isPresent()) {
                if (!event.projectile.method_37908().method_8608()) {
                    ((ExplosionInfo)info.get()).explode(event.projectile.method_37908(), (class_1297)event.projectile, event.blockHitResult.method_17784());
                    event.projectile.method_31472();
                }
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
    }

    @Override
    public ExplosionInfo merge(ExplosionInfo left, ExplosionInfo right, MergeType mergeType) {
        return right;
    }

    public static class ExplosionInfo {
        @CodecBehavior.Optional
        public boolean destroyBlocks;
        @CodecBehavior.Optional
        public double chance;
        public double strength;
        @CodecBehavior.Optional
        public double entityStrength;
        @CodecBehavior.Optional
        public double entityMaxDamage;
        @CodecBehavior.Optional
        public double entityRadius;

        public class_5362 getCalculator() {
            return new BalancedExplosionDamage((float)this.entityStrength, (float)this.entityMaxDamage, (float)this.entityRadius, this.destroyBlocks);
        }

        public void explode(class_1937 world, class_1297 source, class_243 position) {
            world.method_46407(source, null, this.getCalculator(), position, (float)this.strength, false, class_1937.class_7867.field_40890);
        }
    }

    public static class BalancedExplosionDamage
    extends class_5362 {
        public float entityExplosionPower;
        public float entityRadius;
        public float entityMaxDamage;
        public boolean destroyBlock;

        public BalancedExplosionDamage(float entityExplosionPower, float entityRadius, float entityMaxDamage, boolean destroyBlocks) {
            this.entityExplosionPower = entityExplosionPower;
            this.entityRadius = entityRadius;
            this.entityMaxDamage = entityMaxDamage;
            this.destroyBlock = destroyBlocks;
        }

        public boolean method_29554(class_1927 explosion, class_1922 reader, class_2338 pos, class_2680 state, float power) {
            return this.destroyBlock;
        }

        public float method_55115(class_1927 explosion, class_1297 entity) {
            float f = this.entityRadius * 2.0f;
            class_243 vec3 = explosion.method_55109();
            double d = Math.sqrt(entity.method_5707(vec3)) / (double)f;
            double e = (1.0 - d) * (double)class_1927.method_17752((class_243)vec3, (class_1297)entity);
            return Math.min(this.entityMaxDamage, (float)((e * e + e) / 2.0 * (double)this.entityExplosionPower * (double)f + 1.0));
        }
    }
}

