/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.module.EntityMiapiModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class EntityModelProperty
extends CodecProperty<List<EntityModelData>> {
    public static final class_2960 KEY = Miapi.id("entity_model");
    public static EntityModelProperty property;

    public EntityModelProperty() {
        super(Codec.list(EntityModelData.CODEC));
        property = this;
        MiapiItemModel.modelSuppliers.add((key, mode, model, stack) -> {
            ArrayList models = new ArrayList();
            this.getData(model).ifPresent(entityModelDataList -> entityModelDataList.forEach(entityModelData -> {
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityModelData.id);
                class_1297 entity = entityType.method_5883((class_1937)class_310.method_1551().field_1687);
                if (entityModelData.nbt != null) {
                    entity.method_5651(entityModelData.nbt);
                }
                EntityMiapiModel entityMiapiModel = new EntityMiapiModel(entity, entityModelData.transform);
                entityMiapiModel.doTick = entityModelData.tick;
                entityMiapiModel.fullBright = entityModelData.fullBright;
                if (entityModelData.spin.isPresent()) {
                    entityMiapiModel.spinSettings = entityModelData.spin.get();
                }
                models.add(entityMiapiModel);
            }));
            return models;
        });
    }

    @Override
    public List<EntityModelData> merge(List<EntityModelData> left, List<EntityModelData> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    public static class EntityModelData {
        public class_2960 id;
        public class_2487 nbt;
        public Transform transform = Transform.IDENTITY;
        public boolean tick = false;
        public boolean fullBright = false;
        public Optional<MaterialIcons.SpinSettings> spin;
        public static Codec<EntityModelData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(data -> data.id), (App)class_2487.field_25128.optionalFieldOf("nbt", (Object)new class_2487()).forGetter(data -> data.nbt), (App)Transform.CODEC.optionalFieldOf("transform", (Object)Transform.IDENTITY).forGetter(data -> data.transform), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("tick", (Object)false).forGetter(data -> data.tick), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("fullBright", (Object)false).forGetter(data -> data.fullBright), (App)MaterialIcons.SpinSettings.CODEC.optionalFieldOf("spin").forGetter(data -> data.spin)).apply((Applicative)instance, (id, nbt, transform, tick, fullBright, spin) -> {
            EntityModelData data = new EntityModelData();
            data.id = id;
            data.nbt = nbt;
            data.transform = transform;
            data.tick = tick;
            data.fullBright = fullBright;
            data.spin = spin;
            return data;
        }));
    }
}

