/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render.colorproviders;

import com.redpxnda.nucleus.util.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_811;
import net.minecraft.class_9334;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.modules.ModuleInstance;

public interface ColorProvider {
    public static final Map<String, ColorProvider> colorProviders = new HashMap<String, ColorProvider>();

    public static void setup() {
        colorProviders.put("material", new MaterialColorProvider());
        colorProviders.put("model", new ModelColorProvider());
        colorProviders.put("potion", new PotionColorProvider());
        colorProviders.put("parent", new ParentColorProvider());
        colorProviders.put("item.material", new ItemMaterialColorProvider());
    }

    public static ColorProvider getProvider(String type, class_1799 itemStack, ModuleInstance moduleInstance) {
        ColorProvider base = colorProviders.getOrDefault(type, colorProviders.get("material"));
        return base.getInstance(itemStack, base.adapt(moduleInstance));
    }

    default public Optional<Color> getVertexColor() {
        return Optional.empty();
    }

    default public ModuleInstance adapt(ModuleInstance moduleInstance) {
        return moduleInstance;
    }

    @Environment(value=EnvType.CLIENT)
    public class_4588 getConsumer(class_4597 var1, class_1058 var2, class_1799 var3, ModuleInstance var4, class_811 var5);

    public ColorProvider getInstance(class_1799 var1, ModuleInstance var2);

    public static class MaterialColorProvider
    implements ColorProvider {
        public Material material;

        public MaterialColorProvider() {
        }

        public MaterialColorProvider(Material material) {
            this.material = material;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public class_4588 getConsumer(class_4597 vertexConsumers, class_1058 sprite, class_1799 stack, ModuleInstance moduleInstance, class_811 mode) {
            MaterialRenderController controller = this.material.getRenderController(moduleInstance, mode);
            return controller.getVertexConsumer(vertexConsumers, sprite, stack, moduleInstance, mode);
        }

        @Override
        public ColorProvider getInstance(class_1799 stack, ModuleInstance instance) {
            Material material1 = MaterialProperty.getMaterial(instance);
            if (material1 != null) {
                return new MaterialColorProvider(material1);
            }
            return new ModelColorProvider();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MaterialColorProvider that = (MaterialColorProvider)obj;
            return Objects.equals(this.material, that.material);
        }

        public int hashCode() {
            return Objects.hash(this.material);
        }
    }

    public static class ModelColorProvider
    implements ColorProvider {
        public ModelColorProvider() {
        }

        public ModelColorProvider(class_1799 stack) {
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public class_4588 getConsumer(class_4597 vertexConsumers, class_1058 sprite, class_1799 stack, ModuleInstance moduleInstance, class_811 mode) {
            return vertexConsumers.getBuffer(class_4696.method_23678((class_1799)stack, (boolean)true));
        }

        @Override
        public ColorProvider getInstance(class_1799 stack, ModuleInstance instance) {
            return new ModelColorProvider(stack);
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class PotionColorProvider
    implements ColorProvider {
        Color potioncolor;

        public PotionColorProvider() {
        }

        public PotionColorProvider(class_1799 stack) {
            this.potioncolor = !stack.method_57826(class_9334.field_49651) ? Color.WHITE : new Color(((class_1844)stack.method_57353().method_57829(class_9334.field_49651)).method_8064());
        }

        @Override
        public Optional<Color> getVertexColor() {
            return Optional.of(this.potioncolor);
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public class_4588 getConsumer(class_4597 vertexConsumers, class_1058 sprite, class_1799 stack, ModuleInstance moduleInstance, class_811 mode) {
            return vertexConsumers.getBuffer(class_4696.method_23678((class_1799)stack, (boolean)true));
        }

        @Override
        public ColorProvider getInstance(class_1799 stack, ModuleInstance instance) {
            return new PotionColorProvider(stack);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PotionColorProvider that = (PotionColorProvider)obj;
            return Objects.equals(this.potioncolor, that.potioncolor);
        }

        public int hashCode() {
            return Objects.hash(this.potioncolor);
        }
    }

    public static class ParentColorProvider
    extends MaterialColorProvider {
        @Override
        @Environment(value=EnvType.CLIENT)
        public class_4588 getConsumer(class_4597 vertexConsumers, class_1058 sprite, class_1799 stack, ModuleInstance moduleInstance, class_811 mode) {
            return this.material.getRenderController(moduleInstance, mode).getVertexConsumer(vertexConsumers, sprite, stack, moduleInstance, mode);
        }

        @Override
        public ColorProvider getInstance(class_1799 stack, ModuleInstance instance) {
            Material material1 = MaterialProperty.getMaterial(instance);
            if (material1 != null) {
                return new MaterialColorProvider(material1);
            }
            return new ModelColorProvider();
        }

        @Override
        public ModuleInstance adapt(ModuleInstance moduleInstance) {
            if (moduleInstance.parent != null) {
                return moduleInstance.parent;
            }
            return moduleInstance;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ParentColorProvider that = (ParentColorProvider)obj;
            return Objects.equals(this.material, that.material);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.material);
        }
    }

    public static class ItemMaterialColorProvider
    extends MaterialColorProvider {
        public Material material;
        public Material actualMaterial;
        public boolean needCheck = true;

        public ItemMaterialColorProvider() {
        }

        public ItemMaterialColorProvider(Material material) {
            this.material = material;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public class_4588 getConsumer(class_4597 vertexConsumers, class_1058 sprite, class_1799 stack, ModuleInstance moduleInstance, class_811 mode) {
            if (this.actualMaterial == null && this.needCheck) {
                this.actualMaterial = MaterialProperty.getMaterialFromIngredient(stack);
                this.needCheck = false;
            }
            if (this.actualMaterial != null) {
                return this.actualMaterial.getRenderController(moduleInstance, mode).getVertexConsumer(vertexConsumers, sprite, stack, moduleInstance, mode);
            }
            return this.material.getRenderController(moduleInstance, mode).getVertexConsumer(vertexConsumers, sprite, stack, moduleInstance, mode);
        }

        @Override
        public ColorProvider getInstance(class_1799 stack, ModuleInstance instance) {
            Material material1 = MaterialProperty.getMaterialFromIngredient(stack);
            if (material1 != null) {
                return new ItemMaterialColorProvider(material1);
            }
            return new ModelColorProvider();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ItemMaterialColorProvider that = (ItemMaterialColorProvider)obj;
            return Objects.equals(this.material, that.material);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.material);
        }
    }
}

