/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.tag;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.tag.ModuleTagLegacyProperty;
import smartin.miapi.modules.properties.tag.ModuleTagMaterialLegacyProperty;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class ModuleTagProperty
extends CodecProperty<List<String>> {
    public static final class_2960 KEY = Miapi.id("module_tag");
    public static ModuleTagProperty property;
    public static Codec<List<String>> CODEC;

    public ModuleTagProperty() {
        super(CODEC);
        property = this;
        PropertyResolver.register("material_property", (moduleInstance, oldMap) -> {
            Material material = MaterialProperty.getMaterial(moduleInstance);
            Map<Object, Object> returnMap = new HashMap(oldMap);
            if (material != null) {
                List<String> keys = ModuleTagProperty.getTags(moduleInstance);
                if (keys.isEmpty()) {
                    keys = List.of("default");
                }
                if (moduleInstance.getModule() != null) {
                    ArrayList newKeys = new ArrayList();
                    newKeys.add(moduleInstance.getModule().id().toString());
                    newKeys.addAll(keys);
                    keys = newKeys;
                }
                for (String key : keys) {
                    Map<ModuleProperty<?>, Object> materialProperties = PropertyResolver.setSource(material.materialProperties(key), (class_2561)class_2561.method_43469((String)"miapi.property.source.material", (Object[])new Object[]{material.getTranslation().getString()}).method_27692(class_124.field_1063));
                    if (materialProperties.isEmpty()) continue;
                    returnMap = PropertyResolver.merge(oldMap, materialProperties, MergeType.SMART);
                }
                Map<ModuleProperty<?>, Object> materialProperties = PropertyResolver.setSource(material.materialProperties(moduleInstance.moduleID.toString()), (class_2561)class_2561.method_43469((String)"miapi.property.source.material", (Object[])new Object[]{material.getTranslation().getString()}).method_27692(class_124.field_1063));
                if (!materialProperties.isEmpty()) {
                    returnMap = PropertyResolver.merge(oldMap, materialProperties, MergeType.SMART);
                }
            }
            return returnMap;
        });
    }

    public static List<String> getTags(class_1799 itemStack) {
        ArrayList<String> tags = new ArrayList<String>(property.getData(itemStack).orElse(new ArrayList()));
        tags.addAll(ModuleTagLegacyProperty.getTags(itemStack));
        tags.addAll(ModuleTagMaterialLegacyProperty.getTags(itemStack));
        return tags;
    }

    public static List<String> getTags(ModuleInstance instance) {
        ArrayList<String> tags = new ArrayList<String>(property.getData(instance).orElse(new ArrayList()));
        tags.addAll(ModuleTagLegacyProperty.getTags(instance));
        tags.addAll(ModuleTagMaterialLegacyProperty.getTags(instance));
        return tags;
    }

    public static List<String> getTags(ItemModule module) {
        ArrayList<String> tags = new ArrayList<String>(property.getData(module).orElse(new ArrayList()));
        tags.addAll(ModuleTagLegacyProperty.getTags(module));
        tags.addAll(ModuleTagMaterialLegacyProperty.getTags(module));
        return tags;
    }

    public static List<String> getTags(Map<ModuleProperty<?>, Object> properties) {
        ArrayList<String> tags = new ArrayList<String>(ModuleTagProperty.getTags(properties, property));
        tags.addAll(ModuleTagProperty.getTags(properties, ModuleTagLegacyProperty.property));
        tags.addAll(ModuleTagProperty.getTags(properties, ModuleTagMaterialLegacyProperty.property));
        return tags;
    }

    public static List<String> getTags(Map<ModuleProperty<?>, Object> properties, CodecProperty<List<String>> property) {
        List tags = (List)properties.get(property);
        if (tags == null) {
            return List.of();
        }
        return tags;
    }

    public static List<ItemModule> getModulesWithTag(String tag) {
        ArrayList<ItemModule> modules = new ArrayList<ItemModule>();
        RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.getFlatMap().forEach((key, module) -> {
            if (ModuleTagProperty.getTags(module).contains(tag)) {
                modules.add((ItemModule)module);
            }
        });
        return modules;
    }

    @Override
    public List<String> merge(List<String> left, List<String> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    static {
        CODEC = Codec.list((Codec)Codec.STRING);
    }
}

