/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.SourceSetter;

public class DoubleOperationResolvable
implements SourceSetter<DoubleOperationResolvable> {
    static Codec<IndividualOperation> autoCodec = AutoCodec.of(IndividualOperation.class).codec();
    static Codec<IndividualOperation> operationCodec = Codec.withAlternative((Codec)new Codec<IndividualOperation>(){

        public <T> DataResult<T> encode(IndividualOperation input, DynamicOps<T> ops, T prefix) {
            return autoCodec.encode((Object)input, ops, prefix);
        }

        public <T> DataResult<Pair<IndividualOperation, T>> decode(DynamicOps<T> ops, T input) {
            DataResult result = IndividualOperation.NUMBERSTRINGCODEC.decode(ops, input);
            if (result.isError()) {
                DataResult doubleResult = Codec.DOUBLE.decode(ops, input);
                if (doubleResult.isSuccess()) {
                    Pair doubleTPair = (Pair)doubleResult.getOrThrow();
                    return DataResult.success((Object)new Pair((Object)new IndividualOperation(String.valueOf(doubleTPair.getFirst())), doubleTPair.getSecond()));
                }
                return DataResult.error(() -> "is neither a string nor a boolean or a number");
            }
            Pair stringTPair = (Pair)result.getOrThrow();
            return DataResult.success((Object)new Pair((Object)new IndividualOperation((String)stringTPair.getFirst()), stringTPair.getSecond()));
        }
    }, autoCodec);
    static Codec<List<IndividualOperation>> listCodec = Codec.list(operationCodec);
    public static Codec<DoubleOperationResolvable> CODEC = Codec.withAlternative((Codec)new Codec<DoubleOperationResolvable>(){

        public <T> DataResult<T> encode(DoubleOperationResolvable input, DynamicOps<T> ops, T prefix) {
            List<IndividualOperation> opsToEncode = input.operations.isEmpty() ? List.of(new IndividualOperation("" + input.fallback)) : input.operations;
            return listCodec.encode(opsToEncode, ops, prefix);
        }

        public <T> DataResult<Pair<DoubleOperationResolvable, T>> decode(DynamicOps<T> ops, T input) {
            DataResult result = operationCodec.decode(ops, input);
            if (result.isError()) {
                return DataResult.error(() -> "could not decode double operations");
            }
            Pair pair = (Pair)result.getOrThrow();
            return DataResult.success((Object)new Pair((Object)new DoubleOperationResolvable(List.of((IndividualOperation)pair.getFirst())), pair.getSecond()));
        }
    }, (Codec)new Codec<DoubleOperationResolvable>(){

        public <T> DataResult<T> encode(DoubleOperationResolvable input, DynamicOps<T> ops, T prefix) {
            List<IndividualOperation> opsToEncode = input.operations.isEmpty() ? List.of(new IndividualOperation("" + input.fallback)) : input.operations;
            return listCodec.encode(opsToEncode, ops, prefix);
        }

        public <T> DataResult<Pair<DoubleOperationResolvable, T>> decode(DynamicOps<T> ops, T input) {
            Pair pair = (Pair)listCodec.decode(ops, input).getOrThrow(e -> new RuntimeException(e + "could not decode double operations"));
            return DataResult.success((Object)new Pair((Object)new DoubleOperationResolvable((List)pair.getFirst()), pair.getSecond()));
        }
    });
    public List<IndividualOperation> operations;
    protected Function<Pair<String, ModuleInstance>, String> functionTransformer = Pair::getFirst;
    Double cachedResult = null;
    double baseValue = 0.0;
    double fallback = 0.0;
    ModuleInstance initialized;

    public DoubleOperationResolvable(double fallback) {
        this.fallback = fallback;
        this.operations = new ArrayList<IndividualOperation>();
    }

    public DoubleOperationResolvable(List<IndividualOperation> operations) {
        this.operations = operations;
    }

    protected DoubleOperationResolvable(List<IndividualOperation> operations, Function<Pair<String, ModuleInstance>, String> functionTransformer) {
        this.operations = operations;
        this.functionTransformer = functionTransformer;
    }

    public double getValue() {
        return this.evaluate(this.baseValue, this.fallback);
    }

    public double getFallback() {
        return this.fallback;
    }

    public void setFunctionTransformer(Function<Pair<String, ModuleInstance>, String> functionTransformer) {
        this.functionTransformer = functionTransformer;
        for (IndividualOperation operation : this.operations) {
            operation.transformer = this.functionTransformer;
        }
        this.cachedResult = null;
    }

    public Function<Pair<String, ModuleInstance>, String> getFunctionTransformer() {
        return this.functionTransformer;
    }

    public DoubleOperationResolvable initialize(ModuleInstance moduleInstance) {
        ArrayList<IndividualOperation> operationList = new ArrayList<IndividualOperation>();
        if (this.operations != null) {
            this.operations.forEach(operation -> {
                IndividualOperation copiesOperation = new IndividualOperation(operation.value);
                copiesOperation.attributeOperation = operation.attributeOperation;
                copiesOperation.instance = moduleInstance;
                copiesOperation.transformer = this.functionTransformer;
                copiesOperation.source = operation.source;
                operationList.add(copiesOperation);
            });
        }
        DoubleOperationResolvable initialized = new DoubleOperationResolvable(operationList, this.functionTransformer);
        initialized.fallback = this.fallback;
        initialized.getValue();
        initialized.initialized = moduleInstance;
        return initialized;
    }

    public double evaluate(double baseValue, double fallback) {
        return this.evaluate(baseValue).orElse(fallback);
    }

    public void clearCache() {
        this.cachedResult = null;
    }

    public Optional<Double> evaluate(double baseValue) {
        if (this.cachedResult == null || baseValue != this.baseValue) {
            DoubleOperationResolvable.resolve(this.operations, baseValue).ifPresent(result -> {
                this.cachedResult = result;
            });
        }
        return Optional.ofNullable(this.cachedResult);
    }

    public static double resolve(List<IndividualOperation> operations, double baseValue, double fallback) {
        return DoubleOperationResolvable.resolve(operations, baseValue).orElse(fallback);
    }

    public static Optional<Double> resolve(List<IndividualOperation> operations, double baseValue) {
        double value = baseValue;
        boolean hasValue = false;
        ArrayList<Double> addition = new ArrayList<Double>();
        ArrayList<Double> multiplyBase = new ArrayList<Double>();
        ArrayList<Double> multiplyTotal = new ArrayList<Double>();
        ArrayList<IndividualOperation> custom = new ArrayList<IndividualOperation>();
        for (IndividualOperation operation : operations) {
            hasValue = true;
            switch (operation.attributeOperation.ordinal()) {
                case 0: {
                    addition.add(operation.solve());
                    break;
                }
                case 1: {
                    multiplyBase.add(operation.solve());
                    break;
                }
                case 2: {
                    multiplyTotal.add(operation.solve());
                    break;
                }
                case 3: {
                    custom.add(operation);
                }
            }
        }
        for (Double currentValue : addition) {
            value += currentValue.doubleValue();
        }
        double multiplier = 1.0;
        for (Double currentValue : multiplyBase) {
            multiplier += currentValue.doubleValue();
        }
        value *= multiplier;
        for (Double currentValue : multiplyTotal) {
            value = (currentValue + 1.0) * value;
        }
        if (hasValue) {
            if (Double.isNaN(value)) {
                Miapi.LOGGER.error("could not correctly resolve Double Operations. this indicates a serious issue");
                return Optional.empty();
            }
            for (IndividualOperation operation : custom) {
                value = operation.solve(value);
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public boolean isTrue() {
        return this.getValue() > 0.0;
    }

    public DoubleOperationResolvable merge(DoubleOperationResolvable left, MergeType mergeType) {
        return DoubleOperationResolvable.merge(this, left, mergeType);
    }

    public static DoubleOperationResolvable merge(DoubleOperationResolvable left, DoubleOperationResolvable right, MergeType mergeType) {
        Function<Pair<String, ModuleInstance>, String> functionTransformer = right.functionTransformer;
        if (MergeType.OVERWRITE.equals((Object)mergeType)) {
            return right;
        }
        if (MergeType.EXTEND.equals((Object)mergeType)) {
            functionTransformer = left.functionTransformer;
        }
        ArrayList<IndividualOperation> operationList = new ArrayList<IndividualOperation>(left.operations);
        operationList.addAll(right.operations);
        DoubleOperationResolvable resolvable = new DoubleOperationResolvable(operationList, functionTransformer);
        if (left.initialized != null) {
            resolvable.initialize(left.initialized);
        }
        return new DoubleOperationResolvable(operationList, functionTransformer);
    }

    @Override
    public DoubleOperationResolvable setSource(DoubleOperationResolvable data, class_2561 source) {
        data.operations.forEach(op -> {
            op.source = Optional.of(source);
        });
        return data;
    }

    public static class IndividualOperation {
        public static Codec<Operation> operationCodec = new Codec<Operation>(){

            public <T> DataResult<Pair<Operation, T>> decode(DynamicOps<T> ops, T input) {
                Pair stringTPair = (Pair)Codec.STRING.decode(ops, input).getOrThrow();
                Operation operations = IndividualOperation.getOperation((String)stringTPair.getFirst());
                return DataResult.success((Object)new Pair((Object)operations, stringTPair.getSecond()));
            }

            public <T> DataResult<T> encode(Operation input, DynamicOps<T> ops, T prefix) {
                return Codec.STRING.encode((Object)IndividualOperation.toCodecString(input), ops, prefix);
            }
        };
        public static Codec<String> NUMBERSTRINGCODEC = new Codec<String>(){

            public <T> DataResult<Pair<String, T>> decode(DynamicOps<T> ops, T input) {
                DataResult numberResult = ops.getNumberValue(input);
                if (numberResult.isSuccess()) {
                    return DataResult.success((Object)new Pair((Object)((Number)numberResult.getOrThrow()).toString(), input));
                }
                DataResult boolResult = ops.getBooleanValue(input);
                if (boolResult.isSuccess()) {
                    return DataResult.success((Object)new Pair((Object)((Boolean)boolResult.getOrThrow() != false ? "1" : "-1"), input));
                }
                DataResult stringResult = ops.getStringValue(input);
                if (stringResult.isSuccess()) {
                    if (((String)stringResult.getOrThrow()).equals("true")) {
                        return DataResult.success((Object)new Pair((Object)"1", input));
                    }
                    if (((String)stringResult.getOrThrow()).equals("false")) {
                        return DataResult.success((Object)new Pair((Object)"-1", input));
                    }
                    return DataResult.success((Object)new Pair((Object)((String)stringResult.getOrThrow()), input));
                }
                DataResult decodeDouble = Codec.DOUBLE.decode(ops, input);
                if (decodeDouble.isSuccess()) {
                    Pair doubleTPair = (Pair)decodeDouble.getOrThrow();
                    return DataResult.success((Object)new Pair((Object)String.valueOf(doubleTPair.getFirst()), input));
                }
                DataResult decodeString = Codec.STRING.decode(ops, input);
                if (decodeString.isSuccess()) {
                    Pair pair = (Pair)decodeString.getOrThrow();
                    return DataResult.success((Object)new Pair((Object)((String)pair.getFirst()), input));
                }
                DataResult decodeBoolean = Miapi.FIXED_BOOL_CODEC.decode(ops, input);
                if (decodeBoolean.isSuccess()) {
                    return DataResult.success((Object)new Pair((Object)((Boolean)((Pair)decodeBoolean.getOrThrow()).getFirst() != false ? "1" : "-1"), input));
                }
                return DataResult.error(() -> "is neither a string nor a boolean or a number");
            }

            public <T> DataResult<T> encode(String input, DynamicOps<T> ops, T prefix) {
                return Codec.STRING.encode((Object)input, ops, prefix);
            }
        };
        @AutoCodec.Name(value="operation")
        @CodecBehavior.Override(value="operationCodec")
        public Operation attributeOperation = Operation.ADD_VALUE;
        @AutoCodec.Name(value="value")
        @CodecBehavior.Override(value="NUMBERSTRINGCODEC")
        public String value;
        @AutoCodec.Ignored
        public ModuleInstance instance;
        @AutoCodec.Ignored
        public Function<Pair<String, ModuleInstance>, String> transformer = Pair::getFirst;
        @AutoCodec.Ignored
        public Optional<class_2561> source = Optional.empty();

        public IndividualOperation() {
            this.value = "1";
        }

        public IndividualOperation(double value, Operation operation) {
            this.value = String.valueOf(value);
            this.attributeOperation = operation;
        }

        public IndividualOperation(String value) {
            this.value = value;
        }

        public double solve() {
            if (this.instance == null) {
                IllegalAccessError error = new IllegalAccessError("Double Resolvable was resolved before initialized!");
                Miapi.LOGGER.error("Double Resolvable was never initialized!", (Throwable)error);
                return 0.0;
            }
            String transformed = this.transformer.apply((Pair<String, ModuleInstance>)new Pair((Object)this.value, (Object)this.instance));
            return StatResolver.resolveDouble(transformed, this.instance);
        }

        public double solve(double oldValue) {
            if (this.instance == null) {
                IllegalAccessError error = new IllegalAccessError("Double Resolvable was resolved before initialized!");
                Miapi.LOGGER.error("Double Resolvable was never initialized!", (Throwable)error);
                return 0.0;
            }
            String transformed = this.transformer.apply((Pair<String, ModuleInstance>)new Pair((Object)this.value, (Object)this.instance)).replace("[old_value]", "" + oldValue);
            return StatResolver.resolveDouble(transformed, this.instance);
        }

        public static Operation getOperation(String operationString) {
            return switch (operationString) {
                case "*" -> Operation.ADD_MULTIPLIED_BASE;
                case "**" -> Operation.ADD_MULTIPLIED_TOTAL;
                case "custom" -> Operation.CUSTOM_TOTAL;
                default -> Operation.ADD_VALUE;
            };
        }

        private static String toCodecString(Operation operation) {
            return switch (operation.ordinal()) {
                case 1 -> "*";
                case 2 -> "**";
                case 3 -> "custom";
                default -> "+";
            };
        }

        public static enum Operation implements class_3542
        {
            ADD_VALUE("add_value", 0),
            ADD_MULTIPLIED_BASE("add_multiplied_base", 1),
            ADD_MULTIPLIED_TOTAL("add_multiplied_total", 2),
            CUSTOM_TOTAL("custom", 3);

            private final String name;
            private final int id;

            private Operation(String name, int value) {
                this.name = name;
                this.id = value;
            }

            public int id() {
                return this.id;
            }

            public String method_15434() {
                return this.name;
            }
        }
    }
}

