/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.synergies;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.PropertyHolder;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.properties.tag.ModuleTagProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.modules.synergies.MaterialSynergy;
import smartin.miapi.modules.synergies.ModuleSynergy;
import smartin.miapi.modules.synergies.TagSynergy;

public class SynergyManager {
    public static final Map<class_2960, MapCodec<? extends Synergy>> SYNERGY_TYPE_REGISTRY = new ConcurrentHashMap<class_2960, MapCodec<? extends Synergy>>();
    protected static final Map<class_2960, List<Synergy>> moduleSynergies = new ConcurrentHashMap<class_2960, List<Synergy>>();
    protected static final Map<class_2960, List<Synergy>> materialSynergies = new ConcurrentHashMap<class_2960, List<Synergy>>();
    protected static final Map<String, List<Synergy>> tagSynergies = new ConcurrentHashMap<String, List<Synergy>>();
    public static final Codec<Synergy> SYNERGY_CODEC = Miapi.ID_CODEC.dispatch(Synergy::getType, SynergyManager::getType);

    public static void setup() {
        SYNERGY_TYPE_REGISTRY.put(Miapi.id("module"), ModuleSynergy.CODEC);
        SYNERGY_TYPE_REGISTRY.put(Miapi.id("material"), MaterialSynergy.CODEC);
        SYNERGY_TYPE_REGISTRY.put(Miapi.id("tag"), TagSynergy.CODEC);
        PropertyResolver.register("synergies", (moduleInstance, oldMap) -> {
            if (moduleInstance != null) {
                List<Synergy> materialSynergy;
                List<Synergy> synergies = moduleSynergies.get(moduleInstance.getModule().id());
                if (synergies != null) {
                    for (Synergy synergy : synergies) {
                        oldMap = synergy.apply(moduleInstance, oldMap);
                    }
                }
                for (String tag : ModuleTagProperty.getTags(moduleInstance)) {
                    List<Synergy> tagSynergy = tagSynergies.get(tag);
                    if (tagSynergy == null) continue;
                    for (Synergy synergy : tagSynergy) {
                        oldMap = synergy.apply(moduleInstance, oldMap);
                    }
                }
                Material material = MaterialProperty.getMaterial(moduleInstance);
                if (material != null && (materialSynergy = materialSynergies.get(material.getID())) != null) {
                    for (Synergy synergy : materialSynergy) {
                        oldMap = synergy.apply(moduleInstance, oldMap);
                    }
                }
            }
            return oldMap;
        });
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            int totalSynergies = moduleSynergies.values().stream().mapToInt(List::size).sum() + materialSynergies.values().stream().mapToInt(List::size).sum() + tagSynergies.values().stream().mapToInt(List::size).sum();
            Miapi.LOGGER.info("Loaded " + totalSynergies + " Synergies");
        });
    }

    public static MapCodec<? extends Synergy> getType(class_2960 id) {
        MapCodec<? extends Synergy> codec = SYNERGY_TYPE_REGISTRY.get(id);
        if (codec == null) {
            try {
                throw new DecoderException("Synergy Type " + String.valueOf(id) + " does not exist!");
            }
            catch (DecoderException e) {
                throw new RuntimeException(e);
            }
        }
        return codec;
    }

    public static void clear() {
        moduleSynergies.clear();
        materialSynergies.clear();
        tagSynergies.clear();
    }

    public static abstract class Synergy {
        protected ModuleCondition condition;
        protected PropertyHolder holder;
        protected class_2960 id;

        protected abstract class_2960 getType();

        public abstract void register();

        public Map<ModuleProperty<?>, Object> apply(ModuleInstance moduleInstance, Map<ModuleProperty<?>, Object> properties) {
            if (this.condition.isAllowed(ConditionManager.moduleContext(moduleInstance, properties))) {
                return this.holder.applyHolder(properties, Optional.of(class_2561.method_43471((String)"miapi.property.source.synergy")));
            }
            return properties;
        }
    }
}

