/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.upgrade;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_9135;
import net.minecraft.class_9331;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadHelpers;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.PropertyHolder;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;
import smartin.miapi.upgrade.UpgradeEditOption;

public record Upgrade(String moduleTag, ModuleCondition condition, Map<Integer, PropertyHolder> properties, List<class_2960> incompatible, int max, int cost) {
    public static final MiapiRegistry<Upgrade> UPGRADE_MIAPI_REGISTRY = MiapiRegistry.getInstance(Upgrade.class);
    public static final class_2960 upgradeId = Miapi.id("upgrade");
    public static final Codec<Integer> INT_CODEC = Codec.withAlternative((Codec)Codec.STRING.xmap(Integer::valueOf, i -> "" + i), (Codec)Codec.INT);
    public static final Codec<Upgrade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("tag").forGetter(Upgrade::moduleTag), (App)ConditionManager.CONDITION_CODEC_DIRECT.fieldOf("condition").forGetter(Upgrade::condition), (App)Codec.unboundedMap(INT_CODEC, (Codec)PropertyHolder.MAP_CODEC.codec()).fieldOf("properties").forGetter(Upgrade::properties), (App)class_2960.field_25139.listOf().optionalFieldOf("incompatible", List.of()).forGetter(Upgrade::incompatible), (App)INT_CODEC.optionalFieldOf("max", (Object)0).forGetter(Upgrade::max), (App)INT_CODEC.optionalFieldOf("cost", (Object)1).forGetter(Upgrade::cost)).apply((Applicative)instance, Upgrade::new));
    public static final Codec<Map<class_2960, Integer>> MODULE_UPGRADE_ID_CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, INT_CODEC);
    public static class_9331<Integer> COMPONENT = class_9331.method_57873().method_57881(class_5699.field_33441).method_57882(class_9135.field_48550).method_57880();

    public static int xpCost(int oldUpgrades) {
        return (int)Math.pow(2.0, oldUpgrades) * 10 + 100;
    }

    public class_2561 name() {
        class_2960 id = this.getID();
        return class_2561.method_43471((String)("miapi.upgrade." + id.toString().replace(":", ".")));
    }

    public class_2561 description() {
        class_2960 id = this.getID();
        return class_2561.method_43471((String)("miapi.upgrade." + id.toString().replace(":", ".") + ".description"));
    }

    public class_2960 getID() {
        return UPGRADE_MIAPI_REGISTRY.findKey(this);
    }

    public boolean isAllowed(Collection<Upgrade> upgrades) {
        return upgrades.stream().filter(upgrade -> this.incompatible().contains(upgrade.getID())).findAny().isEmpty();
    }

    public static void setup() {
        ReloadHelpers.registerReloadHandler("miapi/upgrade", UPGRADE_MIAPI_REGISTRY, CODEC, 0.0f);
        RegistryInventory.EDIT_OPTION_MIAPI_REGISTRY.register(Miapi.id("module_upgrades"), (EditOption)new UpgradeEditOption());
        StatResolver.registerResolver("module_upgrade", (data, instance) -> {
            if (instance.moduleData.containsKey(upgradeId)) {
                class_2960 id = Miapi.id(data.replaceFirst("\\.", ":"));
                Pair levelMap = (Pair)MODULE_UPGRADE_ID_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)instance.moduleData.get(upgradeId)).getOrThrow(s -> new DecoderException("Could not decode UpgradeID " + s));
                return ((Map)levelMap.getFirst()).getOrDefault(id, 0).intValue();
            }
            return 0.0;
        });
        RegistryInventory.COMPONENT_TYPE_REGISTRAR.register(Miapi.id("module_upgrade_xp"), () -> COMPONENT);
        MiapiEvents.MODULAR_ITEM_DAMAGE.register((damage, itemStack, level) -> itemStack.method_57368(COMPONENT, (Object)0, old -> old + damage));
        PropertyResolver.register("miapi/upgrade", (moduleInstance, oldMap) -> {
            AtomicReference map = new AtomicReference(new ConcurrentHashMap(oldMap));
            JsonElement json = moduleInstance.moduleData.get(upgradeId);
            if (json != null) {
                MODULE_UPGRADE_ID_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().ifPresent(upgrades -> {
                    for (class_2960 upgradeId : upgrades.keySet()) {
                        int level = (Integer)upgrades.get(upgradeId);
                        Upgrade upgrade = UPGRADE_MIAPI_REGISTRY.get(upgradeId);
                        if (upgrade == null) continue;
                        PropertyHolder selectedHolder = null;
                        int bestLevel = Integer.MIN_VALUE;
                        for (Map.Entry<Integer, PropertyHolder> entry : upgrade.properties().entrySet()) {
                            int keyLevel = entry.getKey();
                            if (keyLevel > level || keyLevel <= bestLevel) continue;
                            bestLevel = keyLevel;
                            selectedHolder = entry.getValue();
                        }
                        if (selectedHolder == null) continue;
                        map.set(selectedHolder.applyHolder((Map)map.get(), Optional.of(upgrade.name())));
                    }
                });
            }
            return map.get();
        });
    }
}

