/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.upgrade;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.MiapiPermissions;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.upgrade.Upgrade;
import smartin.miapi.upgrade.UpgradeEditView;
import smartin.miapi.upgrade.UpgradeSelection;

public class UpgradeEditOption
implements EditOption {
    @Override
    public class_1799 preview(class_2540 buffer, EditOption.EditContext editContext) {
        int currentLevel;
        UpgradeSelection selection = (UpgradeSelection)UpgradeSelection.STREAM_CODEC.decode((Object)buffer);
        Upgrade upgrade = Upgrade.UPGRADE_MIAPI_REGISTRY.get(selection.upgradeId());
        if (upgrade == null) {
            return editContext.getItemstack();
        }
        class_1799 itemStack = editContext.getItemstack().method_7972();
        ModuleInstance instance = selection.resolveModule(itemStack).orElse(null);
        if (instance == null) {
            return itemStack;
        }
        ConditionManager.ConditionContext conditionCtx = ConditionManager.playerContext(instance, editContext.getPlayer(), instance.properties);
        if (!upgrade.condition().isAllowed(conditionCtx)) {
            return itemStack;
        }
        instance.clearCaches();
        instance = instance.copy();
        HashMap<class_2960, Integer> rawUpgradeMap = new HashMap<class_2960, Integer>();
        if (instance.moduleData.containsKey(Upgrade.upgradeId)) {
            Upgrade.MODULE_UPGRADE_ID_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)instance.moduleData.get(Upgrade.upgradeId)).result().ifPresent(pair -> rawUpgradeMap.putAll((Map)pair.getFirst()));
        }
        if ((currentLevel = rawUpgradeMap.getOrDefault(selection.upgradeId(), 0).intValue()) >= upgrade.max()) {
            return itemStack;
        }
        int xpCost = 0;
        for (int i = 0; i < upgrade.cost(); ++i) {
            xpCost += Upgrade.xpCost(UpgradeEditOption.getTotalUpgradeLevel(itemStack) + i);
        }
        int currentXP = this.getItemXP(itemStack);
        if (currentXP < xpCost) {
            return itemStack;
        }
        this.setItemXP(itemStack, currentXP - xpCost);
        rawUpgradeMap.put(selection.upgradeId(), currentLevel + 1);
        instance.moduleData.put(Upgrade.upgradeId, (JsonElement)Upgrade.MODULE_UPGRADE_ID_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, rawUpgradeMap).getOrThrow());
        instance.getRoot().writeToItem(itemStack);
        instance.clearCaches();
        ComponentApplyProperty.updateItemStack(itemStack, editContext.getPlayer().method_56673());
        return itemStack;
    }

    @Override
    public boolean isVisible(EditOption.EditContext editContext) {
        return VisualModularItem.isVisualModularItem(editContext.getItemstack()) && MiapiPermissions.hasPerm(editContext.getPlayer(), "upgrade");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InteractAbleWidget getGui(int x, int y, int width, int height, EditOption.EditContext editContext) {
        return new UpgradeEditView(x, y, width, height, editContext, selection -> {
            class_2540 buffer = Networking.createBuffer();
            UpgradeSelection.STREAM_CODEC.encode((Object)buffer, selection);
            editContext.preview(buffer);
        }, selection -> {
            class_2540 buffer = Networking.createBuffer();
            UpgradeSelection.STREAM_CODEC.encode((Object)buffer, selection);
            editContext.craft(buffer);
        });
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InteractAbleWidget getIconGui(int x, int y, int width, int height, Consumer<EditOption> select, Supplier<EditOption> getSelected) {
        return new EditOptionIcon(x, y, width, height, select, getSelected, CraftingScreen.BACKGROUND_TEXTURE, 339, 220, 512, 512, "miapi.ui.edit_option.hover.upgrade", this);
    }

    private int getItemXP(class_1799 stack) {
        return (Integer)stack.method_57825(Upgrade.COMPONENT, (Object)0);
    }

    private void setItemXP(class_1799 stack, int newXP) {
        stack.method_57379(Upgrade.COMPONENT, (Object)Math.max(newXP, 0));
    }

    public static int getTotalUpgradeLevel(class_1799 stack) {
        int total = 0;
        for (ModuleInstance instance : ItemModule.getModules(stack).allSubModules()) {
            Optional decodeResult;
            if (!instance.moduleData.containsKey(Upgrade.upgradeId) || !(decodeResult = Upgrade.MODULE_UPGRADE_ID_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)instance.moduleData.get(Upgrade.upgradeId)).result()).isPresent()) continue;
            Map map = (Map)((Pair)decodeResult.get()).getFirst();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                int level = (Integer)iterator.next();
                total += level;
            }
        }
        return total;
    }
}

