/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.upgrade;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.tag.ModuleTagProperty;
import smartin.miapi.upgrade.Upgrade;
import smartin.miapi.upgrade.UpgradeEditOption;
import smartin.miapi.upgrade.UpgradeSelection;

@Environment(value=EnvType.CLIENT)
public class UpgradeEditView
extends InteractAbleWidget {
    private final ScrollList scrollList;
    private final List<InteractAbleWidget> upgradeButtons = new ArrayList<InteractAbleWidget>();
    private final EditOption.EditContext context;
    private final Consumer<UpgradeSelection> onChange;
    private final Consumer<UpgradeSelection> onCraft;
    private UpgradeSelection lastSelected = null;
    private int availableXP = 0;
    private int usedLevels = 0;
    int maxToNextLevel = 0;
    private int availablePoints = 0;
    int currentLVLXp = 0;

    public UpgradeEditView(int x, int y, int width, int height, EditOption.EditContext context, Consumer<UpgradeSelection> onChange, Consumer<UpgradeSelection> onCraft) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        int xpToNextPoint;
        this.context = context;
        this.onChange = onChange;
        this.onCraft = onCraft;
        this.scrollList = new ScrollList(x, y, width, height - 24, this.upgradeButtons);
        this.addChild(this.scrollList);
        this.availableXP = this.getItemXP(context.getItemstack());
        this.usedLevels = UpgradeEditOption.getTotalUpgradeLevel(context.getItemstack());
        int xp = this.availableXP;
        int simulatedLevel = this.usedLevels;
        int upgradePoints = 0;
        int upgradeCost = Upgrade.xpCost(simulatedLevel);
        while (xp >= upgradeCost && xp > 0) {
            xp -= upgradeCost;
            ++upgradePoints;
            upgradeCost = Upgrade.xpCost(++simulatedLevel);
        }
        final int points = upgradePoints;
        this.maxToNextLevel = xpToNextPoint = Upgrade.xpCost(simulatedLevel) - xp;
        this.availablePoints = points;
        this.currentLVLXp = xp;
        this.addChild(new InteractAbleWidget(this, x + 4, y + height - 13, 100, 12, (class_2561)class_2561.method_43470((String)"")){

            @Override
            public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
                drawContext.method_51433(class_310.method_1551().field_1772, "Points: " + points, this.method_46426(), this.method_46427(), 0xFFFFFF, false);
            }
        });
        final int simulatedFinal = simulatedLevel;
        this.addChild(new InteractAbleWidget(this, x + width - 84, y + height - 15, 30, 12, (class_2561)class_2561.method_43470((String)"")){

            @Override
            public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
                int costForNext = Upgrade.xpCost(simulatedFinal);
                int progress = (int)((double)(costForNext - xpToNextPoint) / (double)costForNext * 100.0);
                int barWidth = (int)((double)progress / 100.0 * 30.0);
                drawContext.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + 30, this.method_46427() + 10, -11184811);
                drawContext.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + barWidth, this.method_46427() + 10, -16711936);
                drawContext.method_51433(class_310.method_1551().field_1772, progress + "%", this.method_46426() + 5, this.method_46427() + 2, -1, false);
            }
        });
        this.populateUpgrades(upgradePoints);
        SimpleButton<Void> applyButton = new SimpleButton<Void>(x + width - 45, y + height - 18, 40, 16, (class_2561)class_2561.method_43471((String)"miapi.ui.apply"), null, callback -> {
            if (this.lastSelected != null) {
                this.onCraft.accept(this.lastSelected);
            }
        });
        this.addChild(applyButton);
    }

    private void populateUpgrades(final int points) {
        this.upgradeButtons.clear();
        class_1799 itemStack = this.context.getItemstack();
        List<ModuleInstance> modules = ItemModule.getModules(itemStack).allSubModules();
        for (ModuleInstance instance : modules) {
            Object decodeResult;
            ArrayList<3> buttonsForModule = new ArrayList<3>();
            ConditionManager.ConditionContext ctx = ConditionManager.playerContext(instance, this.context.getPlayer(), instance.properties);
            Map upgradeMap = Map.of();
            ArrayList<Upgrade> existingUpgrades = new ArrayList<Upgrade>();
            if (instance.moduleData.containsKey(Upgrade.upgradeId) && ((Optional)(decodeResult = Upgrade.MODULE_UPGRADE_ID_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)instance.moduleData.get(Upgrade.upgradeId)).result())).isPresent()) {
                upgradeMap = (Map)((Pair)((Optional)decodeResult).get()).getFirst();
                for (class_2960 existingId : upgradeMap.keySet()) {
                    Upgrade existingUpgrade = Upgrade.UPGRADE_MIAPI_REGISTRY.get(existingId);
                    if (existingUpgrade == null) continue;
                    existingUpgrades.add(existingUpgrade);
                }
            }
            decodeResult = Upgrade.UPGRADE_MIAPI_REGISTRY.getFlatMap().entrySet().iterator();
            while (decodeResult.hasNext()) {
                Map.Entry<class_2960, Upgrade> entry = decodeResult.next();
                class_2960 upgradeId = entry.getKey();
                final Upgrade upgrade = entry.getValue();
                int currentLevel = upgradeMap.getOrDefault(upgradeId, 0);
                if (!upgrade.condition().isAllowed(ctx) || currentLevel >= upgrade.max() || !upgrade.isAllowed(existingUpgrades) || !ModuleTagProperty.getTags(instance).contains(upgrade.moduleTag())) continue;
                UpgradeSelection selection = new UpgradeSelection(instance, upgradeId);
                SimpleButton<UpgradeSelection> button = new SimpleButton<UpgradeSelection>(this.method_46426() + 10, 0, this.method_25368() - 16, 16, (class_2561)upgrade.name().method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"miapi.upgrade.cost", (Object[])new Object[]{upgrade.cost()})), selection, sel -> {
                    this.lastSelected = sel;
                    this.onChange.accept((UpgradeSelection)sel);
                }){

                    @Override
                    public void renderHover(class_332 drawContext, int mouseX, int mouseY, float delta) {
                        super.renderHover(drawContext, mouseX, mouseY, delta);
                        if (this.method_25405(mouseX, mouseY) && UpgradeEditView.this.scrollList.method_25405(mouseX, mouseY)) {
                            drawContext.method_51437(class_310.method_1551().field_1772, points >= upgrade.cost() ? List.of(upgrade.description()) : List.of(class_2561.method_43471((String)"miapi.upgrade.cannot.afford"), upgrade.description()), Optional.empty(), mouseX, mouseY);
                        }
                    }
                };
                button.isEnabled = points >= upgrade.cost();
                buttonsForModule.add(button);
            }
            if (buttonsForModule.isEmpty()) continue;
            InteractAbleWidget moduleLabel = new InteractAbleWidget(this, this.method_46426() + 2, 0, this.method_25368() - 4, 16, (class_2561)class_2561.method_43470((String)instance.getModuleName().getString()).method_27694(style -> style.method_10982(Boolean.valueOf(true)))){

                @Override
                public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
                    drawContext.method_51439(class_310.method_1551().field_1772, this.method_25369(), this.method_46426() + 2, this.method_46427() + 4, 0xFFFFFF, false);
                }
            };
            this.upgradeButtons.add(moduleLabel);
            this.upgradeButtons.addAll(buttonsForModule);
        }
        this.scrollList.setList(this.upgradeButtons);
    }

    private int getItemXP(class_1799 stack) {
        return (Integer)stack.method_57825(Upgrade.COMPONENT, (Object)0);
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_48579(drawContext, mouseX, mouseY, delta);
    }

    @Override
    public void renderHover(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.renderHover(drawContext, mouseX, mouseY, delta);
        if (this.method_25405(mouseX, mouseY) && !this.scrollList.method_25405(mouseX, mouseY) && this.method_46426() + this.method_25364() - 20 > mouseX && this.method_46427() + this.method_25368() - 35 > mouseY) {
            drawContext.method_51437(class_310.method_1551().field_1772, List.of(class_2561.method_43469((String)"miapi.upgrade.hover.1", (Object[])new Object[]{this.currentLVLXp, this.currentLVLXp + this.maxToNextLevel}), class_2561.method_43469((String)"miapi.upgrade.hover.2", (Object[])new Object[]{this.availablePoints}), class_2561.method_43469((String)"miapi.upgrade.hover.3", (Object[])new Object[]{this.usedLevels}), class_2561.method_43469((String)"miapi.upgrade.hover.4", (Object[])new Object[]{this.usedLevels}), class_2561.method_43469((String)"miapi.upgrade.hover.5", (Object[])new Object[]{this.usedLevels})), Optional.empty(), mouseX, mouseY);
        }
    }
}

