/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.registry.NucleusNamespaces;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smartin.miapi.Environment;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.blueprint.BlueprintManager;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.craft.stat.StatActorType;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.datapack.ReloadHelpers;
import smartin.miapi.editor.EditorCommands;
import smartin.miapi.editor.LiveDataPackManager;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.ItemToModularConverter;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.item.PoseCommands;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.loot.LootHelper;
import smartin.miapi.loot.MaterialSwapLootFunction;
import smartin.miapi.loot.ModuleSwapLootFunction;
import smartin.miapi.material.ComponentMaterial;
import smartin.miapi.material.MaterialCommand;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.generated.GeneratedMaterialManager;
import smartin.miapi.mixin.ItemStackAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.MiapiPermissions;
import smartin.miapi.modules.ModuleDataPropertiesManager;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.key.KeyBindManager;
import smartin.miapi.modules.abilities.key.MiapiBinding;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.cache.CacheCommands;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.network.NetworkingImplCommon;
import smartin.miapi.registries.RegistryInventory;

public class Miapi {
    public static final String MOD_ID = "miapi";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ModularItem API");
    public static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"miapi debug");
    public static NetworkingImplCommon networkingImplementation;
    public static MinecraftServer server;
    public static RegistryAccess registryAccess;
    public static Codec<Boolean> FIXED_BOOL_CODEC;
    public static Gson gson;
    public static Codec<ResourceLocation> ID_CODEC;
    public static DynamicOps<Tag> BOOL_CORRECTED_OPS;
    private static final int CHUNK_SIZE = 9000;
    public static final Codec<String> CHUNKED_STRING_CODEC;

    public static <T> Codec<List<T>> toListOrSimple(Codec<T> base) {
        return Codec.withAlternative((Codec)Codec.list(base), base, List::of);
    }

    public static void init() {
        CodecBehavior.registerClass(Transform.class, Transform.CODEC);
        CodecBehavior.registerClass(DoubleOperationResolvable.class, DoubleOperationResolvable.CODEC);
        CodecBehavior.registerClass(ModuleInstance.class, ModuleInstance.CODEC);
        CodecBehavior.registerClass(ModuleCondition.class, ConditionManager.CONDITION_CODEC_DIRECT);
        CodecBehavior.registerClass(ResourceLocation.class, (Codec)ResourceLocation.CODEC);
        CodecBehavior.registerClass(CompoundTag.class, (Codec)CompoundTag.CODEC);
        CodecBehavior.registerClass(MaterialIcons.SpinSettings.class, MaterialIcons.SpinSettings.CODEC);
        CodecBehavior.registerClass(EquipmentSlotGroup.class, (Codec)EquipmentSlotGroup.CODEC);
        CodecBehavior.registerClass(EquipmentSlot.class, (Codec)EquipmentSlot.CODEC);
        CodecBehavior.registerClass(MaterialSwapLootFunction.class, (Codec)MaterialSwapLootFunction.CODEC.codec());
        CodecBehavior.registerClass(ModuleSwapLootFunction.class, (Codec)ModuleSwapLootFunction.CODEC.codec());
        if (Environment.isClient()) {
            CodecBehavior.registerClass(MiapiBinding.class, MiapiBinding.CODEC);
        }
        ItemStackAccessor.setCODEC(ModuleInstance.registrySavingCodec(ItemStackAccessor.getCODEC(), (i, registryAccess) -> ModularItemStackConverter.lookupMap.put((ItemStack)i, (RegistryOps.RegistryInfoLookup)registryAccess)));
        MiapiConfig.setupConfigs();
        Miapi.setupNetworking();
        RegistryInventory.setup();
        ReloadEvents.setup();
        ItemAbilityManager.setup();
        AttributeRegistry.setup();
        ConditionManager.setup();
        StatActorType.setup();
        ComponentMaterial.setup();
        GeneratedMaterialManager.setup();
        KeyBindManager.setup();
        ReloadHelpers.registerReloadHandlers();
        LiveDataPackManager.setup();
        LifecycleEvent.SERVER_BEFORE_START.register(minecraftServer -> {
            server = minecraftServer;
            registryAccess = minecraftServer.reloadableRegistries().get();
        });
        PlayerEvent.PLAYER_JOIN.register(player -> new Thread(() -> MiapiPermissions.getPerms((Player)player)).start());
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.register(ItemModule.empty.id(), ItemModule.empty);
            RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.register(ItemModule.internal.id(), ItemModule.internal);
            LOGGER.info("Loaded " + RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.getFlatMap().size() + " Modules");
            ModularItemCache.discardCache();
        });
        PropertyResolver.register(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"miapi/module"), (moduleInstance, oldMap) -> {
            Map<ModuleProperty<?>, Object> map = moduleInstance.module.properties();
            if (map == null) {
                map = new HashMap();
                LOGGER.warn("Item Modules has no properties. this is a api issue. please report this. this should not happen");
            }
            return new ConcurrentHashMap(map);
        });
        PropertyResolver.register("miapi/module_data", (moduleInstance, oldMap) -> {
            ConcurrentHashMap map = new ConcurrentHashMap(oldMap);
            ConcurrentHashMap toMerge = new ConcurrentHashMap(ModuleDataPropertiesManager.getProperties(moduleInstance));
            map.putAll(toMerge);
            return map;
        });
        ModularItemCache.setSupplier("modules", itemStack -> {
            if (itemStack.getItem() instanceof VisualModularItem) {
                try {
                    return ItemModule.getModules(itemStack);
                }
                catch (Exception e) {
                    LOGGER.error("could not resolve Modules", (Throwable)e);
                }
            }
            return null;
        });
        ModularItemStackConverter.converters.add(new ItemToModularConverter());
        if (Environment.isClient()) {
            MiapiClient.init();
        }
        NucleusNamespaces.addAddonNamespace((String)MOD_ID);
        CommandRegistrationEvent.EVENT.register((serverCommandSourceCommandDispatcher, registryAccess, listener) -> {
            MaterialCommand.register((CommandDispatcher<CommandSourceStack>)serverCommandSourceCommandDispatcher);
            CacheCommands.register((CommandDispatcher<CommandSourceStack>)serverCommandSourceCommandDispatcher);
            PoseCommands.register((CommandDispatcher<CommandSourceStack>)serverCommandSourceCommandDispatcher);
            EditorCommands.register((CommandDispatcher<CommandSourceStack>)serverCommandSourceCommandDispatcher);
        });
        BlueprintManager.setup();
        LootHelper.setup();
        MiapiEvents.POST_HOT_RELOAD.register(() -> {
            if (server != null) {
                server.getPlayerList().getPlayers().forEach(p -> {
                    p.getInventory().setChanged();
                    CompoundTag tag = new CompoundTag();
                    if (p.save(tag)) {
                        p.load(tag);
                    }
                });
            }
            return EventResult.pass();
        });
    }

    public static String camelToSnake(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean conversionOccurred = false;
        for (char c : input.toCharArray()) {
            if (Character.isUpperCase(c)) {
                if (!result.isEmpty()) {
                    result.append('_');
                }
                result.append(Character.toLowerCase(c));
                conversionOccurred = true;
                continue;
            }
            result.append(c);
        }
        if (conversionOccurred) {
            LOGGER.info("Converted camelCase to snake_case: " + input);
        }
        return result.toString();
    }

    public static ResourceLocation id(String string) {
        String[] parts = (string = Miapi.camelToSnake(string)).split(":");
        if (parts[0].equals("arsenal")) {
            parts[0] = "tm_arsenal";
        }
        if (parts[0].equals("archery")) {
            parts[0] = "tm_archery";
        }
        if (parts[0].equals("armory")) {
            parts[0] = "tm_armory";
        }
        if (parts.length > 1) {
            return ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
        }
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)string);
    }

    public static ResourceLocation id(String namespace, String id) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id);
    }

    public static String toLangString(ResourceLocation id) {
        String lang = id.toString();
        lang = lang.replace(":", ".");
        lang = lang.replace("/", ".");
        return lang;
    }

    protected static void setupNetworking() {
        networkingImplementation = new NetworkingImplCommon();
        Networking.setImplementation(networkingImplementation);
        networkingImplementation.setupServer();
    }

    public static <T> MapCodec<T> withAlternative(MapCodec<T> primary, MapCodec<? extends T> alternative) {
        return Codec.mapEither(primary, alternative).xmap(Either::unwrap, Either::left);
    }

    static {
        FIXED_BOOL_CODEC = Codec.withAlternative((Codec)Codec.BOOL, (Codec)Codec.INT.xmap(i -> i == 1, b -> b != false ? 0 : 1));
        gson = new GsonBuilder().create();
        ID_CODEC = new Codec<ResourceLocation>(){

            public <T> DataResult<Pair<ResourceLocation, T>> decode(DynamicOps<T> ops, T input) {
                Pair result = (Pair)Codec.STRING.decode(ops, input).getOrThrow();
                return DataResult.success((Object)new Pair((Object)Miapi.id((String)result.getFirst()), result.getSecond()));
            }

            public <T> DataResult<T> encode(ResourceLocation input, DynamicOps<T> ops, T prefix) {
                return Codec.STRING.encode((Object)input.toString(), ops, prefix);
            }
        };
        BOOL_CORRECTED_OPS = new NbtOps(){};
        CHUNKED_STRING_CODEC = Codec.list((Codec)Codec.STRING).xmap(list -> String.join((CharSequence)"", list), str -> {
            ArrayList<String> parts = new ArrayList<String>();
            for (int i = 0; i < str.length(); i += 9000) {
                parts.add(str.substring(i, Math.min(str.length(), i + 9000)));
            }
            return parts;
        });
    }
}

