/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.attributes;

import com.redpxnda.nucleus.facet.Facet;
import com.redpxnda.nucleus.facet.FacetRegistry;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import smartin.miapi.Miapi;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.entity.ShieldingArmorFacet;
import smartin.miapi.entity.StunHealthFacet;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.events.ModularAttackEvents;
import smartin.miapi.mixin.LivingEntityAccessor;
import smartin.miapi.modules.abilities.key.KeyBindFacet;
import smartin.miapi.modules.properties.attributes.AttributeUtil;

public class AttributeRegistry {
    public static Map<ResourceLocation, Holder<Attribute>> entityAttributeMap = new HashMap<ResourceLocation, Holder<Attribute>>();
    public static Map<Player, Boolean> hasCrittedLast = new WeakHashMap<Player, Boolean>();
    public static Holder<Attribute> SWIM_SPEED;
    public static Holder<Attribute> MINING_SPEED_PICKAXE;
    public static Holder<Attribute> MINING_SPEED_AXE;
    public static Holder<Attribute> MINING_SPEED_SHOVEL;
    public static Holder<Attribute> MINING_SPEED_HOE;
    public static Holder<Attribute> MAGIC_DAMAGE;
    public static Holder<Attribute> STUN_DAMAGE;
    public static Holder<Attribute> STUN_MAX_HEALTH;
    public static Holder<Attribute> CRITICAL_DAMAGE;
    public static Holder<Attribute> CRITICAL_CHANCE;
    public static Holder<Attribute> DAMAGE_RESISTANCE;
    public static Holder<Attribute> BACK_STAB;
    public static Holder<Attribute> ARMOR_CRUSHING;
    public static Holder<Attribute> SHIELD_BREAK;
    public static Holder<Attribute> PROJECTILE_ARMOR;
    public static Holder<Attribute> PLAYER_ITEM_USE_MOVEMENT_SPEED;
    public static Holder<Attribute> PROJECTILE_DAMAGE;
    public static Holder<Attribute> PROJECTILE_SPEED;
    public static Holder<Attribute> PROJECTILE_ACCURACY;
    public static Holder<Attribute> PROJECTILE_PIERCING;
    public static Holder<Attribute> ELYTRA_TURN_EFFICIENCY;
    public static Holder<Attribute> ELYTRA_GLIDE_EFFICIENCY;
    public static Holder<Attribute> ELYTRA_ROCKET_EFFICIENCY;
    public static Holder<Attribute> SHIELDING_ARMOR;
    private static final ResourceLocation TEMP_CRIT_DMG_UUID;
    private static final ResourceLocation TEMP_CRIT_DMG_MULTIPLIER_UUID;
    private static final ResourceLocation TEMP_BACKSTAB_DMG_UUID;

    public static void setup() {
        FacetRegistry.ENTITY_FACET_ATTACHMENT.register((entity, attacher) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ShieldingArmorFacet facet = new ShieldingArmorFacet(livingEntity);
                attacher.add(ShieldingArmorFacet.KEY, (Facet)facet);
                StunHealthFacet stunHealthFacet = new StunHealthFacet(livingEntity);
                attacher.add(StunHealthFacet.KEY, (Facet)stunHealthFacet);
                KeyBindFacet keyBindFacet = new KeyBindFacet((Entity)livingEntity);
                attacher.add(KeyBindFacet.KEY, (Facet)keyBindFacet);
            }
        });
        MiapiEvents.LIVING_HURT_AFTER_ARMOR.register(livingHurt -> {
            Entity patt0$temp;
            StunHealthFacet facet = (StunHealthFacet)StunHealthFacet.KEY.get((Entity)livingHurt.defender);
            if (livingHurt.damageSource != null && livingHurt.damageSource.getEntity() != null && (patt0$temp = livingHurt.damageSource.getEntity()) instanceof LivingEntity) {
                double currentStunDamage;
                LivingEntity attacker = (LivingEntity)patt0$temp;
                if (facet != null && !livingHurt.defender.level().isClientSide() && attacker.getAttributes().hasAttribute(STUN_DAMAGE) && (currentStunDamage = attacker.getAttributeValue(STUN_DAMAGE)) > 0.1) {
                    facet.takeStunDamage((float)currentStunDamage, attacker);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER_ARMOR.register(livingHurt -> {
            ShieldingArmorFacet facet = (ShieldingArmorFacet)ShieldingArmorFacet.KEY.get((Entity)livingHurt.defender);
            if (facet != null && !livingHurt.defender.level().isClientSide() && livingHurt.damageSource != null && !livingHurt.damageSource.is(DamageTypeTags.BYPASSES_ARMOR)) {
                livingHurt.amount = facet.takeDamage(livingHurt.amount);
                LivingEntity patt0$temp = livingHurt.defender;
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    facet.sendToClient(player);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_ENTITY_TICK_END.register(entity -> {
            ShieldingArmorFacet facet = (ShieldingArmorFacet)ShieldingArmorFacet.KEY.get((Entity)entity);
            if (facet != null && !entity.level().isClientSide()) {
                try {
                    facet.tick();
                }
                catch (RuntimeException e) {
                    Miapi.LOGGER.warn("facet error", (Throwable)e);
                }
            }
            return EventResult.pass();
        });
        PlayerEvent.PLAYER_JOIN.register(player -> ShieldingArmorFacet.KEY.get((Entity)player));
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            if (livingHurtEvent.defender.getAttributes().hasAttribute(DAMAGE_RESISTANCE)) {
                livingHurtEvent.amount = Math.max(0.0f, (float)((double)livingHurtEvent.amount * (100.0 - livingHurtEvent.defender.getAttributeValue(DAMAGE_RESISTANCE)) / 100.0));
            }
            return EventResult.pass();
        });
        ModularAttackEvents.HURT_ENEMY.register((stack, defender, attacker) -> {
            double value;
            if (attacker != null && defender != null && attacker.getAttributes().hasAttribute(MAGIC_DAMAGE) && (value = attacker.getAttributeValue(MAGIC_DAMAGE)) > 0.0) {
                defender.hurt(attacker.damageSources().magic(), (float)value);
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            LivingEntity attacker;
            Entity patt0$temp;
            if (livingHurtEvent.damageSource != null && (patt0$temp = livingHurtEvent.damageSource.getEntity()) instanceof LivingEntity && (attacker = (LivingEntity)patt0$temp).getAttributes().hasAttribute(BACK_STAB) && attacker.getAttributes().getInstance(BACK_STAB) != null && livingHurtEvent.damageSource.getEntity().getLookAngle().dot(livingHurtEvent.defender.getLookAngle()) > 0.0) {
                Objects.requireNonNull(attacker.getAttributes().getInstance(BACK_STAB)).addTransientModifier(new AttributeModifier(TEMP_BACKSTAB_DMG_UUID, (double)livingHurtEvent.amount, AttributeModifier.Operation.ADD_VALUE));
                livingHurtEvent.amount = (float)attacker.getAttributeValue(BACK_STAB);
                Objects.requireNonNull(attacker.getAttributes().getInstance(BACK_STAB)).removeModifier(TEMP_BACKSTAB_DMG_UUID);
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            double projectileArmor;
            if (livingHurtEvent.damageSource != null && livingHurtEvent.damageSource.is(DamageTypeTags.IS_PROJECTILE) && livingHurtEvent.defender.getAttributes().hasAttribute(PROJECTILE_ARMOR) && (projectileArmor = livingHurtEvent.defender.getAttributeValue(PROJECTILE_ARMOR)) > 0.0) {
                double totalDamage = (double)livingHurtEvent.amount * (1.0 - Math.max(20.0, projectileArmor) / 25.0);
                livingHurtEvent.amount = (float)totalDamage;
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER.register(livingHurtEvent -> {
            LivingEntity attacker;
            Entity patt0$temp;
            if (livingHurtEvent.damageSource != null && (patt0$temp = livingHurtEvent.damageSource.getEntity()) instanceof LivingEntity && (attacker = (LivingEntity)patt0$temp).getAttributes().hasAttribute(SHIELD_BREAK)) {
                double value = attacker.getAttributeValue(SHIELD_BREAK);
                LivingEntity patt1$temp = livingHurtEvent.defender;
                if (patt1$temp instanceof Player) {
                    Player player = (Player)patt1$temp;
                    if (value > 0.0 && player.isBlocking()) {
                        player.getCooldowns().addCooldown(Items.SHIELD, (int)(value * 20.0));
                        player.stopUsingItem();
                        player.level().broadcastEntityEvent((Entity)player, (byte)30);
                    }
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            LivingEntity attacker;
            Entity patt0$temp;
            if (livingHurtEvent.damageSource != null && (patt0$temp = livingHurtEvent.damageSource.getEntity()) instanceof LivingEntity && (attacker = (LivingEntity)patt0$temp).getAttributes().hasAttribute(ARMOR_CRUSHING)) {
                double value = attacker.getAttributeValue(ARMOR_CRUSHING);
                ((LivingEntityAccessor)livingHurtEvent.defender).callDamageArmor(livingHurtEvent.damageSource, (float)((double)livingHurtEvent.defender.getArmorValue() * value));
            }
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.register(listener -> {
            ItemProjectileEntity projectile = listener.projectile;
            if (projectile.isCritArrow()) {
                // empty if block
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            Entity patt0$temp;
            if (livingHurtEvent.damageSource != null && (patt0$temp = livingHurtEvent.damageSource.getEntity()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt0$temp;
                if (!livingHurtEvent.defender.level().isClientSide()) {
                    if (attacker.getAttributes().hasAttribute(CRITICAL_CHANCE) && !livingHurtEvent.isCritical) {
                        Objects.requireNonNull(attacker.getAttributes().getInstance(CRITICAL_CHANCE)).addTransientModifier(new AttributeModifier(TEMP_CRIT_DMG_UUID, 1.0, AttributeModifier.Operation.ADD_VALUE));
                        double value = attacker.getAttributeValue(CRITICAL_CHANCE) - 1.0;
                        Objects.requireNonNull(attacker.getAttributes().getInstance(CRITICAL_CHANCE)).removeModifier(TEMP_CRIT_DMG_UUID);
                        if (attacker.level().getRandom().nextDouble() < value) {
                            livingHurtEvent.isCritical = true;
                            livingHurtEvent.amount *= 1.5f;
                            attacker.level().playSound(null, attacker.getX(), attacker.getY(), attacker.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, attacker.getSoundSource(), 1.0f, 1.0f);
                            if (attacker instanceof Player) {
                                Player player = (Player)attacker;
                                player.crit((Entity)livingHurtEvent.defender);
                            }
                            if (attacker.level().isClientSide()) {
                                Minecraft.getInstance().particleEngine.createTrackingEmitter((Entity)livingHurtEvent.defender, (ParticleOptions)ParticleTypes.CRIT);
                            } else {
                                Level patt1$temp = attacker.level();
                                if (patt1$temp instanceof ServerLevel) {
                                    ServerLevel serverWorld = (ServerLevel)patt1$temp;
                                    serverWorld.getChunkSource().broadcastAndSend((Entity)attacker, (Packet)new ClientboundAnimatePacket((Entity)livingHurtEvent.defender, 4));
                                }
                            }
                        }
                    }
                    if (attacker.getAttributes().hasAttribute(CRITICAL_DAMAGE) && livingHurtEvent.isCritical && attacker.getAttributes().getInstance(CRITICAL_DAMAGE) != null) {
                        attacker.getAttribute(CRITICAL_DAMAGE);
                        Objects.requireNonNull(attacker.getAttributes().getInstance(CRITICAL_DAMAGE)).addTransientModifier(new AttributeModifier(TEMP_CRIT_DMG_UUID, (double)livingHurtEvent.amount / 1.5, AttributeModifier.Operation.ADD_VALUE));
                        Objects.requireNonNull(attacker.getAttributes().getInstance(CRITICAL_DAMAGE)).addTransientModifier(new AttributeModifier(TEMP_CRIT_DMG_MULTIPLIER_UUID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
                        livingHurtEvent.amount = (float)attacker.getAttributeValue(CRITICAL_DAMAGE);
                        Objects.requireNonNull(attacker.getAttributes().getInstance(CRITICAL_DAMAGE)).removeModifier(TEMP_CRIT_DMG_UUID);
                        Objects.requireNonNull(attacker.getAttributes().getInstance(CRITICAL_DAMAGE)).removeModifier(TEMP_CRIT_DMG_MULTIPLIER_UUID);
                    }
                }
            }
            return EventResult.pass();
        }, -1.0f);
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.register(event -> {
            double critModifier = AttributeUtil.getActualValue(event.projectile.thrownStack, EquipmentSlot.MAINHAND, (Attribute)CRITICAL_DAMAGE.value(), 1.5);
            if (critModifier != 1.0 && event.projectile.isCritArrow()) {
                event.damage *= (float)(critModifier / 1.5);
            }
            return EventResult.pass();
        });
    }

    public static double getAttribute(ItemStack stack, Attribute attribute, EquipmentSlot slot, double defaultValue) {
        return AttributeUtil.getActualValue(stack, slot, attribute, defaultValue);
    }

    static {
        TEMP_CRIT_DMG_UUID = Miapi.id("temp_crit_dmg");
        TEMP_CRIT_DMG_MULTIPLIER_UUID = Miapi.id("temp_crit_dmg_multiplier");
        TEMP_BACKSTAB_DMG_UUID = Miapi.id("temp_backstab_dmg");
    }
}

