/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.blocks.ModularWorkBenchEntity;

public class ModularWorkBench
extends BaseEntityBlock {
    private static final VoxelShape BOTTOM = Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)4.0, (double)12.0);
    private static final VoxelShape CONNECTOR = Block.box((double)3.0, (double)4.0, (double)5.0, (double)13.0, (double)12.0, (double)11.0);
    private static final VoxelShape BASE = Shapes.or((VoxelShape)BOTTOM, (VoxelShape)CONNECTOR);
    private static final VoxelShape TOP = Block.box((double)0.0, (double)12.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape WHOLE = Shapes.or((VoxelShape)BASE, (VoxelShape)TOP);
    private static final VoxelShape BOTTOM_SWAPPED = Block.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)4.0, (double)14.0);
    private static final VoxelShape CONNECTOR_SWAPPED = Block.box((double)5.0, (double)4.0, (double)3.0, (double)11.0, (double)12.0, (double)13.0);
    private static final VoxelShape BASE_SWAPPED = Shapes.or((VoxelShape)BOTTOM_SWAPPED, (VoxelShape)CONNECTOR_SWAPPED);
    private static final VoxelShape TOP_SWAPPED = Block.box((double)2.0, (double)12.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape WHOLE_SWAPPED = Shapes.or((VoxelShape)BASE_SWAPPED, (VoxelShape)TOP_SWAPPED);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public ItemStack itemStack;
    public MapCodec<ModularWorkBench> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(i -> i.itemStack), (App)ModularWorkBench.propertiesCodec()).apply((Applicative)instance, (i, a) -> {
        ModularWorkBench bench = new ModularWorkBench((BlockBehaviour.Properties)a);
        bench.itemStack = i;
        return bench;
    }));

    public ModularWorkBench(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public boolean isRandomlyTicking(BlockState state) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH)) {
            return WHOLE;
        }
        return WHOLE_SWAPPED;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player playerEntity, BlockHitResult blockHitResult) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        playerEntity.openMenu(state.getMenuProvider(world, pos));
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        ModularWorkBenchEntity be;
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ModularWorkBenchEntity && !(be = (ModularWorkBenchEntity)blockEntity).getItem().isEmpty()) {
            Vec3 vec = pos.getCenter();
            Containers.dropItemStack((Level)world, (double)vec.x, (double)vec.y, (double)vec.z, (ItemStack)be.getItem());
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ModularWorkBenchEntity) {
            ModularWorkBenchEntity be = (ModularWorkBenchEntity)blockEntity;
            return be;
        }
        return null;
    }

    public <T extends BlockEntity> GameEventListener getListener(ServerLevel world, T blockEntity) {
        if (blockEntity instanceof ModularWorkBenchEntity) {
            ModularWorkBenchEntity bench = (ModularWorkBenchEntity)blockEntity;
            return bench;
        }
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        ModularWorkBenchEntity bench = new ModularWorkBenchEntity(pos, state);
        bench.setItem(this.itemStack);
        return bench;
    }
}

