/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blocks;

import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.util.MiscUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.IStatProvidingBlock;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.craft.stat.CraftingStat;
import smartin.miapi.craft.stat.StatProvidersMap;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.registries.RegistryInventory;

public class ModularWorkBenchEntity
extends BlockEntity
implements MenuProvider,
GameEventListener {
    public static final Map<GameEvent, CustomGameEventHandler> gameEventHandlers = (Map)MiscUtil.initialize(new ConcurrentHashMap(), map -> {
        map.put(RegistryInventory.statProviderCreatedEvent, (bench, world, event, emitter, emitterPos) -> {
            if (emitter.affectedState() != null) {
                BlockPos pos = new BlockPos((int)emitterPos.x, (int)emitterPos.y, (int)emitterPos.z);
                Block block = emitter.affectedState().getBlock();
                if (block instanceof IStatProvidingBlock) {
                    IStatProvidingBlock statProvider = (IStatProvidingBlock)block;
                    bench.persistentStats.computeIfAbsent(pos.toString(), s -> new StatProvidersMap());
                    bench.persistentStats.get(pos.toString()).putAll(statProvider.getProviders(bench, emitter.affectedState(), pos, world));
                }
            }
            return false;
        });
        map.put(RegistryInventory.statProviderRemovedEvent, (bench, world, event, emitter, emitterPos) -> {
            if (emitter.affectedState() != null) {
                BlockPos pos = new BlockPos((int)emitterPos.x, (int)emitterPos.y, (int)emitterPos.z);
                bench.persistentStats.remove(pos.toString());
            }
            return false;
        });
    });
    protected final ContainerData propertyDelegate;
    public ItemStack stack;
    public final Map<String, StatProvidersMap> persistentStats = new HashMap<String, StatProvidersMap>();
    protected final Map<CraftingStat, Object> stats = new HashMap<CraftingStat, Object>();
    public int x;
    public int y;
    public int z;
    protected BlockPositionSource blockPositionSource;
    List<WeakReference<CraftingScreenHandler>> handlers = new ArrayList<WeakReference<CraftingScreenHandler>>();

    public ModularWorkBenchEntity(BlockPos pos, BlockState state) {
        super(RegistryInventory.modularWorkBenchEntityType, pos, state);
        this.stack = ItemStack.EMPTY;
        this.x = pos.getX();
        this.y = pos.getY();
        this.z = pos.getZ();
        this.propertyDelegate = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> 1;
                    case 1 -> (short)(ModularWorkBenchEntity.this.x >> 16);
                    case 2 -> (short)ModularWorkBenchEntity.this.x;
                    case 3 -> (short)(ModularWorkBenchEntity.this.y >> 16);
                    case 4 -> (short)ModularWorkBenchEntity.this.y;
                    case 5 -> (short)(ModularWorkBenchEntity.this.z >> 16);
                    case 6 -> (short)ModularWorkBenchEntity.this.z;
                    default -> -1;
                };
            }

            public void set(int index, int value) {
            }

            public int getCount() {
                return 7;
            }
        };
        this.setChanged();
    }

    public void setItem(ItemStack stack) {
        this.stack = stack == null ? ItemStack.EMPTY : stack.copy();
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public <T> T getStat(CraftingStat<T> stat) {
        return (T)this.stats.get(stat);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider wrapperLookup) {
        super.saveAdditional(tag, wrapperLookup);
        CompoundTag persisStatsNbt = new CompoundTag();
        CompoundTag statsNbt = new CompoundTag();
        this.stats.forEach((stat, inst) -> statsNbt.put(RegistryInventory.CRAFTING_STATS_REGISTRY.findKey((CraftingStat)stat).toString(), stat.saveToNbt(inst)));
        if (!this.getItem().isEmpty()) {
            try {
                tag.put("item", (Tag)ItemStack.CODEC.encodeStart((DynamicOps)RegistryOps.create(Miapi.BOOL_CORRECTED_OPS, (HolderLookup.Provider)this.level.registryAccess()), (Object)this.getItem()).getOrThrow());
            }
            catch (Exception e) {
                Miapi.LOGGER.error("Could not save Item in Workbench! this indicated the item is broken and will cause more crashese later on!", (Throwable)e);
                try {
                    Miapi.LOGGER.error(this.getItem().toString());
                }
                catch (RuntimeException runtimeException) {}
            }
        } else {
            tag.remove("item");
        }
        tag.put("PersistentStats", (Tag)persisStatsNbt);
        tag.put("Stats", (Tag)statsNbt);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider wrapperLookup) {
        super.loadAdditional(tag, wrapperLookup);
        this.persistentStats.clear();
        this.stats.clear();
        if (tag.contains("item")) {
            try {
                this.stack = (ItemStack)ItemStack.parse((HolderLookup.Provider)wrapperLookup, (Tag)tag.getCompound("item")).get();
                this.setItem(this.stack);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("sever encoding issue", (Throwable)e);
                this.stack = ItemStack.EMPTY;
                this.setItem(this.stack);
            }
        } else {
            this.stack = ItemStack.EMPTY;
            this.setItem(this.stack);
        }
        CompoundTag persisStatsNbt = tag.getCompound("PersistentStats");
        persisStatsNbt.getAllKeys().forEach(key -> {});
        CompoundTag statsNbt = tag.getCompound("Stats");
        statsNbt.getAllKeys().forEach(key -> {
            CraftingStat stat = RegistryInventory.CRAFTING_STATS_REGISTRY.get((String)key);
            if (stat == null) {
                Miapi.LOGGER.warn("Found unknown CraftingStat id '{}'!", key);
                return;
            }
            this.stats.put(stat, stat.createFromNbt(statsNbt.get(key)));
        });
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::saveWithFullMetadata);
    }

    public void saveAndSync() {
        this.setChanged();
        if (this.hasLevel()) {
            this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.getBlockState(), 3);
        }
        this.handlers.forEach(weakReference -> {
            CraftingScreenHandler handler = (CraftingScreenHandler)((Object)((Object)weakReference.get()));
            if (handler != null && !ItemStack.matches((ItemStack)handler.inventory.getItem(0), (ItemStack)this.getItem())) {
                handler.inventory.setItem(0, this.getItem());
            }
        });
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return new CompoundTag();
    }

    public Component getDisplayName() {
        return Component.literal((String)"test");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        CraftingScreenHandler handler = new CraftingScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
        this.stats.clear();
        StatProvidersMap providers = new StatProvidersMap();
        ((MiapiEvents.StatUpdateEvent)MiapiEvents.STAT_UPDATE_EVENT.invoker()).update(this, providers, syncId, playerInventory, player, handler);
        this.persistentStats.forEach((key, map) -> providers.putAll((StatProvidersMap)map));
        this.stats.putAll(providers.evaluateAll());
        this.saveAndSync();
        this.handlers.add(new WeakReference<CraftingScreenHandler>(handler));
        return handler;
    }

    public PositionSource getListenerSource() {
        if (this.blockPositionSource == null) {
            this.blockPositionSource = new BlockPositionSource(this.worldPosition);
        }
        return this.blockPositionSource;
    }

    public int getListenerRadius() {
        return 16;
    }

    public boolean handleGameEvent(ServerLevel world, Holder<GameEvent> registryEntry, GameEvent.Context emitter, Vec3 emitterPos) {
        CustomGameEventHandler handler = gameEventHandlers.get(registryEntry.value());
        if (handler == null) {
            return false;
        }
        return handler.handle(this, world, (GameEvent)registryEntry.value(), emitter, emitterPos);
    }

    public static interface CustomGameEventHandler {
        public boolean handle(ModularWorkBenchEntity var1, ServerLevel var2, GameEvent var3, GameEvent.Context var4, Vec3 var5);
    }
}

