/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import smartin.miapi.blocks.IStatProvidingBlock;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.stat.StatProvidersMap;
import smartin.miapi.registries.RegistryInventory;

public class StatProvidingBlock
extends Block
implements IStatProvidingBlock {
    protected final StatProvidersMap providersMap;

    public StatProvidingBlock(BlockBehaviour.Properties settings, StatProvidersMap providers) {
        super(settings.pushReaction(PushReaction.IGNORE));
        this.providersMap = providers;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        world.gameEvent(BuiltInRegistries.GAME_EVENT.wrapAsHolder((Object)RegistryInventory.statProviderCreatedEvent), pos, new GameEvent.Context(null, state));
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            world.gameEvent(BuiltInRegistries.GAME_EVENT.wrapAsHolder((Object)RegistryInventory.statProviderCreatedEvent), pos, new GameEvent.Context(null, state));
        }
    }

    @Override
    public StatProvidersMap getProviders(ModularWorkBenchEntity caller, BlockState state, BlockPos pos, ServerLevel world) {
        return this.providersMap;
    }
}

