/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blueprint;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.BlueprintManager;
import smartin.miapi.blueprint.IngredientWithCount;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.material.AllowedMaterial;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.slot.SlotProperty;

public class BlueprintComponent {
    public static Codec<BlueprintComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModuleInstance.CODEC.fieldOf("module").forGetter(blueprint -> blueprint.toMerge), (App)Codec.either(Miapi.FIXED_BOOL_CODEC, IngredientWithCount.INGREDIENT_WITH_COUNT).fieldOf("ingredient").forGetter(blueprint -> blueprint.ingredient), (App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(blueprintComponent -> blueprintComponent.name)).apply((Applicative)instance, BlueprintComponent::new));
    public static ResourceLocation ID = Miapi.id("blueprint_slot_id");
    public static DataComponentType<BlueprintComponent> BLUEPRINT_COMPONENT = DataComponentType.builder().persistent(CODEC).networkSynchronized(ByteBufCodecs.fromCodec(CODEC)).build();
    public ModuleInstance toMerge;
    public Either<Boolean, IngredientWithCount> ingredient;
    public Optional<Component> name;

    public BlueprintComponent(ModuleInstance moduleInstance, Either<Boolean, IngredientWithCount> ingredient, Optional<Component> name) {
        this.toMerge = moduleInstance;
        this.ingredient = ingredient;
        this.name = name;
        moduleInstance.getProperty(SlotProperty.getInstance());
    }

    public boolean useMaterialCrafting() {
        if (this.ingredient.left().isPresent()) {
            return (Boolean)this.ingredient.left().get() == false;
        }
        return false;
    }

    public int getCost() {
        if (this.ingredient.left().isPresent() && ((Boolean)this.ingredient.left().get()).booleanValue()) {
            return 1;
        }
        if (this.ingredient.right().isPresent()) {
            IngredientWithCount countIngredient = (IngredientWithCount)this.ingredient.right().get();
            return (int)countIngredient.count;
        }
        return 0;
    }

    public boolean isValid(ItemStack itemStack, ItemStack blueprintItem) {
        if (this.ingredient.left().isPresent() && ((Boolean)this.ingredient.left().get()).booleanValue()) {
            return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)blueprintItem);
        }
        if (this.ingredient.right().isPresent()) {
            IngredientWithCount countIngredient = (IngredientWithCount)this.ingredient.right().get();
            return countIngredient.ingredient.test(itemStack) && countIngredient.count <= (double)itemStack.getCount();
        }
        return false;
    }

    public boolean isValidCorrectType(ItemStack itemStack, ItemStack blueprintItem) {
        if (this.ingredient.left().isPresent() && ((Boolean)this.ingredient.left().get()).booleanValue()) {
            return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)blueprintItem);
        }
        if (this.ingredient.right().isPresent()) {
            IngredientWithCount countIngredient = (IngredientWithCount)this.ingredient.right().get();
            return countIngredient.ingredient.test(itemStack);
        }
        return false;
    }

    public ItemStack retrieve(CraftingScreenHandler screenHandler) {
        Optional<Slot> optional = screenHandler.slots.stream().filter(a -> a.getItem().has(BLUEPRINT_COMPONENT)).filter(a -> this.equals(a.getItem().get(BLUEPRINT_COMPONENT))).findAny();
        return optional.map(Slot::getItem).orElse(ItemStack.EMPTY);
    }

    public void apply(ModuleInstance old) {
        old.module = this.toMerge.module;
        old.moduleID = this.toMerge.moduleID;
        old.moduleData = new HashMap<ResourceLocation, JsonElement>(this.toMerge.moduleData);
        this.toMerge.getSubModuleMap().forEach(old::setSubModule);
    }

    public ItemStack adjustCost(ItemStack itemStack) {
        if (this.ingredient.left().isPresent()) {
            if (((Boolean)this.ingredient.left().get()).booleanValue()) {
                int size = itemStack.getCount() - 1;
                ItemStack adjustedStack = itemStack.copy();
                adjustedStack.setCount(size);
                return adjustedStack;
            }
        } else {
            IngredientWithCount countIngredient = (IngredientWithCount)this.ingredient.right().get();
            if (countIngredient.ingredient.test(itemStack) && countIngredient.count <= (double)itemStack.getCount()) {
                int size = itemStack.getCount() - (int)countIngredient.count;
                ItemStack adjustedStack = itemStack.copy();
                adjustedStack.setCount(size);
                return adjustedStack;
            }
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    public static BlueprintComponent getBlueprint(Map<ResourceLocation, JsonElement> dataMap, CraftingScreenHandler screenHandler) {
        JsonElement json = dataMap.get(ID);
        if (json != null) {
            DataResult decodeResult = Codec.INT.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            int id = -1;
            id = decodeResult.isError() ? Integer.decode((String)((Pair)Codec.STRING.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst()).intValue() : ((Integer)((Pair)decodeResult.getOrThrow()).getFirst()).intValue();
            if (id == -1) {
                // empty if block
            }
            if (id >= 0) {
                ItemStack itemStack = ((Slot)screenHandler.slots.get(id)).getItem();
                if (itemStack.has(BLUEPRINT_COMPONENT)) {
                    return (BlueprintComponent)itemStack.get(BLUEPRINT_COMPONENT);
                }
            } else {
                Miapi.LOGGER.error("could not correctly read blueprint data!");
            }
        }
        return BlueprintManager.getBlueprint(dataMap, screenHandler);
    }

    public Component getName() {
        return this.name.orElse(this.toMerge.getModuleName());
    }

    public CraftOption asCraftOption(CraftingScreenHandler screenHandler) {
        return new CraftOption(this.toMerge.module, () -> {
            int i = -1;
            Optional<Slot> optional = screenHandler.slots.stream().filter(a -> a.getItem().has(BLUEPRINT_COMPONENT)).filter(a -> this.equals(a.getItem().get(BLUEPRINT_COMPONENT))).findAny();
            if (optional.isPresent()) {
                i = optional.get().index;
            }
            JsonElement element = (JsonElement)Codec.INT.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)i).getOrThrow();
            JsonElement booleanElement = (JsonElement)Miapi.FIXED_BOOL_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.useMaterialCrafting()).getOrThrow();
            return Map.of(ID, element, AllowedMaterial.KEY, booleanElement);
        }, -200.0, this.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlueprintComponent) {
            BlueprintComponent blueprintComponent = (BlueprintComponent)obj;
            String first = ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()).toString();
            String other = ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)blueprintComponent).getOrThrow()).toString();
            return first.equals(other);
        }
        return super.equals(obj);
    }
}

