/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blueprint;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.BlueprintComponent;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.datapack.ReloadHelpers;
import smartin.miapi.material.AllowedMaterial;

public class BlueprintManager {
    public static Map<ResourceLocation, BlueprintComponent> reloadedBlueprints = new HashMap<ResourceLocation, BlueprintComponent>();
    public static ResourceLocation ID = Miapi.id("reloaded_blueprint");

    public static void setup() {
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/blueprint", reloadedBlueprints, (isClient, id, data, registryAccess) -> {
            Miapi.LOGGER.info("loaded Blueprint " + String.valueOf(id));
            JsonElement element = (JsonElement)Miapi.gson.fromJson(data, JsonElement.class);
            BlueprintComponent component = (BlueprintComponent)((Pair)BlueprintComponent.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow()).getFirst();
            if (component.ingredient.left().isPresent() && ((Boolean)component.ingredient.left().get()).booleanValue()) {
                Miapi.LOGGER.warn("Datapack Blueprints cannot set the Ingredient to True!, either use false ur a Ingredient with count");
            } else {
                reloadedBlueprints.put(id, (BlueprintComponent)((Pair)BlueprintComponent.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow()).getFirst());
            }
        }, 5.0f);
        ReloadEvents.END.subscribe((isClient, registryAccess) -> Miapi.LOGGER.info("Loaded " + reloadedBlueprints.size() + " Blueprints"));
    }

    public static CraftOption asCraftOption(CraftingScreenHandler screenHandler, ResourceLocation location, BlueprintComponent blueprint) {
        return new CraftOption(blueprint.toMerge.module, () -> {
            JsonElement decodeResult = (JsonElement)ResourceLocation.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)location).getOrThrow();
            JsonElement booleanElement = (JsonElement)Miapi.FIXED_BOOL_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)blueprint.useMaterialCrafting()).getOrThrow();
            return Map.of(ID, decodeResult, AllowedMaterial.KEY, booleanElement);
        }, -100.0, blueprint.getName());
    }

    @Nullable
    public static BlueprintComponent getBlueprint(Map<ResourceLocation, JsonElement> dataMap, CraftingScreenHandler screenHandler) {
        ResourceLocation decodeResult;
        JsonElement json = dataMap.get(ID);
        if (json != null && reloadedBlueprints.containsKey(decodeResult = (ResourceLocation)((Pair)ResourceLocation.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst())) {
            return reloadedBlueprints.get(decodeResult);
        }
        return null;
    }
}

