/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.redpxnda.nucleus.impl.ShaderRegistry;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import smartin.miapi.Miapi;
import smartin.miapi.client.atlas.MaterialAtlasManager;

@OnlyIn(value=Dist.CLIENT)
public class GlintShader {
    public static final ResourceLocation customGlintTexture = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"textures/custom_glint.png");
    public static ShaderInstance entityTranslucentMaterialShader;
    public static ShaderInstance glintShader;
    public static VertexFormat GLINT_VERTEX_FORMAT;
    public static final RenderType modularItemGlint;
    public static final RenderType TRANSLUCENT_NO_CULL;

    private static void setupGlintTexturing(float scale) {
        long l = (long)((double)Util.getMillis() * (Double)Minecraft.getInstance().options.glintSpeed().get() * 8.0);
        float f = (float)(l % 110000L) / 110000.0f;
        float g = (float)(l % 30000L) / 30000.0f;
        Matrix4f matrix4f = new Matrix4f().translation(-f, g, 0.0f);
        matrix4f.rotateZ(0.17453292f).scale(scale);
        RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
    }

    public static void setupItem(Matrix4f matrix4f) {
        glintShader.safeGetUniform("ModelMat").set(new Matrix4f((Matrix4fc)matrix4f));
    }

    public static void registerShaders() {
        ShaderRegistry.register((ResourceLocation)Miapi.id("rendertype_item_glint"), (VertexFormat)GLINT_VERTEX_FORMAT, s -> {
            glintShader = s;
        });
    }

    static {
        GLINT_VERTEX_FORMAT = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).add("UV1", VertexFormatElement.UV1).add("UV2", VertexFormatElement.UV2).add("Normal", VertexFormatElement.NORMAL).padding(1).build();
        modularItemGlint = RenderType.create((String)"miapi_glint_direct|immediatelyfast:renderlast", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> {
            if (!RenderSystem.isOnRenderThreadOrInit()) {
                throw new RuntimeException("attempted miapi glint setup on-non-render thread. Please report this to Truly Modular");
            }
            glintShader.apply();
            int id = 10;
            RenderSystem.setShaderTexture((int)id, (ResourceLocation)customGlintTexture);
            RenderSystem.bindTexture((int)id);
            int j = RenderSystem.getShaderTexture((int)id);
            glintShader.setSampler("CustomGlintTexture", (Object)j);
            RenderStateShard.TextureStateShard a = new RenderStateShard.TextureStateShard(customGlintTexture, true, false);
            return glintShader;
        })).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.builder().add(TextureAtlas.LOCATION_BLOCKS, false, false).add(MaterialAtlasManager.MATERIAL_ID, false, false).build()).setDepthTestState(RenderStateShard.EQUAL_DEPTH_TEST).setTransparencyState(RenderStateShard.GLINT_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).setWriteMaskState(RenderStateShard.COLOR_WRITE).setTexturingState(RenderType.ENTITY_GLINT_TEXTURING).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
        TRANSLUCENT_NO_CULL = RenderType.create((String)"miapi_translucent_no_cull", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(RenderStateShard.LIGHTMAP).setShaderState(RenderStateShard.RENDERTYPE_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET_MIPPED).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.TRANSLUCENT_TARGET).setCullState(RenderStateShard.NO_CULL).createCompositeState(true));
    }
}

