/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redpxnda.nucleus.config.ConfigManager;
import com.redpxnda.nucleus.config.ConfigObject;
import com.redpxnda.nucleus.event.RenderEvents;
import com.redpxnda.nucleus.registry.effect.RenderingMobEffect;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchRenderer;
import smartin.miapi.blueprint.BlueprintComponent;
import smartin.miapi.blueprint.BlueprintManager;
import smartin.miapi.client.GlintShader;
import smartin.miapi.client.atlas.MaterialAtlasManager;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.MiapiConfigScreen;
import smartin.miapi.client.gui.crafting.crafter.replace.ReplaceView;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.client.model.ModularModelPredicateProvider;
import smartin.miapi.client.renderer.SpriteLoader;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.effects.CryoStatusEffect;
import smartin.miapi.entity.ItemProjectileRenderer;
import smartin.miapi.events.ClientEvents;
import smartin.miapi.material.MaterialCommand;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.MaterialRenderControllers;
import smartin.miapi.modules.MiapiPermissions;
import smartin.miapi.modules.abilities.key.ClientKeybinding;
import smartin.miapi.modules.cache.CacheCommands;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.render.colorproviders.ColorProvider;
import smartin.miapi.modules.properties.slot.AllowedSlots;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

public class MiapiClient {
    public static MaterialAtlasManager materialAtlasManager;
    public static boolean shaderModLoaded;
    public static boolean sodiumLoaded;
    public static boolean jerLoaded;
    public static final MiapiRegistry<KeyMapping> KEY_BINDINGS;

    private MiapiClient() {
    }

    public static void init() {
        ConfigObject config = ConfigManager.getConfigObject((ResourceLocation)Miapi.id("server"));
        if (config.getInstance() == null) {
            config.load();
        }
        if (Platform.getMod((String)"nucleus").getVersion().equals("1.1.4")) {
            RenderEvents.LIVING_ENTITY_RENDER.register((stage, model, entity, entityYaw, partialTick, matrixStack, multiBufferSource, packedLight) -> {
                if (stage != RenderEvents.EntityRenderStage.PRE) {
                    return EventResult.pass();
                }
                for (Map.Entry entry : entity.getActiveEffectsMap().entrySet()) {
                    boolean result;
                    MobEffectInstance instance = (MobEffectInstance)entry.getValue();
                    Holder effect = (Holder)entry.getKey();
                    Object patt0$temp = effect.value();
                    if (!(patt0$temp instanceof RenderingMobEffect)) continue;
                    RenderingMobEffect rendering = (RenderingMobEffect)patt0$temp;
                    if (instance.getDuration() <= 0 && !instance.isInfiniteDuration() || !(result = rendering.renderPre(instance, entity, entityYaw, partialTick, matrixStack, multiBufferSource, packedLight))) continue;
                    return EventResult.interruptFalse();
                }
                return EventResult.pass();
            });
            RenderEvents.LIVING_ENTITY_RENDER.register((stage, model, entity, entityYaw, partialTick, matrixStack, multiBufferSource, packedLight) -> {
                if (stage != RenderEvents.EntityRenderStage.POST) {
                    return EventResult.pass();
                }
                entity.getActiveEffectsMap().forEach((effect, instance) -> {
                    Object patt0$temp = effect.value();
                    if (patt0$temp instanceof RenderingMobEffect) {
                        RenderingMobEffect rendering = (RenderingMobEffect)patt0$temp;
                        if (instance.getDuration() > 0 || instance.isInfiniteDuration()) {
                            rendering.renderPost(instance, entity, entityYaw, partialTick, matrixStack, multiBufferSource, packedLight);
                        }
                    }
                });
                return EventResult.pass();
            });
        }
        RegistryInventory.MODULAR_ITEMS.addCallback(MiapiClient::registerAnimations);
        ClientTickEvent.CLIENT_PRE.register(instance -> {
            if (MiapiConfig.getClientConfig().other.animatedMaterials) {
                Minecraft.getInstance().getProfiler().push("miapiMaterialAnimations");
                MaterialSpriteManager.tick();
                Minecraft.getInstance().getProfiler().pop();
            }
            ClientKeybinding.clientTick(instance);
        });
        Networking.registerS2CPacket(MaterialCommand.SEND_MATERIAL_CLIENT, buf -> {
            String materialId = buf.readUtf();
            Minecraft.getInstance().execute(() -> {
                Material material = MaterialProperty.MATERIAL_REGISTRY.get(Miapi.id(materialId));
                if (material != null) {
                    String raw = Miapi.gson.toJson((JsonElement)material.getDebugJson());
                    MutableComponent text = Component.literal((String)raw);
                    ClickEvent event = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, raw);
                    text = (Component)text.toFlatList(Style.EMPTY.withClickEvent(event)).get(0);
                    Minecraft.getInstance().player.sendSystemMessage((Component)text);
                }
            });
        });
        Networking.registerS2CPacket(CacheCommands.SEND_MATERIAL_CLIENT, buf -> Minecraft.getInstance().execute(ModularItemCache::discardCache));
        ClientReloadShadersEvent.EVENT.register((resourceFactory, shadersSink) -> {
            ModularItemCache.discardCache();
            if (Minecraft.getInstance().level != null) {
                Minecraft.getInstance().execute(() -> {
                    LinkedHashMap<ResourceLocation, String> cacheDatapack = new LinkedHashMap<ResourceLocation, String>(ReloadEvents.DATA_PACKS);
                    ++ReloadEvents.reloadCounter;
                    ReloadEvents.START.fireEvent(true, Minecraft.getInstance().level.registryAccess());
                    ReloadEvents.DataPackLoader.trigger(cacheDatapack);
                    ReloadEvents.MAIN.fireEvent(true, Minecraft.getInstance().level.registryAccess());
                    ReloadEvents.END.fireEvent(true, Minecraft.getInstance().level.registryAccess());
                    --ReloadEvents.reloadCounter;
                    ModularItemCache.discardCache();
                });
            }
        });
        ConfigManager.CONFIG_SCREENS_REGISTRY.register(registerer -> registerer.add("miapi", MiapiConfigScreen::new));
        MaterialRenderControllers.setup();
        MaterialIcons.setup();
        ColorProvider.setup();
        ClientLifecycleEvent.CLIENT_SETUP.register(MiapiClient::clientSetup);
        ClientLifecycleEvent.CLIENT_STARTED.register(MiapiClient::clientStart);
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(MiapiClient::clientLevelLoad);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> new Thread(() -> MiapiPermissions.getPerms((Player)player)).start());
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> {
            String version;
            ModularItemCache.discardCache();
            if (jerLoaded && Miapi.server == null && ((version = Platform.getMod((String)"jeresources").getVersion()).equals("1.4.0.238") || version.equals("1.4.0.246") || version.equals("1.4.0.247"))) {
                player.sendSystemMessage((Component)Component.literal((String)"Just Enough Resources 1.20.1-1.4.0.247 Release is broken on servers. Please Remove it."));
                ClickEvent event = new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/way2muchnoise/JustEnoughResources/issues/392");
                MutableComponent link = Component.literal((String)"For more information you can read this");
                player.sendSystemMessage((Component)link.toFlatList(Style.EMPTY.withClickEvent(event).withUnderlined(Boolean.valueOf(true))).get(0));
                player.sendSystemMessage((Component)Component.literal((String)"This message was sent by Truly Modular."));
            }
        });
        ClientReloadShadersEvent.EVENT.register((resourceFactory, asd) -> ModularItemCache.discardCache());
        RegistryInventory.MODULAR_ITEMS.addCallback(item -> {
            ModularModelPredicateProvider.registerModelOverride(item, Miapi.id("damage"), (stack, world, entity, seed) -> stack.isDamageableItem() && stack.getDamageValue() > 0 ? (float)stack.getDamageValue() / (float)stack.getMaxDamage() : 0.0f);
            ModularModelPredicateProvider.registerModelOverride(item, Miapi.id("damaged"), (stack, world, entity, seed) -> stack.isDamaged() ? 1.0f : 0.0f);
        });
        ReloadEvents.START.subscribe((isClient, registryAccess) -> {
            if (isClient) {
                StatListWidget.onReload();
            }
        });
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            if (isClient) {
                StatListWidget.reloadEnd();
            }
        });
        if (sodiumLoaded) {
            ClientEvents.HUD_RENDER.register((drawContext, deltaTick) -> MaterialSpriteManager.onHudRender(drawContext));
        }
        ReplaceView.optionSuppliers.add(option -> option.getScreenHandler().slots.stream().filter(a -> a.getItem().has(BlueprintComponent.BLUEPRINT_COMPONENT)).map(a -> (BlueprintComponent)a.getItem().get(BlueprintComponent.BLUEPRINT_COMPONENT)).filter(b -> {
            for (String id : AllowedSlots.getAllowedSlots(b.toMerge)) {
                if (!option.getSlot().allowed.contains(id)) continue;
                return true;
            }
            return false;
        }).map(a -> a.asCraftOption(option.getScreenHandler())).toList());
        ReplaceView.optionSuppliers.add(option -> {
            ArrayList options = new ArrayList();
            BlueprintManager.reloadedBlueprints.forEach((id, blueprint) -> {
                boolean isAllowed = false;
                for (String slotID : AllowedSlots.getAllowedSlots(blueprint.toMerge)) {
                    if (!option.getSlot().allowed.contains(slotID)) continue;
                    isAllowed = true;
                }
                if (isAllowed) {
                    options.add(BlueprintManager.asCraftOption(option.getScreenHandler(), id, blueprint));
                }
            });
            return options;
        });
        GlintShader.registerShaders();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerAnimations(Item item) {
        ModularModelPredicateProvider.registerModelOverride(item, Miapi.id("damage"), (stack, world, entity, seed) -> stack.isDamageableItem() && stack.isDamaged() ? 0.0f : (float)stack.getMaxDamage() / (float)(stack.getMaxDamage() - stack.getDamageValue()));
        ModularModelPredicateProvider.registerModelOverride(item, Miapi.id("damaged"), (stack, world, entity, seed) -> stack.isDamaged() ? 0.0f : 1.0f);
    }

    public static boolean isSodiumLoaded() {
        return Platform.isModLoaded((String)"sodium") || Platform.isModLoaded((String)"embeddium") || Platform.isModLoaded((String)"magnesium") || Platform.isModLoaded((String)"rubidium");
    }

    public static boolean isHigherVersion(String version, String compareToVersion) {
        String[] versionParts = version.split("\\.");
        String[] compareToVersionParts = compareToVersion.split("\\.");
        for (int i = 0; i < versionParts.length && i < compareToVersionParts.length; ++i) {
            int part2;
            int part1 = Integer.parseInt(versionParts[i]);
            if (part1 > (part2 = Integer.parseInt(compareToVersionParts[i]))) {
                return true;
            }
            if (part1 >= part2) continue;
            return false;
        }
        return versionParts.length > compareToVersionParts.length;
    }

    protected static void clientSetup(Minecraft client) {
        SpriteLoader.setup();
    }

    public static void runOnClientEnsured(Runnable runnable) {
        if (RenderSystem.isOnRenderThreadOrInit()) {
            runnable.run();
        } else {
            Minecraft mc = Minecraft.getInstance();
            mc.execute(runnable);
        }
    }

    protected static void clientStart(Minecraft client) {
        CryoStatusEffect.setupOnClient();
    }

    protected static void clientLevelLoad(ClientLevel clientWorld) {
        SpriteLoader.clientStart();
        ModularItemCache.discardCache();
    }

    public static void registerScreenHandler() {
        MenuRegistry.registerScreenFactory(RegistryInventory.craftingScreenHandler, CraftingScreen::new);
    }

    public static void registerEntityRenderer() {
        EntityRendererRegistry.register(RegistryInventory.itemProjectileType, ItemProjectileRenderer::new);
    }

    public static void registerBlockEntityRenderer() {
        BlockEntityRendererRegistry.register(RegistryInventory.modularWorkBenchEntityType, ModularWorkBenchRenderer::new);
    }

    static {
        shaderModLoaded = Platform.isModLoaded((String)"iris") || Platform.isModLoaded((String)"optifine") || Platform.isModLoaded((String)"optifabric") || Platform.isModLoaded((String)"oculus");
        sodiumLoaded = MiapiClient.isSodiumLoaded();
        jerLoaded = Platform.isModLoaded((String)"jeresources");
        KEY_BINDINGS = MiapiRegistry.getInstance(KeyMapping.class);
    }
}

