/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.TextureAtlasHolder;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.mixin.TextureAtlasAccessor;
import smartin.miapi.mixin.TextureAtlasHolderAccessor;

@OnlyIn(value=Dist.CLIENT)
public class MaterialAtlasManager
extends TextureAtlasHolder {
    public static final ResourceLocation MATERIAL_ID = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"miapi_materials");
    public static final ResourceLocation MATERIAL_ATLAS_ID = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"textures/atlas/materials.png");
    public static final ResourceLocation BASE_MATERIAL_ID = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"miapi_materials/base_palette");
    protected final List<AddedSpriteEntry> addedSprites = new ArrayList<AddedSpriteEntry>();

    public MaterialAtlasManager(TextureManager textureManager) {
        super(textureManager, MATERIAL_ATLAS_ID, MATERIAL_ID);
    }

    public void addSpriteToLoad(ResourceLocation id) {
        this.addedSprites.add(new AddedSpriteEntry(id, s -> {}));
    }

    public void addSpriteToLoad(ResourceLocation id, Consumer<SpriteContents> onAdded) {
        this.addedSprites.add(new AddedSpriteEntry(id, onAdded));
    }

    @Nullable
    public TextureAtlasSprite getMaterialSprite(ResourceLocation id) {
        try {
            TextureAtlasSprite sprite = this.getSprite(id);
            TextureAtlas atlas = ((TextureAtlasHolderAccessor)((Object)this)).getTextureAtlas();
            if (sprite == ((TextureAtlasAccessor)atlas).getMissingSprite()) {
                return null;
            }
            return this.getSprite(id);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public record AddedSpriteEntry(ResourceLocation id, Consumer<SpriteContents> onCreated) {
    }
}

