/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.SpriteColorer;

@OnlyIn(value=Dist.CLIENT)
public class MaterialSpriteManager {
    static Map<Holder, DynamicTexture> animated_Textures = new HashMap<Holder, DynamicTexture>();
    public static final long CACHE_SIZE = 10000L;
    public static final long CACHE_LIFETIME = 10L;
    public static final TimeUnit CACHE_LIFETIME_UNIT = TimeUnit.SECONDS;
    protected static Map<ResourceLocation, DynamicTexture> nativeImageBackedTextureMap = new HashMap<ResourceLocation, DynamicTexture>();
    public static Set<TextureAtlasSprite> animated = new HashSet<TextureAtlasSprite>();
    protected static final Cache<Holder, ResourceLocation> materialSpriteCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(10L, CACHE_LIFETIME_UNIT).removalListener(notification -> {
        if (notification.wasEvicted()) {
            Object patt1$temp;
            Object patt0$temp = notification.getValue();
            if (patt0$temp instanceof ResourceLocation) {
                ResourceLocation removeId = (ResourceLocation)patt0$temp;
                DynamicTexture texture = nativeImageBackedTextureMap.get(removeId);
                if (texture != null) {
                    texture.close();
                }
                Minecraft.getInstance().getTextureManager().release(removeId);
            }
            if ((patt1$temp = notification.getKey()) instanceof Holder) {
                Holder holder = (Holder)patt1$temp;
                animated_Textures.remove(holder);
                try {
                    holder.colorer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }).build((CacheLoader)new CacheLoader<Holder, ResourceLocation>(){

        public ResourceLocation load(Holder key) {
            return MaterialSpriteManager.getMaterialSprite(key);
        }
    });

    public static ResourceLocation getMaterialSprite(TextureAtlasSprite oldSprite, Material material, SpriteColorer materialSpriteColorer) {
        Holder holder = new Holder(oldSprite, material, materialSpriteColorer);
        return MaterialSpriteManager.getMaterialSprite(holder);
    }

    public static ResourceLocation getMaterialSprite(Holder holder) {
        ResourceLocation identifier = (ResourceLocation)materialSpriteCache.getIfPresent((Object)holder);
        if (identifier == null) {
            SpriteColorer.MaterialRecoloredSpriteHolder colorer = holder.colorer().createSpriteManager(holder.sprite().contents());
            DynamicTexture nativeImageBackedTexture = new DynamicTexture(colorer.recolor().mappedCopy(IntUnaryOperator.identity()));
            ResourceLocation spriteId = Minecraft.getInstance().getTextureManager().register("miapi/dynmaterialsprites", nativeImageBackedTexture);
            if (colorer.requireTick()) {
                animated_Textures.put(holder, nativeImageBackedTexture);
            }
            materialSpriteCache.put((Object)holder, (Object)spriteId);
            return spriteId;
        }
        return identifier;
    }

    public static void clear() {
        materialSpriteCache.invalidateAll();
    }

    public static void tick() {
        if (!ReloadEvents.isInReload()) {
            ArrayList toRemove = new ArrayList();
            animated_Textures.forEach((holder, nativeImageBackedTexture) -> {
                try {
                    holder.colorer.tick(nativeImage -> {
                        nativeImageBackedTexture.getPixels().copyFrom(nativeImage);
                        nativeImageBackedTexture.upload();
                    }, holder.sprite().contents());
                }
                catch (Exception e) {
                    toRemove.add(holder);
                }
            });
            toRemove.forEach(arg_0 -> materialSpriteCache.invalidate(arg_0));
        }
    }

    public static void markTextureAsAnimatedInUse(TextureAtlasSprite sprite) {
        if (MiapiClient.isSodiumLoaded()) {
            animated.add(sprite);
        }
    }

    public static void onHudRender(GuiGraphics drawContext) {
        VertexConsumer consumer = ItemRenderer.getFoilBuffer((MultiBufferSource)drawContext.bufferSource(), (RenderType)RenderType.gui(), (boolean)false, (boolean)false);
        int[] quadData = new int[32];
        for (TextureAtlasSprite sprite : animated) {
            BakedQuad bakedQuad = new BakedQuad(quadData, 0, Direction.DOWN, sprite, false);
            consumer.putBulkData(drawContext.pose().last(), bakedQuad, 0.0f, 0.0f, 0.0f, 0.0f, 0, 0);
        }
        animated.clear();
    }

    public record Holder(TextureAtlasSprite sprite, Material material, SpriteColorer colorer) {
    }
}

