/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import smartin.miapi.client.gui.InteractAbleWidget;

@OnlyIn(value=Dist.CLIENT)
public class HoverDescription
extends InteractAbleWidget {
    public List<FormattedCharSequence> lines;
    public ClientTooltipPositioner positioner = AbsoluteTooltipPositioner.INSTANCE;
    public int maxWidth = -1;

    public HoverDescription(int x, int y, Component unified) {
        super(x, y, 0, 0, (Component)Component.empty());
        this.lines = new ArrayList<FormattedCharSequence>();
        for (String s : unified.getString().split("\\r?\\n")) {
            this.lines.add(Component.literal((String)s).getVisualOrderText());
        }
        this.updateSize(this.lines);
    }

    public HoverDescription(int x, int y, List<Component> text) {
        super(x, y, 0, 0, (Component)Component.empty());
        this.lines = this.toOrderedText(text);
        this.updateSize(this.lines);
    }

    public List<FormattedCharSequence> toOrderedText(List<? extends FormattedText> list) {
        return list.stream().map(this::toOrderedText).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<FormattedCharSequence> toOrderedText(FormattedText visitable) {
        return Minecraft.getInstance().font.split(visitable, this.maxWidth == -1 ? 10000 : this.maxWidth);
    }

    public void updateSize(List<FormattedCharSequence> lines) {
        int w = 0;
        int h = lines.size() == 1 ? -2 : 0;
        for (int e = 0; e < lines.size(); ++e) {
            FormattedCharSequence text = lines.get(e);
            ClientTooltipComponent tooltipComponent = ClientTooltipComponent.create((FormattedCharSequence)text);
            int compWidth = tooltipComponent.getWidth(Minecraft.getInstance().font);
            if (compWidth > w) {
                w = compWidth;
            }
            h += tooltipComponent.getHeight();
        }
        this.width = w;
        this.height = h;
    }

    public void setText(Component unified) {
        this.lines = new ArrayList<FormattedCharSequence>();
        for (String s : unified.getString().split("\\r?\\n")) {
            this.lines.addAll(this.toOrderedText((FormattedText)Component.literal((String)s)));
        }
        this.updateSize(this.lines);
    }

    public void setText(List<Component> text) {
        List<FormattedCharSequence> ordered = this.toOrderedText(text);
        this.lines = ordered;
        this.updateSize(ordered);
    }

    public void addText(Component text) {
        List<FormattedCharSequence> orderedText = this.toOrderedText((FormattedText)text);
        this.lines.addAll(orderedText);
        this.updateSize(orderedText);
    }

    public void addText(List<Component> text) {
        List<FormattedCharSequence> ordered = this.toOrderedText(text);
        this.lines.addAll(ordered);
        this.updateSize(ordered);
    }

    public void reset() {
        this.lines.clear();
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.renderTooltip(Minecraft.getInstance().font, this.lines, this.positioner, this.getX(), this.getY());
    }

    public static class AbsoluteTooltipPositioner
    implements ClientTooltipPositioner {
        public static final AbsoluteTooltipPositioner INSTANCE = new AbsoluteTooltipPositioner();

        protected AbsoluteTooltipPositioner() {
        }

        public Vector2ic positionTooltip(int screenWidth, int screenHeight, int x, int y, int width, int height) {
            return new Vector2i(x, y).add(4, 4);
        }
    }
}

