/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector2d;
import smartin.miapi.config.MiapiConfig;

@OnlyIn(value=Dist.CLIENT)
public abstract class InteractAbleWidget
extends AbstractWidget
implements Renderable,
GuiEventListener {
    protected final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    protected final List<InteractAbleWidget> hoverElements = new ArrayList<InteractAbleWidget>();
    public boolean debug = false;
    public int randomColor = FastColor.ARGB32.color((int)180, (int)((int)(Math.random() * 255.0)), (int)((int)(Math.random() * 255.0)), (int)((int)(Math.random() * 255.0)));

    protected InteractAbleWidget(int x, int y, int width, int height, Component title) {
        super(x, y, width, height, title);
    }

    public static void drawSquareBorder(GuiGraphics drawContext, int x, int y, int width, int height, int borderWidth, int color) {
        drawContext.fill(x, y, x + width, y + borderWidth, 100, color);
        drawContext.fill(x, y + height, x + width, y + height - borderWidth, 100, color);
        drawContext.fill(x, y, x + borderWidth, y + height, 100, color);
        drawContext.fill(x + width, y, x + width - borderWidth, y + height, 100, color);
    }

    public static void drawTextureWithEdgeAndScale(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int u, int v, int regionWidth, int regionHeight, int width, int height, int textureWidth, int textureHeight, int borderWidth, float scale) {
        GuiGraphics context = new GuiGraphics(Minecraft.getInstance(), drawContext.bufferSource());
        context.pose().mulPose(drawContext.pose().last().pose());
        context.pose().last().pose().scale(1.0f / scale);
        InteractAbleWidget.drawTextureWithEdge(context, texture, (int)((float)x * scale), (int)((float)y * scale), u, v, regionWidth, regionHeight, (int)((float)width * scale), (int)((float)height * scale), textureWidth, textureHeight, borderWidth);
    }

    public static void drawTextureWithEdge(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int u, int v, int regionWidth, int regionHeight, int width, int height, int textureWidth, int textureHeight, int borderWidth) {
        drawContext.blit(texture, x + borderWidth, y + borderWidth, width - 2 * borderWidth, height - 2 * borderWidth, (float)(u + borderWidth), (float)(v + borderWidth), regionWidth - borderWidth * 2, regionHeight - borderWidth * 2, textureWidth, textureHeight);
        drawContext.blit(texture, x, y, borderWidth, borderWidth, (float)u, (float)v, borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.blit(texture, x + width - borderWidth, y, borderWidth, borderWidth, (float)(u + regionWidth - borderWidth), (float)v, borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.blit(texture, x, y + height - borderWidth, borderWidth, borderWidth, (float)u, (float)(v + regionHeight - borderWidth), borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.blit(texture, x + width - borderWidth, y + height - borderWidth, borderWidth, borderWidth, (float)(u + regionWidth - borderWidth), (float)(v + regionHeight - borderWidth), borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.blit(texture, x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, (float)(u + borderWidth), (float)(v + regionHeight - borderWidth), regionWidth - borderWidth * 2, borderWidth, textureWidth, textureHeight);
        drawContext.blit(texture, x + width - borderWidth, y + borderWidth, borderWidth, height - 2 * borderWidth, (float)(u + regionWidth - borderWidth), (float)(v + borderWidth), borderWidth, regionHeight - borderWidth * 2, textureWidth, textureHeight);
        drawContext.blit(texture, x, y + borderWidth, borderWidth, height - 2 * borderWidth, (float)u, (float)(v + borderWidth), borderWidth, regionHeight - borderWidth * 2, textureWidth, textureHeight);
        drawContext.blit(texture, x + borderWidth, y, width - 2 * borderWidth, borderWidth, (float)(u + borderWidth), (float)v, regionWidth - borderWidth * 2, borderWidth, textureWidth, textureHeight);
    }

    public static void drawTextureWithEdge(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderWidth) {
        InteractAbleWidget.drawTextureWithEdge(drawContext, texture, x, y, 0, 0, textureWidth, textureHeight, width, height, textureWidth, textureHeight, borderWidth);
    }

    public List<InteractAbleWidget> getHoverElements() {
        ArrayList<InteractAbleWidget> allHoverElements = new ArrayList<InteractAbleWidget>(this.hoverElements);
        this.children().forEach(currentChildren -> {
            if (currentChildren instanceof InteractAbleWidget) {
                InteractAbleWidget widget = (InteractAbleWidget)((Object)currentChildren);
                allHoverElements.addAll(widget.getHoverElements());
            }
        });
        return allHoverElements;
    }

    public void addChild(GuiEventListener element) {
        this.children().add(element);
    }

    public void removeChild(GuiEventListener element) {
        this.children().remove(element);
    }

    public List<GuiEventListener> children() {
        return this.children;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver(mouseX, mouseY)) continue;
            child.mouseMoved(mouseX, mouseY);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children()) {
            if (!child.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public void playClickedSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver(mouseX, mouseY) || !child.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver(mouseX, mouseY) || !child.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (GuiEventListener child : this.children()) {
            if (!child.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener child : this.children()) {
            if (!child.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener child : this.children()) {
            if (!child.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        for (GuiEventListener child : this.children()) {
            if (!child.charTyped(chr, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return super.isMouseOver(mouseX, mouseY);
    }

    public Vector2d getScaledMouseCoords() {
        Minecraft client = Minecraft.getInstance();
        MouseHandler mouse = client.mouseHandler;
        double x = mouse.xpos() * (double)client.getWindow().getGuiScaledWidth() / (double)client.getWindow().getScreenWidth();
        double y = mouse.ypos() * (double)client.getWindow().getGuiScaledHeight() / (double)client.getWindow().getScreenHeight();
        return new Vector2d(x, y);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if ((this.debug || MiapiConfig.getServerConfig().other.developmentMode) && Screen.hasAltDown()) {
            InteractAbleWidget.drawSquareBorder(drawContext, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 1, this.randomColor);
        }
        RenderSystem.setShader(GameRenderer::getPositionShader);
        ArrayList<GuiEventListener> reverse = new ArrayList<GuiEventListener>(this.children());
        Collections.reverse(reverse);
        for (GuiEventListener element : reverse) {
            if (!(element instanceof Renderable)) continue;
            Renderable drawable = (Renderable)element;
            drawable.render(drawContext, mouseX, mouseY, delta);
        }
    }

    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.hoverElements.forEach(widget -> widget.render(drawContext, mouseX, mouseY, delta));
        this.children().forEach(element -> {
            if (element instanceof InteractAbleWidget) {
                InteractAbleWidget widget = (InteractAbleWidget)((Object)element);
                widget.renderHover(drawContext, mouseX, mouseY, delta);
            }
        });
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

