/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;
import smartin.miapi.client.gui.InteractAbleWidget;

public abstract class ParentHandledScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected ParentHandledScreen(T handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    public void addChild(AbstractWidget element) {
        this.addWidget((GuiEventListener)element);
    }

    public void removeChild(GuiEventListener element) {
        this.children().remove(element);
    }

    @Nullable
    public Slot getFocusSlot() {
        return this.hoveredSlot;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        for (GuiEventListener child : this.children().stream().toList()) {
            if (!child.isMouseOver(mouseX, mouseY)) continue;
            child.mouseMoved(mouseX, mouseY);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children().stream().toList()) {
            if (!child.isMouseOver(mouseX, mouseY) || !child.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children().stream().toList()) {
            if (!child.isMouseOver(mouseX, mouseY) || !child.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (GuiEventListener child : this.children().stream().toList()) {
            if (!child.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (GuiEventListener child : this.children().stream().toList()) {
            if (!child.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener child : this.children().stream().toList()) {
            if (!child.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener child : this.children().stream().toList()) {
            if (!child.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char chr, int modifiers) {
        for (GuiEventListener child : this.children().stream().toList()) {
            if (!child.charTyped(chr, modifiers)) continue;
            return true;
        }
        return super.charTyped(chr, modifiers);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return super.isMouseOver(mouseX, mouseY);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        RenderSystem.disableDepthTest();
        this.children().forEach(element -> {
            if (element instanceof Renderable) {
                Renderable drawable = (Renderable)element;
                drawable.render(context, mouseX, mouseY, delta);
            }
        });
        RenderSystem.enableDepthTest();
    }

    public void renderHover(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.pose().last().pose().transform(new Vector4f(0.0f, 0.0f, 500.0f, 0.0f));
        this.children().forEach(element -> {
            if (element instanceof InteractAbleWidget) {
                InteractAbleWidget drawable = (InteractAbleWidget)((Object)element);
                drawable.renderHover(context, mouseX, mouseY, delta);
            }
        });
    }
}

