/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;

@OnlyIn(value=Dist.CLIENT)
public class SimpleButton<T>
extends InteractAbleWidget {
    private final T toCallback;
    private final Consumer<T> callback;
    public boolean isEnabled = true;

    public SimpleButton(int x, int y, int width, int height, Component title, T toCallback, Consumer<T> callback) {
        super(x, y, width, height, title);
        assert (callback != null);
        this.toCallback = toCallback;
        this.callback = callback;
        ScrollingTextWidget textWidget = new ScrollingTextWidget(x, y, width, title, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        textWidget.setOrientation(ScrollingTextWidget.Orientation.CENTERED);
        textWidget.hasTextShadow = false;
        this.addChild(textWidget);
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.renderButton(drawContext, mouseX, mouseY, delta);
        this.children().forEach(children -> {
            if (children instanceof InteractAbleWidget) {
                InteractAbleWidget widget = (InteractAbleWidget)((Object)children);
                widget.setX(this.getX() + 2);
                widget.setY(Math.max(this.getY() + 1, this.getY() + 1 + (this.height - 9) / 2));
                widget.setWidth(this.width - 4);
            }
        });
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && this.isEnabled) {
            this.playClickedSound();
            this.callback.accept(this.toCallback);
            return true;
        }
        return false;
    }

    public void renderButton(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.setShader(GameRenderer::getRendertypeTranslucentShader);
        int offset = 0;
        if (this.isMouseOver(mouseX, mouseY)) {
            offset = 10;
        }
        if (!this.isEnabled) {
            offset = 20;
        }
        SimpleButton.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, this.getX(), this.getY(), 339 + offset, 165, 10, 10, this.getWidth(), this.getHeight(), 512, 512, 3);
    }
}

