/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;

@OnlyIn(value=Dist.CLIENT)
public class StatBar
extends InteractAbleWidget {
    public ResourceLocation texture = CraftingScreen.BACKGROUND_TEXTURE;
    double primaryPercent = 0.0;
    double secondaryPercent = 0.0;
    int primaryColor = 0;
    int secondaryColor = 0;
    int offColor;
    int shadowSize = 1;

    public StatBar(int x, int y, int width, int height, int offColor) {
        super(x, y, width, height, (Component)Component.empty());
        this.offColor = offColor;
    }

    public void setPrimary(double primaryPercent, int color) {
        primaryPercent = Math.min(1.0, Math.max(0.0, primaryPercent));
        this.primaryColor = color;
        this.primaryPercent = primaryPercent;
    }

    public void setSecondary(double secondaryPercent, int color) {
        secondaryPercent = Math.min(1.0, Math.max(0.0, secondaryPercent));
        this.secondaryColor = color;
        this.secondaryPercent = secondaryPercent;
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)255));
        context.fill(this.getX(), this.getY(), (int)((double)this.getX() + (double)this.width * this.primaryPercent), this.height + this.getY(), this.primaryColor);
        context.fill((int)((double)this.getX() + (double)this.width * this.primaryPercent), this.getY(), (int)((double)this.getX() + (double)this.width * this.secondaryPercent), this.height + this.getY(), this.secondaryColor);
        context.fill((int)((double)this.getX() + (double)this.width * this.secondaryPercent), this.getY(), this.getX() + this.width, this.height + this.getY(), this.offColor);
        StatBar.drawTextureWithEdge(context, this.texture, this.getX(), this.getY() + this.height, 339, 4, 7, 1, this.getWidth(), this.shadowSize, 512, 512, 1);
    }
}

