/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import smartin.miapi.client.gui.InteractAbleWidget;

@OnlyIn(value=Dist.CLIENT)
public class TransformableWidget
extends InteractAbleWidget {
    public Matrix4f rawProjection = new Matrix4f();

    public TransformableWidget(int x, int y, int width, int height, Component title) {
        super(x, y, width, height, title);
    }

    public TransformableWidget(int x, int y, int width, int height, float scale) {
        super(x, y, width, height, (Component)Component.empty());
        this.rawProjection = new Matrix4f();
        this.rawProjection.scale(scale);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        Vector4f position = this.transFormMousePos(mouseX, mouseY);
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver((double)position.x, (double)position.y)) continue;
            child.mouseMoved((double)position.x, (double)position.y);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Vector4f position = this.transFormMousePos(mouseX, mouseY);
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver((double)position.x, (double)position.y) || !child.mouseClicked((double)position.x, (double)position.y, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Vector4f position = this.transFormMousePos(mouseX, mouseY);
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver((double)position.x, (double)position.y) || !child.mouseReleased((double)position.x, (double)position.y, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        Vector4f position = this.transFormMousePos(mouseX, mouseY);
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver((double)position.x, (double)position.y) || !child.mouseDragged((double)position.x, (double)position.y, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        Vector4f position = this.transFormMousePos(mouseX, mouseY);
        for (GuiEventListener child : this.children()) {
            if (!child.mouseScrolled((double)position.x, (double)position.y, scrollX, scrollY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        Vector4f position = this.transFormMousePos(mouseX, mouseY);
        for (GuiEventListener element : this.children()) {
            if (!element.isMouseOver((double)position.x, (double)position.y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        GuiGraphics drawContext = new GuiGraphics(Minecraft.getInstance(), context.bufferSource());
        drawContext.pose().mulPose(context.pose().last().pose());
        drawContext.pose().mulPose(this.rawProjection);
        Vector4f position = this.transFormMousePos(mouseX, mouseY);
        this.children().forEach(element -> {
            if (element instanceof Renderable) {
                Renderable drawable = (Renderable)element;
                drawable.render(drawContext, Math.round(position.x), Math.round(position.y), delta);
            }
        });
    }

    @Override
    public void renderHover(GuiGraphics context, int mouseX, int mouseY, float delta) {
        GuiGraphics drawContext = new GuiGraphics(Minecraft.getInstance(), context.bufferSource());
        drawContext.pose().mulPose(context.pose().last().pose());
        drawContext.pose().mulPose(this.rawProjection);
        Vector4f position = this.transFormMousePos(mouseX, mouseY);
        super.renderHover(drawContext, Math.round(position.x), Math.round(position.y), delta);
    }

    public void renderWidget(InteractAbleWidget widget, GuiGraphics context, int mouseX, int mouseY, float delta) {
        GuiGraphics drawContext = new GuiGraphics(Minecraft.getInstance(), context.bufferSource());
        drawContext.pose().mulPose(context.pose().last().pose());
        drawContext.pose().mulPose(this.rawProjection);
        Vector4f position = this.transFormMousePos(mouseX, mouseY);
        widget.render(drawContext, Math.round(position.x), Math.round(position.y), delta);
    }

    public Vector4f transFormMousePos(int mouseX, int mouseY) {
        return this.transFormMousePos((double)mouseX, (double)mouseY);
    }

    public Vector4f transFormMousePos(double mouseX, double mouseY) {
        Vector4f position = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 0.0f);
        position = position.mul((Matrix4fc)this.getInverse());
        return position;
    }

    public static Vector4f transFormMousePos(double mouseX, double mouseY, Matrix4f matrix4f) {
        Vector4f position = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 0.0f);
        position = position.mul((Matrix4fc)matrix4f);
        return position;
    }

    public Matrix4f getInverse() {
        Matrix4f inverse = new Matrix4f((Matrix4fc)this.rawProjection);
        inverse.invert();
        return inverse;
    }
}

