/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ParentHandledScreen;
import smartin.miapi.client.gui.SimpleScreenHandlerListener;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.MinimizeButton;
import smartin.miapi.client.gui.crafting.PreviewManager;
import smartin.miapi.client.gui.crafting.crafter.DetailView;
import smartin.miapi.client.gui.crafting.crafter.ModuleCrafter;
import smartin.miapi.client.gui.crafting.slotdisplay.SlotDisplay;
import smartin.miapi.client.gui.crafting.slotdisplay.SmithDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.material.MaterialStatWidget;
import smartin.miapi.client.gui.crafting.statdisplay.material.StatDisplayWidget;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.properties.slot.AllowedSlots;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.registries.RegistryInventory;

@OnlyIn(value=Dist.CLIENT)
public class CraftingScreen
extends ParentHandledScreen<CraftingScreenHandler>
implements MenuAccess<CraftingScreenHandler> {
    public static final ResourceLocation BACKGROUND_TEXTURE = Miapi.id("textures/gui/crafter/background.png");
    private ModuleCrafter moduleCrafter;
    private StatDisplayWidget statDisplay;
    private MaterialStatWidget materialStatWidget;
    private SlotDisplay slotDisplay;
    private SmithDisplay smithDisplay;
    private MinimizeButton minimizer;
    private SlotProperty.ModuleSlot baseSlot;
    @Nullable
    public static SlotProperty.ModuleSlot slot;
    @Nullable
    public static EditOption editOption;
    private TransformableWidget editHolder;
    static int editSpace;
    @Nullable
    public InteractAbleWidget hoverElement = null;
    public CompoundTag oldCompound = new CompoundTag();
    static WeakReference<CraftingScreen> craftingScreenWeakReference;
    public int overwriteMouseY = 0;
    public int overwriteMouseX = 0;
    public ItemStack currentStack = ItemStack.EMPTY;
    List<InteractAbleWidget> editOptionIcons = new ArrayList<InteractAbleWidget>();

    public CraftingScreen(CraftingScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, (Component)Component.empty());
        slot = null;
        this.imageWidth = 372;
        this.imageHeight = 199;
        DetailView.scrollPos = 0;
        craftingScreenWeakReference = new WeakReference<CraftingScreen>(this);
    }

    @Nullable
    public static CraftingScreen getInstance() {
        if (craftingScreenWeakReference != null && craftingScreenWeakReference.get() != null) {
            return (CraftingScreen)((Object)craftingScreenWeakReference.get());
        }
        return null;
    }

    public EditOption getEditOption() {
        return editOption;
    }

    public void selectSlot(SlotProperty.ModuleSlot slot) {
        CraftingScreen.slot = slot;
        this.updateEditOptions();
    }

    public void previewStack(ItemStack itemStack) {
        this.slotDisplay.setItem(itemStack);
        this.statDisplay.setCompareTo(itemStack);
        this.smithDisplay.setPreview(itemStack);
    }

    public void selectEditOption(EditOption editOption) {
        CraftingScreen.editOption = editOption;
        this.moduleCrafter.setSelectedSlot(slot);
        this.moduleCrafter.setEditMode(editOption, this.get(editOption));
        PreviewManager.resetCursorStack();
    }

    public void init() {
        slot = null;
        editOption = null;
        ArrayList<String> allowedModules = new ArrayList<String>();
        allowedModules.add("melee");
        this.baseSlot = new SlotProperty.ModuleSlot(allowedModules);
        int centerX = (this.width - this.imageWidth - 6) / 2;
        int centerY = (this.height - this.imageHeight) / 2;
        this.moduleCrafter = new ModuleCrafter(centerX + 51 - 15, centerY + 22 - 14, 144, 89, this::selectSlot, item -> {
            this.slotDisplay.setItem((ItemStack)item);
            this.statDisplay.setCompareTo((ItemStack)item);
            this.smithDisplay.setPreview((ItemStack)item);
        }, ((CraftingScreenHandler)this.menu).inventory, ((CraftingScreenHandler)this.menu)::addSlotByClient, ((CraftingScreenHandler)this.menu)::removeSlotByClient);
        this.moduleCrafter.setPacketIdentifier(((CraftingScreenHandler)this.menu).packetID);
        this.addChild(this.moduleCrafter);
        this.slotDisplay = new SlotDisplay(ItemStack.EMPTY, centerX + 51 - 15, centerY + 117 - 14, 68, 87, selected -> {});
        this.slotDisplay.setItem(this.getItem());
        this.addChild(this.slotDisplay);
        this.smithDisplay = new SmithDisplay(centerX + 140 - 15, centerY + 117 - 14, 55, 70);
        this.addChild(this.smithDisplay);
        this.statDisplay = new StatDisplayWidget(centerX + 213 - 15, centerY + 30 - 14, 161, 95);
        this.addChild(this.statDisplay);
        this.minimizer = new MinimizeButton(centerX + 178 - 15, centerY + 188 - 14, 18, 18, this::minimizeView, this::maximizeView);
        this.addChild(this.minimizer);
        super.init();
        this.inventoryLabelX = -1000;
        this.inventoryLabelY = -1000;
        this.editHolder = new TransformableWidget(this.leftPos - 15, this.topPos - 14, 0, 0, (Component)Component.empty());
        this.addChild(this.editHolder);
        this.updateItem(((CraftingScreenHandler)this.menu).inventory.getItem(0));
        if (this.moduleCrafter != null) {
            this.moduleCrafter.handler = (CraftingScreenHandler)this.menu;
        }
        ((CraftingScreenHandler)this.menu).addSlotListener(new SimpleScreenHandlerListener((TriConsumer<AbstractContainerMenu, Integer, ItemStack>)((TriConsumer)(handler, slotId, stack) -> {
            if (slotId == 36 && (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.currentStack) || stack.isEmpty() || this.currentStack.isEmpty())) {
                this.currentStack = stack;
                this.updateItem((ItemStack)stack);
            }
        })));
        this.addChild(new EditOptionIcon(this.moduleCrafter.getX() - 36, this.moduleCrafter.getY() + 4, 32, 28, this::selectEditOption, this::getEditOption, BACKGROUND_TEXTURE, 339, 25, 512, 512, "miapi.ui.edit_option.hover.info", null));
        this.selectEditOption(null);
        this.selectSlot(null);
        this.previewStack(((CraftingScreenHandler)this.menu).inventory.getItem(0));
        PreviewManager.resetCursorStack();
        PreviewManager.resetPreview();
    }

    public int getBackgroundHeight() {
        return this.imageHeight;
    }

    public int getBackgroundWidth() {
        return this.imageWidth;
    }

    public void minimizeView() {
        EditOption op = this.getEditOption();
        this.removeWidget(this.moduleCrafter);
        SlotProperty.ModuleSlot slot1 = this.moduleCrafter.slot;
        this.editHolder.children().clear();
        this.moduleCrafter = new ModuleCrafter(this.moduleCrafter.getX(), this.moduleCrafter.getY(), this.moduleCrafter.getWidth(), this.moduleCrafter.getHeight() + 74, this.moduleCrafter);
        this.moduleCrafter.handler = (CraftingScreenHandler)this.menu;
        this.moduleCrafter.setPacketIdentifier(((CraftingScreenHandler)this.menu).packetID);
        this.addChild(this.moduleCrafter);
        this.updateItem(this.getItem());
        this.moduleCrafter.setSelectedSlot(slot1);
        this.updateEditOptions();
        this.removeWidget(this.slotDisplay);
        this.removeWidget(this.smithDisplay);
        this.selectSlot(slot1);
        this.updateEditOptions();
        this.selectEditOption(op);
        AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
        if (abstractContainerMenu instanceof CraftingScreenHandler) {
            CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
            craftingScreenHandler.clearSlots();
        }
    }

    public void maximizeView() {
        EditOption op = this.getEditOption();
        this.removeWidget(this.moduleCrafter);
        SlotProperty.ModuleSlot slot1 = this.moduleCrafter.slot;
        this.editHolder.children().clear();
        this.moduleCrafter = new ModuleCrafter(this.moduleCrafter.getX(), this.moduleCrafter.getY(), this.moduleCrafter.getWidth(), this.moduleCrafter.getHeight() - 74, this.moduleCrafter);
        this.moduleCrafter.handler = (CraftingScreenHandler)this.menu;
        this.moduleCrafter.setPacketIdentifier(((CraftingScreenHandler)this.menu).packetID);
        this.addChild(this.moduleCrafter);
        this.updateItem(this.getItem());
        this.moduleCrafter.setSelectedSlot(slot1);
        this.updateEditOptions();
        this.addChild(this.slotDisplay);
        this.addChild(this.smithDisplay);
        this.selectSlot(slot1);
        this.updateEditOptions();
        this.selectEditOption(op);
        AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
        if (abstractContainerMenu instanceof CraftingScreenHandler) {
            CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
            craftingScreenHandler.clearSlots();
        }
    }

    public ItemStack getItem() {
        return ((CraftingScreenHandler)this.menu).inventory.getItem(0);
    }

    public void setItem(ItemStack stack) {
        if (stack == null) {
            stack = ItemStack.EMPTY;
        }
        this.slotDisplay.setItem(stack);
        ((CraftingScreenHandler)this.menu).inventory.setItem(0, stack);
    }

    public void updateItem(ItemStack stack) {
        PreviewManager.resetCursorStack();
        this.updatePreviewItemStack(stack);
    }

    public void updatePreviewItemStack(ItemStack stack) {
        stack = stack.copy();
        this.slotDisplay.setItem(stack);
        ItemStack converted = ModularItemStackConverter.getModularVersion(stack).copy();
        this.baseSlot.inSlot = ItemModule.getModules(converted);
        this.baseSlot.allowed = AllowedSlots.getAllowedSlots(this.baseSlot.inSlot.module);
        SlotProperty.ModuleSlot current = this.baseSlot;
        slot = null;
        if (this.baseSlot.inSlot.module.equals(ItemModule.empty)) {
            current = null;
        }
        if (this.moduleCrafter != null) {
            this.moduleCrafter.setItem(converted);
            this.moduleCrafter.setBaseSlot(current);
            this.moduleCrafter.setSelectedSlot(null);
            this.moduleCrafter.setItem(converted);
            this.moduleCrafter.setBaseSlot(current);
            this.moduleCrafter.setSelectedSlot(null);
        }
        if (this.slotDisplay != null) {
            this.slotDisplay.setItem(converted);
            this.slotDisplay.select(current);
        }
        if (this.smithDisplay != null) {
            this.smithDisplay.setPreview(converted);
        }
        if (this.statDisplay != null) {
            this.statDisplay.setItemsOriginal(converted, converted);
        }
        this.updateEditOptions();
    }

    public void updateEditOptions() {
        int x = this.moduleCrafter.getX() - 36;
        int y = this.moduleCrafter.getY() + 4 + editSpace;
        for (InteractAbleWidget widget : this.editOptionIcons) {
            this.editHolder.removeChild(widget);
        }
        this.editHolder.children().clear();
        for (EditOption option : RegistryInventory.EDIT_OPTION_MIAPI_REGISTRY.getFlatMap().values()) {
            EditOption.EditContext context;
            if (!option.isVisible(context = this.get(option))) continue;
            InteractAbleWidget widget = option.getIconGui(x, y, 32, 28, this::selectEditOption, this::getEditOption);
            y += editSpace;
            this.editHolder.addChild(widget);
            this.editOptionIcons.add(widget);
        }
        if (!this.editHolder.children().contains(editOption)) {
            editOption = null;
        }
        PreviewManager.resetCursorStack();
        this.selectEditOption(editOption);
    }

    public EditOption.EditContext get(final EditOption editOption) {
        return new EditOption.EditContext(){

            @Override
            public void craft(FriendlyByteBuf craftBuffer) {
                if (editOption != null) {
                    editOption.execute(craftBuffer, this);
                }
            }

            @Override
            public void preview(FriendlyByteBuf preview) {
                if (editOption != null) {
                    CraftingScreen.this.previewStack(editOption.preview(preview, this));
                }
            }

            @Override
            public SlotProperty.ModuleSlot getSlot() {
                return slot;
            }

            @Override
            public ItemStack getItemstack() {
                return CraftingScreen.this.moduleCrafter.stack;
            }

            @Override
            @Nullable
            public ModuleInstance getInstance() {
                if (this.getSlot() == null) {
                    return null;
                }
                return this.getSlot().inSlot;
            }

            @Override
            @Nullable
            public Player getPlayer() {
                return Minecraft.getInstance().player;
            }

            @Override
            @Nullable
            public ModularWorkBenchEntity getWorkbench() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.blockEntity;
                }
                return null;
            }

            @Override
            public Container getLinkedInventory() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.inventory;
                }
                return null;
            }

            @Override
            public CraftingScreenHandler getScreenHandler() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler;
                }
                return null;
            }
        };
    }

    @Override
    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.overwriteMouseY = mouseY;
        this.overwriteMouseX = mouseX;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.hoverElement == null) {
            super.render(drawContext, this.overwriteMouseX, this.overwriteMouseY, delta);
        } else {
            this.hoverElement.render(drawContext, this.overwriteMouseX, this.overwriteMouseY, delta);
        }
        this.renderTooltip(drawContext, this.overwriteMouseX, this.overwriteMouseY);
        drawContext.pose().pushPose();
        drawContext.pose().translate(0.0f, 0.0f, 400.0f);
        if (this.hoverElement == null) {
            drawContext.drawManaged(() -> this.renderHover(drawContext, this.overwriteMouseX, this.overwriteMouseY, delta));
        } else {
            drawContext.drawManaged(() -> this.hoverElement.renderHover(drawContext, this.overwriteMouseX, this.overwriteMouseY, delta));
        }
        drawContext.pose().popPose();
        PreviewManager.tick();
    }

    public void renderBackground(GuiGraphics drawContext, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(drawContext, mouseX, mouseY, partialTick);
        int i = (this.width - this.imageWidth - 6) / 2;
        int j = (this.height - this.imageHeight) / 2;
        drawContext.blit(BACKGROUND_TEXTURE, i + 43 - 15, j + 14 - 14, 338, 199, 0.0f, 0.0f, 338, 199, 512, 512);
        if (this.minimizer.isEnabled()) {
            drawContext.blit(BACKGROUND_TEXTURE, i + 43 - 15, j + 111 - 14, 160, 95, 0.0f, 199.0f, 160, 95, 512, 512);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hoverElement != null) {
            return this.hoverElement.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.hoverElement != null) {
            this.hoverElement.mouseMoved(mouseX, mouseY);
        } else {
            super.mouseMoved(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.hoverElement != null) {
            return this.hoverElement.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.hoverElement != null && this.hoverElement.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount, double other) {
        if (this.hoverElement != null) {
            return this.hoverElement.mouseScrolled(mouseX, mouseY, amount, other);
        }
        return super.mouseScrolled(mouseX, mouseY, amount, other);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
    }

    static {
        editSpace = 30;
        craftingScreenWeakReference = new WeakReference<Object>(null);
    }
}

