/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.MutableSlot;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.slot.AllowedSlots;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.RegistryInventory;

public class CraftingScreenHandler
extends AbstractContainerMenu {
    private final ContainerLevelAccess context;
    private static final String PACKET_ID = ":crafting_packet_";
    public Container inventory;
    public Inventory playerInventory;
    @Nullable
    public ModularWorkBenchEntity blockEntity;
    public final ContainerData delegate;
    public final String packetID;
    public final String editPacketID;
    public final String packetIDSlotAdd;
    public final String packetIDSlotRemove;
    public CraftingScreenHandler craftingScreenHandler;
    private final List<Slot> mutableSlots = new ArrayList<Slot>();
    static final ResourceLocation[] EMPTY_ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] EQUIPMENT_SLOT_ORDER = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public CraftingScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, null, ContainerLevelAccess.NULL, (ContainerData)new SimpleContainerData(7));
        this.craftingScreenHandler = this;
    }

    public CraftingScreenHandler(int syncId, Inventory playerInventory, ModularWorkBenchEntity benchEntity, ContainerData delegate) {
        this(syncId, playerInventory, benchEntity, ContainerLevelAccess.NULL, delegate);
        this.craftingScreenHandler = this;
    }

    public CraftingScreenHandler(int syncId, final Inventory playerInventory, @Nullable ModularWorkBenchEntity benchEntity, ContainerLevelAccess context, ContainerData delegate) {
        super(RegistryInventory.craftingScreenHandler, syncId);
        int j;
        this.craftingScreenHandler = this;
        this.packetID = "miapi:crafting_packet_" + playerInventory.player.getStringUUID() + "_" + syncId;
        this.editPacketID = "miapi:crafting_packet__edit_" + playerInventory.player.getStringUUID() + "_" + syncId;
        this.packetIDSlotAdd = "miapi:crafting_packet__" + playerInventory.player.getStringUUID() + "_" + syncId + "_slot_add";
        this.packetIDSlotRemove = "miapi:crafting_packet__" + playerInventory.player.getStringUUID() + "_" + syncId + "_slot_remove";
        this.delegate = delegate;
        this.playerInventory = playerInventory;
        this.blockEntity = benchEntity;
        if (playerInventory.player instanceof ServerPlayer) {
            Networking.registerC2SPacket(this.packetID, (buffer, player) -> {
                CraftAction action = new CraftAction((FriendlyByteBuf)buffer, this.blockEntity, this);
                Miapi.server.execute(() -> {
                    action.setItem(this.inventory.getItem(0));
                    action.linkInventory(this.inventory, 1);
                    if (action.canPerform()) {
                        ItemStack stack = action.perform();
                        this.inventory.setItem(0, stack);
                        if (this.blockEntity != null) {
                            this.blockEntity.setItem(stack);
                            this.blockEntity.saveAndSync();
                        }
                        this.slotsChanged(this.inventory);
                    }
                });
            });
            Networking.registerC2SPacket(this.packetIDSlotAdd, (buffer, player) -> {
                int invId = buffer.readInt();
                int slotId = buffer.readInt();
                Miapi.server.execute(() -> {
                    Slot slot = new Slot(this.inventory, invId, 0, 0);
                    slot.index = slotId;
                    this.mutableSlots.add(slot);
                    this.addSlot(slot);
                    slot.index = slotId;
                });
            });
            Networking.registerC2SPacket(this.packetIDSlotRemove, (buffer, player) -> {
                int slotId = buffer.readInt();
                Miapi.server.execute(() -> {
                    Slot slot = this.getSlot(slotId);
                    this.mutableSlots.remove(slot);
                    this.quickMoveStack(playerInventory.player, slotId);
                });
            });
            Networking.registerC2SPacket(this.editPacketID, (buffer, player) -> {
                String editOptionKey = buffer.readUtf();
                EditOption option = RegistryInventory.EDIT_OPTION_MIAPI_REGISTRY.get(editOptionKey);
                String[] array = buffer.readUtf().split("\n");
                final ItemStack stack = ModularItemStackConverter.getModularVersion(this.inventory.getItem(0));
                ModuleInstance root = ItemModule.getModules(stack);
                ArrayList<String> position = new ArrayList<String>();
                Collections.addAll(position, array);
                final ModuleInstance current = root.getPosition(position).copy();
                SlotProperty.ModuleSlot slot = SlotProperty.getSlotIn(current);
                if (slot == null && current != null && current.module != null) {
                    slot = new SlotProperty.ModuleSlot(AllowedSlots.getAllowedSlots(current.module));
                }
                assert (option != null);
                final SlotProperty.ModuleSlot finalSlot = slot;
                EditOption.EditContext editContext = new EditOption.EditContext(){
                    final /* synthetic */ ServerPlayer val$player;
                    {
                        this.val$player = serverPlayer;
                    }

                    @Override
                    public void craft(FriendlyByteBuf craftBuffer) {
                    }

                    @Override
                    public void preview(FriendlyByteBuf preview) {
                    }

                    @Override
                    public SlotProperty.ModuleSlot getSlot() {
                        return finalSlot;
                    }

                    @Override
                    public ItemStack getItemstack() {
                        return stack;
                    }

                    @Override
                    @Nullable
                    public ModuleInstance getInstance() {
                        return current;
                    }

                    @Override
                    @Nullable
                    public Player getPlayer() {
                        return this.val$player;
                    }

                    @Override
                    @Nullable
                    public ModularWorkBenchEntity getWorkbench() {
                        return CraftingScreenHandler.this.blockEntity;
                    }

                    @Override
                    public Container getLinkedInventory() {
                        return CraftingScreenHandler.this.inventory;
                    }

                    @Override
                    public CraftingScreenHandler getScreenHandler() {
                        return CraftingScreenHandler.this.craftingScreenHandler;
                    }
                };
                if (option.isVisible(editContext)) {
                    ItemStack editedStack = option.execute((FriendlyByteBuf)buffer, editContext);
                    Miapi.server.execute(() -> {
                        this.inventory.setItem(0, editedStack);
                        if (this.blockEntity != null) {
                            this.blockEntity.setItem(editedStack);
                            this.blockEntity.saveAndSync();
                        }
                        this.inventory.setChanged();
                        this.slotsChanged(this.inventory);
                    });
                } else {
                    Miapi.LOGGER.warn("ERROR - Couldn`t verify craft action of type" + editOptionKey + " from client " + player.getStringUUID() + " " + player.getDisplayName().getString() + " This might be a bug or somebody is trying to exploit");
                    Miapi.LOGGER.warn(String.valueOf(current));
                    Miapi.LOGGER.warn(((Object)position).toString());
                }
            });
        }
        this.context = context;
        this.inventory = new SimpleContainer(54){

            public void setChanged() {
                super.setChanged();
                CraftingScreenHandler.this.slotsChanged((Container)this);
            }
        };
        if (this.blockEntity != null) {
            this.setItem(this.blockEntity.getItem());
        }
        int yOffset = 131;
        int xOffset = 210;
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new PlayerInventorySlot(playerInventory, k + j * 9 + 9, k * 18 + xOffset - 15, j * 18 + yOffset - 14));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new PlayerInventorySlot(playerInventory, j, j * 18 + xOffset - 15, 58 + yOffset - 14));
        }
        this.addSlot(new ModifyingSlot(this.inventory, 0, 34, 176, this.blockEntity));
        for (int i = 0; i < 4; ++i) {
            final EquipmentSlot equipmentSlot = EQUIPMENT_SLOT_ORDER[i];
            int offset = i < 2 ? 0 : 1;
            this.addSlot(new Slot(this, (Container)playerInventory, 39 - i, 84 + i * 18 - offset - 15, 175){

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(ItemStack itemStack) {
                    return equipmentSlot == playerInventory.player.getEquipmentSlotForItem(itemStack);
                }

                public boolean mayPickup(Player playerEntity) {
                    ItemStack itemStack = this.getItem();
                    return (itemStack.isEmpty() || playerEntity.isCreative() || !EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) && super.mayPickup(playerEntity);
                }

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_TEXTURES[equipmentSlot.getIndex()]);
                }
            });
        }
        this.addSlot(new Slot(this, (Container)playerInventory, 40, 140, 175){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        this.addDataSlots(delegate);
    }

    public boolean notClient() {
        return !this.playerInventory.player.level().isClientSide;
    }

    public void broadcastChanges() {
        ItemStack inv;
        ItemStack block;
        super.broadcastChanges();
        if (this.notClient() && !ItemStack.isSameItem((ItemStack)(block = this.blockEntity.getItem()), (ItemStack)(inv = this.inventory.getItem(0)))) {
            this.blockEntity.setItem(this.inventory.getItem(0));
            this.blockEntity.saveAndSync();
            this.updateBE();
        }
        if (this.blockEntity == null && this.delegate.get(0) == 1) {
            short xsh = (short)this.delegate.get(1);
            short xsl = (short)this.delegate.get(2);
            int x = xsh << 16 | xsl & 0xFFFF;
            short ysh = (short)this.delegate.get(3);
            short ysl = (short)this.delegate.get(4);
            int y = ysh << 16 | ysl & 0xFFFF;
            short zsh = (short)this.delegate.get(5);
            short zsl = (short)this.delegate.get(6);
            int z = zsh << 16 | zsl & 0xFFFF;
            BlockEntity be = this.playerInventory.player.level().getBlockEntity(new BlockPos(x, y, z));
            if (be instanceof ModularWorkBenchEntity) {
                ModularWorkBenchEntity casted;
                this.blockEntity = casted = (ModularWorkBenchEntity)be;
            }
        }
    }

    public void removeSlotByClient(Slot slot) {
        if (!this.slots.contains((Object)slot)) {
            return;
        }
        this.quickMoveStack(this.playerInventory.player, slot.index);
        slot.setChanged();
        if (slot instanceof MutableSlot) {
            MutableSlot mutableSlot = (MutableSlot)slot;
            mutableSlot.setEnabled(false);
        }
        this.playerInventory.setChanged();
        this.inventory.setChanged();
        FriendlyByteBuf buf = Networking.createBuffer();
        buf.writeInt(slot.index);
        this.mutableSlots.remove(slot);
        Networking.sendC2S(this.packetIDSlotRemove, buf);
    }

    public void clearSlots() {
        this.slots.stream().filter(MutableSlot.class::isInstance).forEach(this::removeSlotByClient);
    }

    public void addSlotByClient(Slot slot) {
        if (this.slots.contains((Object)slot)) {
            return;
        }
        this.addSlot(slot);
        FriendlyByteBuf buf = Networking.createBuffer();
        buf.writeInt(slot.getContainerSlot());
        buf.writeInt(slot.index);
        this.mutableSlots.add(slot);
        Networking.sendC2S(this.packetIDSlotAdd, buf);
        slot.setChanged();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        this.context.execute((world, pos) -> this.clearContainer(player, this.inventory));
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack;
            if (i == 0 || (stack = this.inventory.getItem(i)).isEmpty()) continue;
            if (!player.getInventory().add(stack)) {
                player.drop(stack, false);
            }
            this.inventory.setItem(i, ItemStack.EMPTY);
        }
        Networking.unRegisterC2SPacket(this.packetID);
        Networking.unRegisterC2SPacket(this.packetIDSlotAdd);
        Networking.unRegisterC2SPacket(this.packetIDSlotRemove);
        Networking.unRegisterC2SPacket(this.editPacketID);
        if (this.notClient() && this.blockEntity != null) {
            this.blockEntity.saveAndSync();
        }
    }

    public void setItem(ItemStack stack) {
        this.inventory.setItem(0, stack);
        this.inventory.setChanged();
        if (this.blockEntity != null) {
            this.blockEntity.setItem(stack);
            if (this.notClient()) {
                this.blockEntity.saveAndSync();
            }
        }
    }

    private void updateBE() {
        if (this.notClient()) {
            this.blockEntity.setItem(this.inventory.getItem(0));
            this.blockEntity.saveAndSync();
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        this.inventory.setChanged();
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            if (index >= 36 || index > 41) {
                slot.onTake(player, itemStack2);
                if (!this.moveItemStackTo(itemStack2, 37, 41, true)) {
                    this.moveItemStackTo(itemStack2, 0, 36, true);
                }
                if (index == 36 && this.blockEntity != null) {
                    this.blockEntity.setItem(itemStack2);
                    if (this.notClient()) {
                        this.blockEntity.saveAndSync();
                    }
                }
                slot.setChanged();
                return ItemStack.EMPTY;
            }
            for (Slot slot1 : this.mutableSlots) {
                if (slot1.index < 36 || this.moveItemStackTo(itemStack2, slot1.index, slot1.index + 1, true)) continue;
                return ItemStack.EMPTY;
            }
            if ((((Slot)this.slots.get(36)).getItem().isEmpty() || ((Slot)this.slots.get(36)).getItem().getItem().equals(itemStack2.getItem())) && !this.moveItemStackTo(itemStack2, 36, 37, true)) {
                return ItemStack.EMPTY;
            }
            slot.setChanged();
        }
        return ItemStack.EMPTY;
    }

    protected void clearContainer(Player player, Container inventory) {
        ServerPlayer serverPlayerEntity;
        if (!player.isAlive() || player instanceof ServerPlayer && (serverPlayerEntity = (ServerPlayer)player).hasDisconnected()) {
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                if (i == 0) continue;
                player.drop(inventory.removeItemNoUpdate(i), false);
            }
            return;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (i == 0) continue;
            Inventory currentPlayerInv = player.getInventory();
            if (!(currentPlayerInv.player instanceof ServerPlayer)) continue;
            currentPlayerInv.placeItemBackInInventory(inventory.removeItemNoUpdate(i));
        }
    }

    public static class PlayerInventorySlot
    extends Slot {
        public PlayerInventorySlot(Inventory inventory, int index, int x, int y) {
            super((Container)inventory, index, x, y);
        }
    }

    public static class ModifyingSlot
    extends Slot {
        protected final ModularWorkBenchEntity blockEntity;

        public ModifyingSlot(Container inventory, int index, int x, int y, ModularWorkBenchEntity blockEntity) {
            super(inventory, index, x, y);
            this.blockEntity = blockEntity;
        }

        public boolean notClient() {
            return this.blockEntity != null && this.blockEntity.hasLevel() && !this.blockEntity.getLevel().isClientSide;
        }

        public boolean mayPlace(ItemStack stack) {
            return true;
        }

        public int getMaxStackSize() {
            return 64;
        }

        public void setByPlayer(ItemStack stack) {
            super.setByPlayer(stack);
            if (this.notClient()) {
                this.blockEntity.setItem(stack);
                this.blockEntity.saveAndSync();
            }
            this.setChanged();
        }
    }
}

