/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting;

import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.edit_options.ReplaceOption;

public class PreviewManager {
    @Nullable
    public static Material currentPreviewMaterial = null;
    public static ItemStack currentPreviewMaterialStack = ItemStack.EMPTY;
    private static ItemStack cursorStack = ItemStack.EMPTY;
    private static Material lastFramePreviewMaterial = null;

    public static void setCursorItemstack(ItemStack itemstack) {
        Material material;
        if (Environment.isClient() && Minecraft.getInstance().isSameThread() && cursorStack != itemstack && (material = MaterialProperty.getMaterialFromIngredient(itemstack)) != currentPreviewMaterial) {
            cursorStack = itemstack;
            PreviewManager.updateMaterial(material, cursorStack);
        }
    }

    public static void resetCursorStack() {
        PreviewManager.setCursorItemstack(ItemStack.EMPTY);
    }

    public static void resetPreview() {
        ReplaceOption.resetPreview();
    }

    public static boolean hasValidPreview() {
        return currentPreviewMaterial != null;
    }

    public static void updateMaterial(Material material, ItemStack itemStack) {
        currentPreviewMaterial = material;
        currentPreviewMaterialStack = itemStack;
    }

    public static void tick() {
        if (lastFramePreviewMaterial != currentPreviewMaterial) {
            lastFramePreviewMaterial = currentPreviewMaterial;
            if (CraftingScreen.getInstance() != null) {
                CraftingScreen craftingScreen = CraftingScreen.getInstance();
                ItemStack currentStack = craftingScreen.getItem();
                if (currentStack.isEmpty() && craftingScreen.getEditOption() == null) {
                    if (ModularItem.isModularItem(currentStack) || currentPreviewMaterial == null) {
                        craftingScreen.updatePreviewItemStack(ItemStack.EMPTY);
                    } else {
                        craftingScreen.updatePreviewItemStack(cursorStack);
                    }
                } else {
                    ReplaceOption.tryPreview();
                }
            }
        }
    }
}

