/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.StatBar;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;

public class MaterialDetailView
extends InteractAbleWidget {
    private final ItemStack itemStack;
    private final Consumer<Object> back;
    private final ScrollingTextWidget header;
    private final Material material;
    private final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"textures/gui/crafter/material_detail_background.png");
    private final float scale = 1.5f;
    public static List<Builder> infoBarBuilders = new ArrayList<Builder>();

    public MaterialDetailView(int x, int y, int width, int height, ItemStack stack, Consumer<Object> back) {
        super(x, y, width, height, (Component)Component.empty());
        this.itemStack = stack;
        this.back = back;
        this.material = MaterialProperty.getMaterialFromIngredient(stack);
        TransformableWidget headerScaler = new TransformableWidget(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 1.5f);
        this.header = new ScrollingTextWidget((int)((float)(x + 5) * 0.6666667f), (int)((float)(y + 5) * 0.6666667f), width, this.material.getTranslation(), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        headerScaler.addChild(this.header);
        this.addChild(headerScaler);
        int spacer = 13;
        ArrayList<InteractAbleWidget> widgets = new ArrayList<InteractAbleWidget>();
        widgets.add(new ColorWidget(this.getX(), this.getY(), this.getWidth(), spacer, this.material.getColor(new ModuleInstance(ItemModule.empty))));
        for (Builder builder : infoBarBuilders) {
            widgets.add(builder.build(x, y, width, spacer, this.material));
        }
        ScrollList list = new ScrollList(x + 10, y + 27, width - 10, this.getHeight() - 27, widgets);
        this.addChild(list);
    }

    public static void registerBuilder(Builder builder) {
        infoBarBuilders.add(builder);
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.material != null && this.material.hasIcon()) {
            this.material.renderIcon(drawContext, (int)((float)(this.getX() + 5) + (float)this.header.getRequiredWidth() * 1.5f), this.getY() + 5);
        }
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }

    static {
        MaterialDetailView.registerBuilder(new Builder("hardness"));
        MaterialDetailView.registerBuilder(new Builder("flexibility"));
        MaterialDetailView.registerBuilder(new Builder("density"));
        MaterialDetailView.registerBuilder(new Builder("durability").setMax(2000).setFormat("##"));
        MaterialDetailView.registerBuilder(new Builder("enchantability"));
        MaterialDetailView.registerBuilder(new Builder("mining_speed"));
        MaterialDetailView.registerBuilder(new Builder("mining_level").setMax(4).setFormat("##"));
    }

    private static class ColorWidget
    extends InteractAbleWidget {
        ScrollingTextWidget textWidget;
        public static int textWidth = 70;
        int color;

        public ColorWidget(int x, int y, int width, int height, int color) {
            super(x, y, width, height, (Component)Component.empty());
            this.textWidget = new ScrollingTextWidget(x, y, textWidth, (Component)Component.translatable((String)"miapi.material_stat.color"), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.addChild(this.textWidget);
            this.color = color;
        }

        @Override
        public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            this.textWidget.setX(this.getX());
            this.textWidget.setY(this.getY());
            super.renderWidget(drawContext, mouseX, mouseY, delta);
            this.color |= 0xFF000000;
            drawContext.fill(this.getX() + textWidth, this.getY(), this.getX() + textWidth + 10, this.getY() + 10, this.color);
        }
    }

    public static class Builder {
        public String key;
        public int min = 0;
        public int max = 10;
        public String format = "##.##";

        public Builder(String key) {
            this.key = key;
        }

        public Builder setMax(int max) {
            this.max = max;
            return this;
        }

        public Builder setMin(int min) {
            this.min = min;
            return this;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public InteractAbleWidget build(int x, int y, int width, int spacer, Material material) {
            return new InfoBar(x + 10, y, width - 10, spacer, (Component)Component.translatable((String)("miapi.material_stat." + this.key)), (float)material.getDouble(this.key), this.min, this.max, this.format);
        }
    }

    public static class InfoBar
    extends InteractAbleWidget {
        public StatBar statBar;
        public ScrollingTextWidget textWidget;
        public static int textWidth = 69;
        public static int barWitdh = 34;
        public static int spacer = 1;
        public ScrollingTextWidget valueHolder;

        public InfoBar(int x, int y, int width, int height, Component text, float value, float min, float max) {
            this(x, y, width, height, text, value, min, max, "##.##");
        }

        public InfoBar(int x, int y, int width, int height, Component text, float value, float min, float max, String format) {
            super(x, y, width, height, (Component)Component.empty());
            max = Math.max(value, max);
            min = Math.min(value, min);
            this.textWidget = new ScrollingTextWidget(x, y, textWidth, text, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.statBar = new StatBar(x + textWidth + spacer, y + 3, barWitdh, 2, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
            DecimalFormat modifierFormat = (DecimalFormat)Util.make((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            float primaryPercent = (value - min) / (max - min);
            this.statBar.setPrimary(primaryPercent, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary(primaryPercent, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.valueHolder = new ScrollingTextWidget(x + textWidth + barWitdh + spacer * 2, y, width - textWidth + barWitdh, (Component)Component.literal((String)modifierFormat.format(value)), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.addChild(this.textWidget);
            this.addChild(this.statBar);
            this.addChild(this.valueHolder);
        }

        @Override
        public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            this.textWidget.setX(this.getX());
            this.textWidget.setY(this.getY());
            this.statBar.setX(this.getX() + textWidth);
            this.statBar.setY(this.getY() + 3);
            this.valueHolder.setX(this.getX() + textWidth + barWitdh + spacer * 2);
            this.valueHolder.setY(this.getY());
            super.renderWidget(drawContext, mouseX, mouseY, delta);
        }
    }
}

