/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.create_module;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftViewRework;
import smartin.miapi.modules.edit_options.CreateItemOption.CreateItemOption;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.ReplaceOption;

@OnlyIn(value=Dist.CLIENT)
public class CreateListView
extends InteractAbleWidget {
    final EditOption.EditContext editContext;
    public ScrollList scrollList;

    public CreateListView(int x, int y, int width, int height, EditOption.EditContext editContext) {
        super(x, y, width, height, (Component)Component.empty());
        ArrayList<InteractAbleWidget> widgets = new ArrayList<InteractAbleWidget>();
        this.editContext = editContext;
        CreateItemOption.createAbleItems.stream().filter(item -> item.isAllowed(editContext.getPlayer(), editContext.getWorkbench())).sorted(Comparator.comparingDouble(CreateItemOption.CreateItem::getPriority)).forEach(item -> widgets.add(new CreateItemEntry(0, 0, 100, 14, (CreateItemOption.CreateItem)item)));
        this.scrollList = new ScrollList(this.getX(), this.getY(), this.getWidth(), this.getHeight(), widgets);
        this.addChild(this.scrollList);
    }

    public void create(CreateItemOption.CreateItem createItem) {
        EditOption.EditContext editContext1;
        CreateItemOption.selected = createItem;
        ReplaceOption.unsafeEditContext = editContext1 = CreateItemOption.transform(this.editContext, createItem);
        CraftViewRework craftView = new CraftViewRework(this.getX(), this.getY(), this.width, this.height, 1, new CraftOption(createItem.getBaseModule(), new HashMap<ResourceLocation, JsonElement>(), 0.0), editContext1, backSlot -> {
            this.children().clear();
            this.addChild(this.scrollList);
        });
        this.children().clear();
        this.addChild(craftView);
    }

    protected class CreateItemEntry
    extends InteractAbleWidget {
        final CreateItemOption.CreateItem createItem;
        final ScrollingTextWidget textWidget;

        public CreateItemEntry(int x, int y, int width, int height, CreateItemOption.CreateItem item) {
            super(x, y, width, height, (Component)Component.empty());
            this.createItem = item;
            this.textWidget = new ScrollingTextWidget(x + 5, x + 5, this.getWidth(), item.getName());
            this.addChild(this.textWidget);
        }

        @Override
        public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int hoverOffset = 0;
            if (this.isMouseOver(mouseX, mouseY)) {
                hoverOffset = 14;
            }
            CreateItemEntry.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, this.getX(), this.getY(), 404, 54 + hoverOffset, 108, 14, this.getWidth(), this.getHeight(), 512, 512, 3);
            this.textWidget.setX(this.getX() + 2);
            this.textWidget.setY(this.getY() + 3);
            this.textWidget.setWidth(this.getWidth() - 10);
            this.textWidget.render(drawContext, mouseX, mouseY, delta);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isMouseOver(mouseX, mouseY)) {
                CreateListView.this.create(this.createItem);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }
}

