/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.glint;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.redpxnda.nucleus.math.MathUtil;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import smartin.miapi.client.gui.crafting.crafter.glint.HueSlider;

@OnlyIn(value=Dist.CLIENT)
public class AlphaSlider
extends AbstractWidget {
    public static final ResourceLocation SCROLLBAR_TEXTURE = HueSlider.SCROLLBAR_TEXTURE;
    public float value = 1.0f;
    public boolean dragging = false;
    public final Consumer<Float> updateListener;

    public AlphaSlider(int x, int y, int width, int height, Consumer<Float> updateListener) {
        super(x, y, width, height, (Component)Component.empty());
        this.updateListener = updateListener;
    }

    public void onClick(double mouseX, double mouseY) {
        this.dragging = true;
        this.value = MathUtil.clamp((float)((float)(mouseX - (double)this.getX()) / (float)this.width), (float)0.0f, (float)1.0f);
        this.update();
    }

    public void onRelease(double mouseX, double mouseY) {
        this.dragging = false;
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.value = MathUtil.clamp((float)((float)(mouseX - (double)this.getX()) / (float)this.width), (float)0.0f, (float)1.0f);
        this.update();
    }

    protected boolean isDragging(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY) || this.dragging;
    }

    protected boolean isReleasing(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY) || this.dragging;
    }

    protected void update() {
        this.updateListener.accept(Float.valueOf(this.value));
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderScrollbar(context, mouseX, mouseY, delta);
        VertexConsumer vc = context.bufferSource().getBuffer(RenderType.gui());
        Matrix4f matrix4f = context.pose().last().pose();
        vc.addVertex(matrix4f, (float)this.getX(), (float)this.getY(), 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vc.addVertex(matrix4f, (float)this.getX(), (float)(this.getY() + this.height - 1), 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vc.addVertex(matrix4f, (float)(this.getX() + this.width), (float)(this.getY() + this.height - 1), 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vc.addVertex(matrix4f, (float)(this.getX() + this.width), (float)this.getY(), 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderScrollbar(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.pose().pushPose();
        context.pose().translate(0.0f, 0.0f, 1.0f);
        context.blit(SCROLLBAR_TEXTURE, this.getX() - 1 + (int)(this.value * (float)(this.width - this.getScrollbarWidth())), this.getY() - 1, 6, 8, this.isHovered() ? 6.0f : 0.0f, 0.0f, 6, 8, 12, 8);
        context.pose().popPose();
    }

    protected int getScrollbarWidth() {
        return 4;
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

