/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.glint;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.redpxnda.nucleus.util.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ColorGrid
extends AbstractWidget {
    public float saturation = 1.0f;
    public float lightness = 1.0f;
    public Color hueColor = Color.RED.copy();
    public Color color = Color.RED.copy();
    public boolean dragging = false;
    public final Consumer<Color> updateListener;

    public ColorGrid(int x, int y, int width, int height, Consumer<Color> updateListener) {
        super(x, y, width, height, (Component)Component.empty());
        this.updateListener = updateListener;
    }

    public void onClick(double mouseX, double mouseY) {
        this.dragging = true;
        this.saturation = Mth.clamp((float)((float)(mouseX - (double)this.getX()) / (float)this.width), (float)0.0f, (float)1.0f);
        this.lightness = Mth.clamp((float)(1.0f - (float)(mouseY - (double)this.getY()) / (float)this.height), (float)0.0f, (float)1.0f);
        this.update();
    }

    public void onRelease(double mouseX, double mouseY) {
        this.dragging = false;
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.saturation = Mth.clamp((float)((float)(mouseX - (double)this.getX()) / (float)this.width), (float)0.0f, (float)1.0f);
        this.lightness = Mth.clamp((float)(1.0f - (float)(mouseY - (double)this.getY()) / (float)this.height), (float)0.0f, (float)1.0f);
        this.update();
    }

    protected boolean isDragging(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY) || this.dragging;
    }

    protected boolean isReleasing(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY) || this.dragging;
    }

    protected Color calculateColor() {
        this.color = Color.WHITE.copy();
        this.color.lerp(this.saturation, this.hueColor);
        this.color.lerp(1.0f - this.lightness, Color.BLACK);
        return this.color;
    }

    protected void update() {
        this.calculateColor();
        this.updateListener.accept(this.color);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.active && this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.width) && mouseY < (double)(this.getY() + this.height);
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        VertexConsumer vc = context.bufferSource().getBuffer(RenderType.gui());
        Matrix4f matrix4f = context.pose().last().pose();
        float iLightness = 1.0f - this.lightness;
        vc.addVertex(matrix4f, (float)this.getX() + this.saturation * (float)this.width - 3.0f, (float)this.getY() + iLightness * (float)this.height - 3.0f, 1.0f).setColor(Color.WHITE.r(), Color.WHITE.g(), Color.WHITE.b(), Color.WHITE.a());
        vc.addVertex(matrix4f, (float)this.getX() + this.saturation * (float)this.width - 3.0f, (float)this.getY() + iLightness * (float)this.height + 3.0f, 1.0f).setColor(Color.WHITE.r(), Color.WHITE.g(), Color.WHITE.b(), Color.WHITE.a());
        vc.addVertex(matrix4f, (float)this.getX() + this.saturation * (float)this.width + 3.0f, (float)this.getY() + iLightness * (float)this.height + 3.0f, 1.0f).setColor(Color.WHITE.r(), Color.WHITE.g(), Color.WHITE.b(), Color.WHITE.a());
        vc.addVertex(matrix4f, (float)this.getX() + this.saturation * (float)this.width + 3.0f, (float)this.getY() + iLightness * (float)this.height - 3.0f, 1.0f).setColor(Color.WHITE.r(), Color.WHITE.g(), Color.WHITE.b(), Color.WHITE.a());
        vc.addVertex(matrix4f, (float)this.getX() + this.saturation * (float)this.width - 2.0f, (float)this.getY() + iLightness * (float)this.height - 2.0f, 1.0f).setColor(this.color.r(), this.color.g(), this.color.b(), this.color.a());
        vc.addVertex(matrix4f, (float)this.getX() + this.saturation * (float)this.width - 2.0f, (float)this.getY() + iLightness * (float)this.height + 2.0f, 1.0f).setColor(this.color.r(), this.color.g(), this.color.b(), this.color.a());
        vc.addVertex(matrix4f, (float)this.getX() + this.saturation * (float)this.width + 2.0f, (float)this.getY() + iLightness * (float)this.height + 2.0f, 1.0f).setColor(this.color.r(), this.color.g(), this.color.b(), this.color.a());
        vc.addVertex(matrix4f, (float)this.getX() + this.saturation * (float)this.width + 2.0f, (float)this.getY() + iLightness * (float)this.height - 2.0f, 1.0f).setColor(this.color.r(), this.color.g(), this.color.b(), this.color.a());
        for (int i = 0; i < this.height; ++i) {
            float delt = (float)i / (float)this.height;
            Color left = Color.WHITE.copy();
            left.lerp(delt, Color.BLACK);
            Color right = this.hueColor.copy();
            right.lerp(delt, Color.BLACK);
            vc.addVertex(matrix4f, (float)this.getX(), (float)(this.getY() + i), 0.0f).setColor(left.r(), left.g(), left.b(), left.a());
            vc.addVertex(matrix4f, (float)this.getX(), (float)(this.getY() + i + 1), 0.0f).setColor(left.r(), left.g(), left.b(), left.a());
            vc.addVertex(matrix4f, (float)(this.getX() + this.width), (float)(this.getY() + i + 1), 0.0f).setColor(right.r(), right.g(), right.b(), right.a());
            vc.addVertex(matrix4f, (float)(this.getX() + this.width), (float)(this.getY() + i), 0.0f).setColor(right.r(), right.g(), right.b(), right.a());
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

