/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.glint;

import com.redpxnda.nucleus.config.screen.widget.IntegerFieldWidget;
import com.redpxnda.nucleus.math.MathUtil;
import com.redpxnda.nucleus.util.Color;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.crafter.glint.AlphaSlider;
import smartin.miapi.client.gui.crafting.crafter.glint.ColorGrid;
import smartin.miapi.client.gui.crafting.crafter.glint.HueSlider;

@OnlyIn(value=Dist.CLIENT)
public class ColorPickerWidget
extends InteractAbleWidget {
    public static final ResourceLocation TEXTURE = CraftingScreen.BACKGROUND_TEXTURE;
    protected final Font textRenderer;
    protected final Consumer<Color> onUpdate;
    protected final ColorGrid colorGrid;
    protected final HueSlider hueSlider;
    protected final AlphaSlider alphaSlider;
    protected Color hueColor = Color.RED.copy();
    protected Color color = Color.RED;
    protected final IntegerFieldWidget redField;
    protected final IntegerFieldWidget greenField;
    protected final IntegerFieldWidget blueField;
    protected final IntegerFieldWidget hueField;
    protected final IntegerFieldWidget satField;
    protected final IntegerFieldWidget lightField;
    protected final IntegerFieldWidget alphaField;

    public ColorPickerWidget(Font textR, int y, int x, Consumer<Color> updateListener) {
        super(x, y, 128, 92, (Component)Component.empty());
        this.textRenderer = textR;
        this.onUpdate = updateListener;
        this.colorGrid = new ColorGrid(x + 8, y + 8, 76, 76, c -> this.updateColor());
        this.hueSlider = new HueSlider(x + 20, y + 94, 64, 8, f -> this.updateHue());
        this.alphaSlider = new AlphaSlider(x + 20, y + 110, 64, 8, f -> this.updateAlpha());
        this.redField = new IntegerFieldWidget(textR, x + 101, y + 9, 30, 9, 0, 255, (Component)Component.empty(), i -> this.setColorAndUpdate(this.color.withRed(i.intValue())), "\u0280");
        this.greenField = new IntegerFieldWidget(textR, x + 101, y + 22, 30, 9, 0, 255, (Component)Component.empty(), i -> this.setColorAndUpdate(this.color.withGreen(i.intValue())), "\u0262");
        this.blueField = new IntegerFieldWidget(textR, x + 101, y + 35, 30, 9, 0, 255, (Component)Component.empty(), i -> this.setColorAndUpdate(this.color.withBlue(i.intValue())), "\u0299");
        this.hueField = new IntegerFieldWidget(textR, x + 101, y + 50, 30, 9, 0, 360, (Component)Component.empty(), i -> this.setColorAndUpdate((float)i.intValue() / 360.0f, this.colorGrid.saturation, this.colorGrid.lightness), "\u029c");
        this.satField = new IntegerFieldWidget(textR, x + 101, y + 63, 30, 9, 0, 100, (Component)Component.empty(), i -> this.setColorAndUpdate(this.hueSlider.value, (float)i.intValue() / 100.0f, this.colorGrid.lightness), "\u0455");
        this.lightField = new IntegerFieldWidget(textR, x + 101, y + 76, 30, 9, 0, 100, (Component)Component.empty(), i -> this.setColorAndUpdate(this.hueSlider.value, this.colorGrid.saturation, (float)i.intValue() / 100.0f), "\u029f");
        this.alphaField = new IntegerFieldWidget(textR, x + 101, y + 108, 30, 9, 0, 100, (Component)Component.empty(), i -> this.setColorAndUpdate(this.color.withAlpha((float)i.intValue() / 100.0f)), "\u1d00");
    }

    public ColorPickerWidget(Font textRenderer, int x, int y, Consumer<Color> onUpdate, ColorGrid ColorGrid2, HueSlider hueSlider, AlphaSlider alphaSlider, IntegerFieldWidget redField, IntegerFieldWidget greenField, IntegerFieldWidget blueField, IntegerFieldWidget hueField, IntegerFieldWidget satField, IntegerFieldWidget lightField, IntegerFieldWidget alphaField) {
        super(x, y, 128, 128, (Component)Component.empty());
        this.textRenderer = textRenderer;
        this.onUpdate = onUpdate;
        this.colorGrid = ColorGrid2;
        this.hueSlider = hueSlider;
        this.alphaSlider = alphaSlider;
        this.redField = redField;
        this.greenField = greenField;
        this.blueField = blueField;
        this.hueField = hueField;
        this.satField = satField;
        this.lightField = lightField;
        this.alphaField = alphaField;
    }

    public void setX(int x) {
        super.setX(x);
        this.colorGrid.setX(x + 8);
        this.hueSlider.setX(x + 20);
        this.alphaSlider.setX(x + 20);
        this.redField.setX(x + 101);
        this.greenField.setX(x + 101);
        this.blueField.setX(x + 101);
        this.hueField.setX(x + 101);
        this.satField.setX(x + 101);
        this.lightField.setX(x + 101);
        this.alphaField.setX(x + 101);
    }

    public void setY(int y) {
        super.setY(y);
        this.colorGrid.setY(y + 8);
        this.hueSlider.setY(y + 94);
        this.alphaSlider.setY(y + 110);
        this.redField.setY(y + 9);
        this.greenField.setY(y + 22);
        this.blueField.setY(y + 35);
        this.hueField.setY(y + 50);
        this.satField.setY(y + 63);
        this.lightField.setY(y + 76);
        this.alphaField.setY(y + 108);
    }

    public void setTextFieldValues() {
        this.redField.setValue(this.color.r());
        this.greenField.setValue(this.color.g());
        this.blueField.setValue(this.color.b());
        this.hueField.setValue(Math.round(this.hueSlider.value * 360.0f));
        this.satField.setValue(Math.round(this.colorGrid.saturation * 100.0f));
        this.lightField.setValue(Math.round(this.colorGrid.lightness * 100.0f));
        this.alphaField.setValue(Math.round(this.alphaSlider.value * 100.0f));
    }

    public void setColor(float hue, float saturation, float lightness) {
        this.hueSlider.value = MathUtil.clamp((float)hue, (float)0.0f, (float)1.0f);
        this.colorGrid.saturation = MathUtil.clamp((float)saturation, (float)0.0f, (float)1.0f);
        this.colorGrid.lightness = MathUtil.clamp((float)lightness, (float)0.0f, (float)1.0f);
        this.updateHueNoUpdate();
        this.color = this.colorGrid.calculateColor();
        this.color.setAlpha(this.alphaSlider.value);
        this.setTextFieldValues();
    }

    public void setColorAndUpdate(float hue, float saturation, float lightness) {
        this.setColor(hue, saturation, lightness);
        this.onUpdate.accept(this.color);
    }

    public void setColor(Color clr) {
        float[] hsl = MathUtil.rgbToHsv((int)clr.r(), (int)clr.g(), (int)clr.b());
        this.color = clr;
        this.hueSlider.value = MathUtil.clamp((float)(hsl[0] / 360.0f), (float)0.0f, (float)1.0f);
        this.alphaSlider.value = clr.alphaAsFloat();
        this.colorGrid.saturation = MathUtil.clamp((float)hsl[1], (float)0.0f, (float)1.0f);
        this.colorGrid.lightness = MathUtil.clamp((float)hsl[2], (float)0.0f, (float)1.0f);
        this.updateHueNoUpdate();
        this.colorGrid.calculateColor();
        this.setTextFieldValues();
    }

    public void setColorAndUpdate(Color clr) {
        this.setColor(clr);
        this.onUpdate.accept(this.color);
    }

    public void updateColor() {
        this.color = this.colorGrid.color.copy();
        this.color.setAlpha(this.alphaSlider.value);
        this.setTextFieldValues();
        this.onUpdate.accept(this.color);
    }

    public void updateAlpha() {
        this.color.setAlpha(this.alphaSlider.value);
        this.updateColor();
    }

    public void updateHueNoUpdate() {
        int len = Color.RAINBOW.length;
        float pos = this.hueSlider.value * (float)len;
        int index = (int)pos;
        float delta = pos - (float)index;
        Color left = Color.RAINBOW[index % len];
        Color right = Color.RAINBOW[(index + 1) % len];
        left.lerp(delta, right, this.hueColor);
        this.colorGrid.hueColor = this.hueColor;
    }

    public void updateHue() {
        this.updateHueNoUpdate();
        this.colorGrid.update();
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.blit(TEXTURE, this.getX(), this.getY(), 0, 0.0f, 295.0f, 128, 92, 512, 512);
        this.colorGrid.render(context, mouseX, mouseY, delta);
        this.redField.render(context, mouseX, mouseY, delta);
        this.greenField.render(context, mouseX, mouseY, delta);
        this.blueField.render(context, mouseX, mouseY, delta);
        this.hueField.render(context, mouseX, mouseY, delta);
        this.satField.render(context, mouseX, mouseY, delta);
        this.lightField.render(context, mouseX, mouseY, delta);
    }

    public void unfocusTextFields() {
        this.redField.setFocused(false);
        this.blueField.setFocused(false);
        this.greenField.setFocused(false);
        this.hueField.setFocused(false);
        this.satField.setFocused(false);
        this.lightField.setFocused(false);
        this.alphaField.setFocused(false);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.unfocusTextFields();
        if (this.colorGrid.isMouseOver(mouseX, mouseY) && this.colorGrid.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hueSlider.isMouseOver(mouseX, mouseY) && this.hueSlider.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.alphaSlider.isMouseOver(mouseX, mouseY) && this.alphaSlider.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.redField.isMouseOver(mouseX, mouseY)) {
            this.redField.setFocused(true);
            return this.redField.mouseClicked(mouseX, mouseY, button);
        }
        if (this.greenField.isMouseOver(mouseX, mouseY)) {
            this.greenField.setFocused(true);
            return this.greenField.mouseClicked(mouseX, mouseY, button);
        }
        if (this.blueField.isMouseOver(mouseX, mouseY)) {
            this.blueField.setFocused(true);
            return this.blueField.mouseClicked(mouseX, mouseY, button);
        }
        if (this.hueField.isMouseOver(mouseX, mouseY)) {
            this.hueField.setFocused(true);
            return this.hueField.mouseClicked(mouseX, mouseY, button);
        }
        if (this.satField.isMouseOver(mouseX, mouseY)) {
            this.satField.setFocused(true);
            return this.satField.mouseClicked(mouseX, mouseY, button);
        }
        if (this.lightField.isMouseOver(mouseX, mouseY)) {
            this.lightField.setFocused(true);
            return this.lightField.mouseClicked(mouseX, mouseY, button);
        }
        if (this.alphaField.isMouseOver(mouseX, mouseY)) {
            this.alphaField.setFocused(true);
            return this.alphaField.mouseClicked(mouseX, mouseY, button);
        }
        if (this.active && this.visible) {
            boolean bl;
            if (this.isValidClickButton(button) && (bl = this.clicked(mouseX, mouseY))) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                this.onClick(mouseX, mouseY);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.colorGrid.isDragging(mouseX, mouseY) && this.colorGrid.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.hueSlider.isDragging(mouseX, mouseY) && this.hueSlider.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.alphaSlider.isDragging(mouseX, mouseY) && this.alphaSlider.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.colorGrid.isReleasing(mouseX, mouseY) && this.colorGrid.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hueSlider.isReleasing(mouseX, mouseY) && this.hueSlider.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.alphaSlider.isReleasing(mouseX, mouseY) && this.alphaSlider.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.redField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.greenField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.blueField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.hueField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.satField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.lightField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.alphaField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (this.redField.charTyped(chr, modifiers)) {
            return true;
        }
        if (this.greenField.charTyped(chr, modifiers)) {
            return true;
        }
        if (this.blueField.charTyped(chr, modifiers)) {
            return true;
        }
        if (this.hueField.charTyped(chr, modifiers)) {
            return true;
        }
        if (this.satField.charTyped(chr, modifiers)) {
            return true;
        }
        if (this.lightField.charTyped(chr, modifiers)) {
            return true;
        }
        if (this.alphaField.charTyped(chr, modifiers)) {
            return true;
        }
        return super.charTyped(chr, modifiers);
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

