/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.glint;

import com.redpxnda.nucleus.util.Color;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.config.MiapiConfig;

@OnlyIn(value=Dist.CLIENT)
public class FloatWidgetField
extends EditBox
implements GuiEventListener {
    @Nullable
    public String prefix;
    public float value;
    @Nullable
    public Float maxValue = null;
    @Nullable
    public Float minValue = null;
    protected final Consumer<Float> onValueUpdate;
    protected final Font textRenderer;
    public DecimalFormat format = new DecimalFormat("###.##");

    public FloatWidgetField(Font textRenderer, int x, int y, int width, int height, Component message, Consumer<Float> onValueUpdate) {
        super(textRenderer, x, y, width, height, message);
        this.textRenderer = textRenderer;
        this.onValueUpdate = onValueUpdate;
        this.setValue(this.value);
        this.setBordered(false);
    }

    public FloatWidgetField(Font textRenderer, int x, int y, int width, int height, float minValue, float maxValue, Component message, Consumer<Float> onValueUpdate, String prefix) {
        this(textRenderer, x, y, width, height, message, onValueUpdate);
        this.maxValue = Float.valueOf(maxValue);
        this.minValue = Float.valueOf(minValue);
        this.prefix = prefix;
    }

    public void setValue(float v) {
        if (this.maxValue != null && v > this.maxValue.floatValue()) {
            v = this.maxValue.floatValue();
        } else if (this.minValue != null && v < this.minValue.floatValue()) {
            v = this.minValue.floatValue();
        }
        this.value = v;
        this.setValue(this.prefix + this.format.format(Float.valueOf(v)));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.setFocused(this.isMouseOver(mouseX, mouseY));
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void tryUpdateValue() {
        try {
            this.value = Float.parseFloat(this.getValue());
        }
        catch (Exception e) {
            this.value = 0.0f;
        }
        if (this.maxValue != null && this.value > this.maxValue.floatValue()) {
            this.value = this.maxValue.floatValue();
            this.setValue(this.value);
        } else if (this.minValue != null && this.value < this.minValue.floatValue()) {
            this.value = this.minValue.floatValue();
            this.setValue(this.value);
        }
        this.onValueUpdate.accept(Float.valueOf(this.value));
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.prefix != null) {
            context.drawString(this.textRenderer, this.prefix, this.getX() - this.textRenderer.width(this.prefix) - 4, this.getY() - 1, Color.WHITE.argb(), true);
        }
        if (MiapiConfig.getServerConfig().other.developmentMode && Screen.hasAltDown()) {
            InteractAbleWidget.drawSquareBorder(context, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 1, Color.YELLOW.argb());
        }
        super.renderWidget(context, mouseX, mouseY, delta);
    }

    public void insertText(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr >= '0' && chr <= '9' || chr == '.' && !this.getValue().contains(".")) continue;
            return;
        }
        super.insertText(text);
        this.tryUpdateValue();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean result = super.keyPressed(keyCode, scanCode, modifiers);
        if (result) {
            this.tryUpdateValue();
        }
        return result;
    }
}

