/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.glint;

import com.redpxnda.nucleus.math.MathUtil;
import com.redpxnda.nucleus.util.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.crafter.glint.AlphaSlider;
import smartin.miapi.client.gui.crafting.crafter.glint.ColorPickerWidget;
import smartin.miapi.client.gui.crafting.crafter.glint.FloatWidgetField;
import smartin.miapi.client.gui.crafting.crafter.glint.HueSlider;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.GlintProperty;

@OnlyIn(value=Dist.CLIENT)
public class GlintEditView
extends InteractAbleWidget {
    public static final ResourceLocation TEXTURE = CraftingScreen.BACKGROUND_TEXTURE;
    private final ScrollList scrollList;
    List<InteractAbleWidget> colorButtons = new ArrayList<InteractAbleWidget>();
    Consumer<List<Color>> preview;
    AlphaSlider speedSlider;
    float rainbowSpeed;
    EditOption.EditContext option;
    FloatWidgetField floatWidgetField;
    static float maxSpeed = 4.0f;

    public GlintEditView(int x, int y, int width, int height, EditOption.EditContext editContext, Consumer<GlintProperty.RainbowGlintSettings> onChange, Consumer<GlintProperty.RainbowGlintSettings> onCraft) {
        super(x, y, width, height, (Component)Component.empty());
        this.option = editContext;
        GlintProperty.RainbowGlintSettings oldSettings = GlintProperty.property.getData(editContext.getItemstack()).orElse(GlintProperty.defaultSettings);
        this.preview = list -> onChange.accept(this.glintSettings(oldSettings, (List<Color>)list));
        ArrayList<Color> colors = new ArrayList<Color>(Arrays.stream(oldSettings.colors).toList());
        if (colors.isEmpty()) {
            colors.add(Color.RED);
        }
        ArrayList<InteractAbleWidget> widgets = new ArrayList<InteractAbleWidget>();
        this.scrollList = new ScrollList(this.getX(), this.getY(), this.getWidth(), this.getHeight() - 20, widgets);
        this.addChild(this.scrollList);
        this.scrollList.alwaysEnableScrollbar = true;
        this.floatWidgetField = new FloatWidgetField(Minecraft.getInstance().font, this.getX() + 60, this.getY() + this.getHeight() - 13, 30, 10, 0.0f, 128.0f, (Component)Component.empty(), f -> {
            this.updateSpeed(onChange, (Float)f, oldSettings);
            this.speedSlider.value = Math.clamp(f.floatValue() / maxSpeed, 0.0f, 1.0f);
        }, "");
        this.addChild(this.floatWidgetField);
        SimpleButton<Void> plusButton2 = new SimpleButton<Void>(0, 0, 50, 10, (Component)Component.literal((String)"+"), null, callback -> {
            Color newColor = Color.RED;
            this.addColorToScrollList(newColor);
            this.preview.accept(this.getColors());
        });
        this.colorButtons.add(plusButton2);
        for (Color color : colors) {
            this.addColorToScrollList(color);
        }
        this.scrollList.setList(this.colorButtons);
        this.speedSlider = new AlphaSlider(this.getX() + 3, this.getY() + this.getHeight() - 12, 50, 6, f -> {
            this.updateSpeed(onChange, Float.valueOf(f.floatValue() * maxSpeed), oldSettings);
            this.floatWidgetField.setValue(f.floatValue() * maxSpeed);
        });
        this.floatWidgetField.setValue(oldSettings.rainbowSpeed);
        this.speedSlider.value = Math.clamp(oldSettings.rainbowSpeed / maxSpeed, 0.0f, 1.0f);
        this.addChild((GuiEventListener)this.speedSlider);
        SimpleButton<Void> applyButton = new SimpleButton<Void>(this.getX() + this.getWidth() - 50, this.getY() + this.getHeight() - 18, 40, 16, (Component)Component.literal((String)"Apply"), null, callback -> onCraft.accept(this.glintSettings(oldSettings, this.getColors())));
        this.addChild(applyButton);
    }

    private void updateSpeed(Consumer<GlintProperty.RainbowGlintSettings> onChange, Float f, GlintProperty.RainbowGlintSettings oldSettings) {
        GlintProperty.RainbowGlintSettings settings = this.glintSettings(oldSettings, this.getColors());
        this.rainbowSpeed = settings.rainbowSpeed = f.floatValue();
        onChange.accept(settings);
    }

    public List<Color> getColors() {
        return this.colorButtons.stream().filter(SingleColorEdit.class::isInstance).map(a -> ((SingleColorEdit)a).currentColor).toList();
    }

    private void addColorToScrollList(Color color) {
        SingleColorEdit singleColorEdit = new SingleColorEdit(0, 0, this.getWidth() - 20, (Component)Component.literal((String)"Color"), color, (button, updatedColor) -> {
            int index = this.colorButtons.indexOf(button);
            if (index != -1) {
                this.preview.accept(this.getColors());
            }
        });
        this.colorButtons.add(Math.max(0, this.scrollList.widgets.size() - 1), singleColorEdit);
        this.scrollList.setList(this.colorButtons);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public GlintProperty.RainbowGlintSettings glintSettings(GlintProperty.RainbowGlintSettings oldSettings, List<Color> list) {
        oldSettings = oldSettings.copyWithColor(list);
        oldSettings.rainbowSpeed = this.rainbowSpeed;
        oldSettings.isItem = this.option.getInstance() == null;
        return oldSettings;
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        drawContext.blit(TEXTURE, this.getX(), this.getY() + this.getHeight() - 18, 0, 0.0f, 387.0f, 92, 16, 512, 512);
        super.renderWidget(drawContext, mouseX, mouseY, delta);
        if ((this.debug || MiapiConfig.getServerConfig().other.developmentMode) && Screen.hasAltDown()) {
            GlintEditView.drawSquareBorder(drawContext, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 1, this.randomColor);
        }
    }

    protected class SingleColorEdit
    extends InteractAbleWidget {
        private final ColorPickerWidget colorPicker;
        private final HueSlider hueSlider;
        private final SimpleButton<Void> removeButton;
        private final SimpleButton<Void> toggleButton;
        private boolean isExpanded;
        public Color currentColor;

        public SingleColorEdit(int x, int y, int width, Component title, Color initialColor, BiConsumer<SingleColorEdit, Color> onColorChange) {
            super(x, y, width, 13, title);
            this.isExpanded = false;
            initialColor.setAlpha(255);
            this.currentColor = initialColor;
            this.colorPicker = new ColorPickerWidget(Minecraft.getInstance().font, x + 10, y + 25, selectedColor -> {
                this.currentColor = selectedColor;
                onColorChange.accept(this, (Color)selectedColor);
            });
            this.colorPicker.setColor(initialColor);
            this.colorPicker.visible = false;
            this.removeButton = new SimpleButton<Void>(x + width - 3, y + 1, 11, 11, (Component)Component.literal((String)"X"), null, callback -> {
                GlintEditView.this.colorButtons.remove((Object)this);
                GlintEditView.this.scrollList.setList(GlintEditView.this.colorButtons);
            });
            this.addChild(this.removeButton);
            this.toggleButton = new SimpleButton<Void>(x + width - 16, y + 1, 11, 11, (Component)Component.literal((String)"..."), null, callback -> {
                this.colorPicker.visible = this.isExpanded = !this.isExpanded;
                this.setHeight(this.isExpanded ? 13 + this.colorPicker.getHeight() : 13);
                if (this.isExpanded) {
                    this.addChild(this.colorPicker);
                } else {
                    this.removeChild(this.colorPicker);
                }
            });
            this.hueSlider = new HueSlider(x + 16, y + 3, x + this.getWidth() - 30, 8, a -> this.colorPicker.setColorAndUpdate(a.floatValue(), this.colorPicker.colorGrid.saturation, this.colorPicker.colorGrid.lightness));
            float[] hsl = MathUtil.rgbToHsv((int)this.currentColor.r(), (int)this.currentColor.g(), (int)this.currentColor.b());
            this.hueSlider.value = MathUtil.clamp((float)(hsl[0] / 360.0f), (float)0.0f, (float)1.0f);
            this.addChild((GuiEventListener)this.hueSlider);
            this.addChild(this.toggleButton);
        }

        public void setX(int x) {
            this.removeButton.setX(x + this.width - 3 - 8);
            this.toggleButton.setX(x + this.width - 16 - 8);
            this.colorPicker.setX(x + 5);
            this.hueSlider.setX(x + 16);
            super.setX(x);
        }

        public void setY(int y) {
            this.removeButton.setY(y);
            this.toggleButton.setY(y);
            this.colorPicker.setY(y + 12);
            this.hueSlider.setY(y + 3);
            super.setY(y);
        }

        @Override
        public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            drawContext.fill(this.getX() + 1, this.getY() + 1, this.getX() + 10, this.getY() + 10, this.currentColor.argb());
            super.renderWidget(drawContext, mouseX, mouseY, delta);
        }

        @Override
        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (GuiEventListener child : this.children()) {
                if (!child.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }
    }
}

