/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.glint;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.redpxnda.nucleus.math.MathUtil;
import com.redpxnda.nucleus.util.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class HueSlider
extends AbstractWidget {
    public static final ResourceLocation SCROLLBAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"nucleus", (String)"textures/gui/small_scrollbars.png");
    public float value;
    public boolean dragging = false;
    public final Consumer<Float> updateListener;

    public HueSlider(int x, int y, int width, int height, Consumer<Float> updateListener) {
        super(x, y, width, height, (Component)Component.empty());
        this.updateListener = updateListener;
    }

    public void onClick(double mouseX, double mouseY) {
        this.dragging = true;
        this.value = MathUtil.clamp((float)((float)(mouseX - (double)this.getX()) / (float)this.width), (float)0.0f, (float)1.0f);
        this.update();
    }

    public void onRelease(double mouseX, double mouseY) {
        this.dragging = false;
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.value = MathUtil.clamp((float)((float)(mouseX - (double)this.getX()) / (float)this.width), (float)0.0f, (float)1.0f);
        this.update();
    }

    protected boolean isDragging(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY) || this.dragging;
    }

    protected boolean isReleasing(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY) || this.dragging;
    }

    protected void update() {
        this.updateListener.accept(Float.valueOf(this.value));
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderScrollbar(context, mouseX, mouseY, delta);
        float startY = this.getY();
        float endY = this.getY() + this.height - 2;
        int len = Color.RAINBOW.length;
        float segmentSize = (float)this.width / (float)len;
        VertexConsumer vc = context.bufferSource().getBuffer(RenderType.gui());
        Matrix4f matrix4f = context.pose().last().pose();
        for (int i = 0; i < len; ++i) {
            Color current = Color.RAINBOW[i];
            Color next = Color.RAINBOW[(i + 1) % len];
            float startX = (float)this.getX() + (float)i * segmentSize;
            float endX = (float)this.getX() + (float)(i + 1) * segmentSize;
            vc.addVertex(matrix4f, startX, startY, 0.0f).setColor(current.r(), current.g(), current.b(), current.a());
            vc.addVertex(matrix4f, startX, endY, 0.0f).setColor(current.r(), current.g(), current.b(), current.a());
            vc.addVertex(matrix4f, endX, endY, 0.0f).setColor(next.r(), next.g(), next.b(), next.a());
            vc.addVertex(matrix4f, endX, startY, 0.0f).setColor(next.r(), next.g(), next.b(), next.a());
        }
    }

    protected void renderScrollbar(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.pose().pushPose();
        context.pose().translate(0.0f, 0.0f, 1.0f);
        context.blit(SCROLLBAR_TEXTURE, this.getX() - 1 + (int)(this.value * (float)(this.width - this.getScrollbarWidth())), this.getY() - 1, 6, 8, this.isHovered() ? 6.0f : 0.0f, 0.0f, 6, 8, 12, 8);
        context.pose().popPose();
    }

    protected int getScrollbarWidth() {
        return 4;
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

