/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.HoverDescription;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.MutableSlot;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.SimpleScreenHandlerListener;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.client.gui.crafting.crafter.replace.EmptyCraftingWidget;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.network.Networking;

@OnlyIn(value=Dist.CLIENT)
public class CraftViewRework
extends InteractAbleWidget {
    public List<Slot> currentSlots = new ArrayList<Slot>();
    private int currentGuiIndex = 0;
    int backgroundWidth = 284;
    int backgroundHeight = 221;
    List<Component> warnings = new ArrayList<Component>();
    boolean firstRender = true;
    boolean isClosed = false;
    EditOption.EditContext editContext;
    CraftAction action;
    CraftOption craftOption;
    List<CraftingProperty> craftingProperties = new ArrayList<CraftingProperty>();
    List<InteractAbleWidget> craftingGuis = new ArrayList<InteractAbleWidget>();
    SimpleButton<Object> previousButton;
    SimpleButton<Object> nextButton;
    CraftButton<Object> craftButton;
    Matrix4f currentMatrix = new Matrix4f();
    public Map<ResourceLocation, JsonElement> defaultMap = new HashMap<ResourceLocation, JsonElement>();
    static ContainerListener listener;
    EmptyCraftingWidget fallbackCraftingWidget;

    public CraftViewRework(int x, int y, int width, int height, int offset, CraftOption option, EditOption.EditContext editContext, Consumer<SlotProperty.ModuleSlot> back) {
        super(x, y, width, height, (Component)Component.empty());
        this.editContext = editContext;
        this.craftOption = option;
        if (listener != null) {
            editContext.getScreenHandler().removeSlotListener(listener);
        }
        listener = new SimpleScreenHandlerListener((TriConsumer<AbstractContainerMenu, Integer, ItemStack>)((TriConsumer)(h, slotId, itemStack) -> {
            if (slotId != 36) {
                this.update();
            }
        }));
        this.defaultMap = option.data().get();
        this.action = new CraftAction(editContext.getItemstack(), editContext.getSlot(), option.module(), editContext.getPlayer(), editContext.getWorkbench(), option.data().get(), editContext.getScreenHandler());
        this.action.setItem(editContext.getItemstack());
        this.action.linkInventory(editContext.getLinkedInventory(), offset);
        this.setBuffers();
        ItemStack test = this.action.getPreview();
        this.action.forEachCraftingProperty(test, (craftingProperty, moduleInstance, itemStacks, invStart, invEnd, buf) -> {
            InteractAbleWidget guiScreen = craftingProperty.createGui(this.getX(), this.getY(), this.width, this.height - 30, this.action);
            if (guiScreen != null) {
                this.craftingGuis.add(guiScreen);
                this.craftingProperties.add(craftingProperty);
            }
        });
        this.fallbackCraftingWidget = new EmptyCraftingWidget(this.getX(), this.getY(), this.width, this.height, this.action);
        this.addChild(new SimpleButton<Object>(this.getX() + 2, this.getY() + this.height - 14, 40, 12, (Component)Component.translatable((String)"miapi.ui.back"), null, moduleSlot -> {
            this.isClosed = true;
            this.closeSlot();
            back.accept(null);
        }));
        if (this.craftingGuis.size() > 1) {
            this.previousButton = new PageButton<Object>(this.getX() + this.width - 10, this.getY(), 10, 12, true, null, callback -> {
                if (this.currentGuiIndex > 0) {
                    this.removeChild(this.craftingGuis.get(this.currentGuiIndex));
                    --this.currentGuiIndex;
                    this.addGui(this.craftingGuis.get(this.currentGuiIndex));
                    if (this.currentGuiIndex == 0) {
                        this.previousButton.isEnabled = false;
                    }
                    this.nextButton.isEnabled = true;
                }
            });
            this.nextButton = new PageButton<Object>(this.getX() + 10, this.getY(), 10, 12, false, null, callback -> {
                if (this.currentGuiIndex < this.craftingGuis.size() - 1) {
                    this.removeChild(this.craftingGuis.get(this.currentGuiIndex));
                    ++this.currentGuiIndex;
                    this.addGui(this.craftingGuis.get(this.currentGuiIndex));
                    if (this.currentGuiIndex == this.craftingGuis.size() - 1) {
                        this.nextButton.isEnabled = false;
                    }
                    this.previousButton.isEnabled = true;
                }
            });
        }
        this.craftButton = new CraftButton<Object>(this.getX() + this.width - 42, this.getY() + this.height - 14, 40, 12, (Component)Component.translatable((String)"miapi.ui.craft"), null, callback -> {
            this.setBuffers();
            this.action.setData(option.data().get());
            if (this.action.canPerform()) {
                this.isClosed = true;
                ItemStack craftedStack = this.action.getPreview();
                if (!ItemStack.matches((ItemStack)editContext.getItemstack(), (ItemStack)craftedStack)) {
                    editContext.craft(this.action.toPacket(Networking.createBuffer()));
                }
                editContext.getScreenHandler().removeSlotListener(listener);
            }
        });
        this.addChild(this.craftButton);
        editContext.getScreenHandler().addSlotListener(listener);
    }

    private void update() {
        try {
            if (!this.isClosed) {
                this.action.setData(this.craftOption.data().get());
                ItemStack previewStack = this.action.getPreview();
                this.action.setData(this.craftOption.data().get());
                this.setBuffers();
                this.action.setData(this.craftOption.data().get());
                this.editContext.preview(this.action.toPacket(Networking.createBuffer()));
                Pair<Map<CraftingProperty, Boolean>, Boolean> canPerform = this.action.fullCanPerform();
                this.craftButton.isEnabled = (Boolean)canPerform.getSecond();
                this.warnings.clear();
                ItemStack crafted = this.editContext.getItemstack();
                if (ItemStack.matches((ItemStack)previewStack, (ItemStack)crafted)) {
                    this.warnings.add((Component)Component.translatable((String)"miapi.ui.craft.result_equal_warning"));
                    this.craftButton.isEnabled = false;
                }
                if (previewStack.getDamageValue() > previewStack.getMaxDamage()) {
                    this.warnings.add((Component)Component.translatable((String)"miapi.ui.craft.warning.durability_negative"));
                    this.craftButton.isEnabled = false;
                }
                ((Map)canPerform.getFirst()).forEach((property, result) -> {
                    Component warning;
                    if (!result.booleanValue() && (warning = property.getWarning()) != null && !warning.getString().isEmpty()) {
                        this.warnings.add(warning);
                    }
                });
            }
        }
        catch (Exception e) {
            Miapi.LOGGER.error("surpressed", (Throwable)e);
        }
    }

    public void closeSlot() {
        this.currentSlots.forEach(slot -> {
            if (slot instanceof MutableSlot) {
                MutableSlot mutableSlot = (MutableSlot)((Object)slot);
                mutableSlot.setEnabled(true);
            }
            this.editContext.removeSlot((Slot)slot);
        });
    }

    public void addGui(InteractAbleWidget widget) {
        if (this.children.contains((Object)widget)) {
            return;
        }
        widget.setX(this.getX());
        widget.setY(this.getY());
        widget.setWidth(this.width);
        widget.setHeight(this.height);
        this.currentSlots.forEach(slot -> {
            if (slot instanceof MutableSlot) {
                MutableSlot mutableSlot = (MutableSlot)((Object)slot);
                mutableSlot.setEnabled(false);
            }
        });
        CraftingProperty property = this.craftingProperties.get(this.craftingGuis.indexOf((Object)widget));
        this.action.forEachCraftingProperty(this.action.getPreview(), (craftingProperty, module, inventory, start, end, buffer) -> {
            if (craftingProperty.equals(property)) {
                AtomicInteger counter = new AtomicInteger(0);
                property.getSlotPositions().forEach(vec2f -> {
                    int guiX = widget.getX() + (int)vec2f.x;
                    int guiY = widget.getY() + (int)vec2f.y;
                    Matrix4f inverse = new Matrix4f((Matrix4fc)this.currentMatrix);
                    Vector4f vector4f = TransformableWidget.transFormMousePos(guiX, guiY, inverse);
                    guiX = (int)(vector4f.x() - (float)((Minecraft.getInstance().screen.width - this.backgroundWidth) / 2));
                    guiY = (int)(vector4f.y() - (float)((Minecraft.getInstance().screen.height - this.backgroundHeight) / 2));
                    MutableSlot slot = new MutableSlot(this.editContext.getLinkedInventory(), start + counter.getAndAdd(1), guiX, guiY);
                    this.currentSlots.add(slot);
                    this.editContext.addSlot(slot);
                });
            }
        });
        this.addChild(widget);
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.currentMatrix = drawContext.pose().last().pose();
        if (this.firstRender) {
            this.update();
            this.firstRender = false;
        }
        if (!this.craftingGuis.isEmpty()) {
            this.addGui(this.craftingGuis.get(this.currentGuiIndex));
        } else {
            this.addChild(this.fallbackCraftingWidget);
        }
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }

    public void setBuffers() {
        HashMap<ResourceLocation, JsonElement> data = new HashMap<ResourceLocation, JsonElement>(this.defaultMap);
        this.action.data = this.craftOption.data().get();
        this.action.forEachCraftingProperty(this.editContext.getItemstack(), (craftingProperty, moduleInstance, itemStacks, invStart, invEnd, buf) -> {
            int index = this.craftingProperties.indexOf(craftingProperty);
            if (index >= 0) {
                craftingProperty.writeData(data, this.craftingGuis.get(this.craftingProperties.indexOf(craftingProperty)), this.editContext);
            } else {
                craftingProperty.writeData(data, null, this.editContext);
            }
        });
        this.action.setData(data);
    }

    public static class PageButton<T>
    extends SimpleButton<T> {
        private final boolean isLeft;
        private final ResourceLocation texture;
        private boolean isClicked;
        private final ResourceLocation right = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"textures/button_right.png");
        private final ResourceLocation left = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"textures/button_left.png");

        public PageButton(int x, int y, int width, int height, boolean isLeft, T toCallBack, Consumer<T> callback) {
            super(x, y, width, height, (Component)Component.empty(), toCallBack, callback);
            this.isLeft = isLeft;
            this.texture = isLeft ? this.left : this.right;
        }

        @Override
        public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
            super.renderWidget(context, mouseX, mouseY, delta);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int textureOffset = 0;
            if (this.isClicked) {
                textureOffset = 20;
                if (!this.isMouseOver(mouseX, mouseY)) {
                    this.isClicked = false;
                }
            } else if (this.isMouseOver(mouseX, mouseY)) {
                textureOffset = 10;
            }
            if (!this.isEnabled) {
                textureOffset = 30;
            }
            context.blit(this.texture, this.getX(), this.getY(), 0, (float)textureOffset, 0.0f, this.width, this.height, 40, this.height);
        }
    }

    public class CraftButton<T>
    extends SimpleButton<T> {
        public HoverDescription hover;

        public CraftButton(int x, int y, int width, int height, Component title, T toCallback, Consumer<T> callback) {
            super(x, y, width, height, title, toCallback, callback);
            this.hover = new HoverDescription(x, y + height, List.of());
        }

        @Override
        public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            super.renderWidget(drawContext, mouseX, mouseY, delta);
        }

        @Override
        public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            if (!this.isEnabled && this.isMouseOver(mouseX, mouseY)) {
                MutableComponent text = Component.translatable((String)"miapi.ui.craft.warning").withStyle(ChatFormatting.DARK_RED);
                this.hover.addText((Component)text);
                this.hover.setX(this.getX());
                this.hover.setY(this.getY() + this.getHeight());
                for (Component warning : CraftViewRework.this.warnings) {
                    this.hover.addText((Component)Component.literal((String)" - ").append(warning).withStyle(ChatFormatting.RED));
                }
                this.hover.render(drawContext, mouseX, mouseY, delta);
                this.hover.reset();
            }
        }
    }
}

