/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.MultiLineTextWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.PreviewManager;
import smartin.miapi.client.gui.crafting.crafter.replace.hover.HoverInteractableMaterialList;
import smartin.miapi.client.gui.crafting.crafter.replace.hover.MaterialStatPreview;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.craft.MaterialCraftInfo;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.edit_options.ReplaceOption;

@OnlyIn(value=Dist.CLIENT)
public class MaterialCraftingWidget
extends InteractAbleWidget {
    private final MaterialCraftInfo allowedMaterial;
    private final ScrollingTextWidget costDescr;
    public CraftAction action;
    private final DecimalFormat modifierFormat = (DecimalFormat)Util.make((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public MaterialCraftingWidget(MaterialCraftInfo allowedMaterial, int x, int y, int width, int height, CraftAction action) {
        super(x, y, width, height, (Component)Component.empty());
        this.action = action;
        this.allowedMaterial = allowedMaterial;
        allowedMaterial.setSlotHeight(height + 12);
        if (allowedMaterial.renderMaterialWidget()) {
            this.addChild(new HoverInteractableMaterialList(action.toAdd, x + 71, y + this.height + 10, 31, 19));
            this.addChild(new MaterialStatPreview(x + this.getWidth() - 12, y + 12, 10, 10, action.toAdd));
        }
        ModuleInstance moduleInstance = new ModuleInstance(action.toAdd);
        Component displayText = moduleInstance.getModuleName();
        Component descriptionText = moduleInstance.getModuleDescription();
        float headerScale = 1.5f;
        TransformableWidget headerHolder = new TransformableWidget(x, y, width, height, headerScale);
        this.addChild(headerHolder);
        ScrollingTextWidget header = new ScrollingTextWidget((int)((float)(this.getX() + 5) / headerScale), (int)((float)this.getY() / headerScale) + 2, (int)((float)(this.width - 10) / headerScale), displayText, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        headerHolder.addChild(header);
        MultiLineTextWidget description = new MultiLineTextWidget(x + 5, y + 25, width - 10, height - 40, descriptionText);
        this.costDescr = new ScrollingTextWidget(x + 71, y + this.height - 8, 78, (Component)Component.empty());
        this.costDescr.textColor = FastColor.ARGB32.color((int)255, (int)225, (int)225, (int)225);
        this.addChild(description);
        this.addChild(this.costDescr);
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        RenderSystem.enableDepthTest();
        ReplaceOption.unsafeCraftAction = this.action;
        if (ReplaceOption.unsafeEditContext != null && !ReplaceOption.unsafeEditContext.getScreenHandler().inventory.getItem(1).isEmpty()) {
            PreviewManager.resetCursorStack();
        }
        boolean textureOffset = false;
        this.costDescr.textColor = this.allowedMaterial.getMaterialCostClient() < this.allowedMaterial.getMaterialRequirementClient() ? FastColor.ARGB32.color((int)255, (int)225, (int)225, (int)125) : FastColor.ARGB32.color((int)255, (int)125, (int)225, (int)125);
        this.costDescr.setText((Component)Component.literal((String)(this.modifierFormat.format(this.allowedMaterial.getMaterialCostClient()) + "/" + this.modifierFormat.format(this.allowedMaterial.getMaterialRequirementClient()))));
        this.costDescr.setY(this.getY() + this.allowedMaterial.getSlotHeight() + 10);
        MaterialCraftingWidget.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, this.getX(), this.getY(), 368, 138, 26, 26, this.getWidth(), this.getHeight(), 512, 512, 5);
        MaterialCraftingWidget.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, this.getX() + 50, this.getY() + this.allowedMaterial.getSlotHeight() - 3, 339, 137, 28, 28, 20, 20, 512, 512, 5);
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }
}

