/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.slotdisplay;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import smartin.miapi.client.gui.InteractAbleWidget;

@OnlyIn(value=Dist.CLIENT)
public class SmithDisplay
extends InteractAbleWidget {
    public static final Quaternionf ARMOR_STAND_ROTATION = new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI);
    @Nullable
    private final ArmorStand armorStand;

    public SmithDisplay(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
        this.armorStand = new ArmorStand((Level)Minecraft.getInstance().level, 0.0, 0.0, 0.0);
        this.armorStand.setNoBasePlate(true);
        this.armorStand.setShowArms(true);
        this.armorStand.yBodyRot = 210.0f;
        this.armorStand.setXRot(25.0f);
        this.armorStand.yHeadRot = this.armorStand.getYRot();
        this.armorStand.yHeadRotO = this.armorStand.getYRot();
        this.equipArmorStand(ItemStack.EMPTY);
    }

    public void setPreview(ItemStack itemStack) {
        this.equipArmorStand(itemStack);
    }

    private void equipArmorStand(ItemStack stack) {
        if (this.armorStand == null) {
            return;
        }
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            this.armorStand.setItemSlot(equipmentSlot, ItemStack.EMPTY);
        }
        if (!stack.isEmpty()) {
            ItemStack itemStack = stack;
            Item item = stack.getItem();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                this.armorStand.setItemSlot(armorItem.getEquipmentSlot(), itemStack);
            } else {
                this.armorStand.setItemSlot(EquipmentSlot.OFFHAND, itemStack);
            }
        }
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)context, (int)(this.getX() + this.getWidth() / 2 + 3), (int)(this.getY() + this.height - 10), (int)30, (int)50, (int)2, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)this.armorStand);
        super.renderWidget(context, mouseX, mouseY, delta);
    }
}

