/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.DoubleProperty;

@OnlyIn(value=Dist.CLIENT)
public class SinglePropertyStatDisplay
extends SingleStatDisplayDouble {
    protected DoubleProperty property;
    public BiFunction<ItemStack, ItemStack, Boolean> condition = (old, compare) -> true;

    protected SinglePropertyStatDisplay(StatListWidget.TextGetter title, StatListWidget.TextGetter hover, DoubleProperty property) {
        super(0, 0, 51, 19, title, hover);
        this.property = property;
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        super.shouldRender(original, compareTo);
        if (!this.condition.apply(original, compareTo).booleanValue()) {
            return false;
        }
        return this.property.getValue(original).isPresent() || this.property.getValue(compareTo).isPresent();
    }

    @Override
    public double getValue(ItemStack stack) {
        return this.property.getValue(stack).orElse(0.0);
    }

    @Override
    public DoubleOperationResolvable getResolvable(ItemStack stack) {
        return this.property.getData(stack).orElse(null);
    }

    public static String stringForOperation(DecimalFormat format, DoubleOperationResolvable.Operation resolvable) {
        String number = format.format(resolvable.solve());
        String operation = SinglePropertyStatDisplay.getStringName(resolvable.attributeOperation);
        if (operation.equals("+") && number.startsWith("-")) {
            return number + " " + resolvable.instance.getModuleName().getString();
        }
        return operation + number + " " + resolvable.instance.getModuleName().getString();
    }

    public static String getStringName(AttributeModifier.Operation operation) {
        return switch (operation) {
            default -> throw new MatchException(null, null);
            case AttributeModifier.Operation.ADD_VALUE -> "+";
            case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> "*";
            case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> "**";
        };
    }

    public static Builder builder(DoubleProperty property) {
        return new Builder(property);
    }

    public static class Builder {
        DoubleProperty property;
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> Component.empty();
        public String translationKey = "";
        public Object[] descriptionArgs = new Object[0];
        public DecimalFormat modifierFormat;
        public DecimalFormat hoverFormat;
        public double min = 0.0;
        public double max = 100.0;
        public boolean inverse = false;
        public BiFunction<ItemStack, ItemStack, Boolean> condition = (old, compare) -> true;

        private Builder(DoubleProperty property) {
            this.property = property;
            this.modifierFormat = (DecimalFormat)Util.make((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        }

        public Builder setInverse(boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public Builder setCondition(BiFunction<ItemStack, ItemStack, Boolean> condition) {
            this.condition = condition;
            return this;
        }

        public Builder setMax(double maxValue) {
            this.max = maxValue;
            return this;
        }

        public Builder setMin(double minValue) {
            this.min = minValue;
            return this;
        }

        public Builder setName(Component name) {
            this.name = stack -> name;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder setTranslationKey(ResourceLocation key) {
            this.translationKey = Miapi.toLangString(key);
            this.name = stack -> Component.translatable((String)("miapi.stat." + this.translationKey), (Object[])new Object[]{this.modifierFormat.format(this.property.getValue(stack).orElse(0.0))});
            this.hoverDescription = stack -> Component.translatable((String)("miapi.stat." + this.translationKey + ".description"), (Object[])new Object[]{this.modifierFormat.format(this.property.getValue(stack).orElse(0.0))});
            return this;
        }

        public Builder setHoverDescription(Component hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public Builder setFormat(String format) {
            this.modifierFormat = (DecimalFormat)Util.make((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public Builder setHoverFormat(String format) {
            this.hoverFormat = (DecimalFormat)Util.make((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public SinglePropertyStatDisplay build() {
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            if (this.property == null) {
                throw new IllegalStateException("Property is required");
            }
            SinglePropertyStatDisplay display = new SinglePropertyStatDisplay(this.name, this.hoverDescription, this.property);
            display.maxValue = this.max;
            display.minValue = this.min;
            display.modifierFormat = this.modifierFormat;
            display.inverse = this.inverse;
            display.condition = this.condition;
            if (this.hoverFormat == null) {
                this.hoverFormat = this.modifierFormat;
            }
            display.hoverFormat = this.hoverFormat;
            return display;
        }
    }
}

