/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;

@OnlyIn(value=Dist.CLIENT)
public abstract class SingleStatDisplayBoolean
extends SingleStatDisplayDouble {
    protected SingleStatDisplayBoolean(int x, int y, int width, int height, StatListWidget.TextGetter title, StatListWidget.TextGetter hover) {
        super(x, y, width, height, title, hover);
        this.minValue = 0.0;
        this.maxValue = 1.0;
    }

    @Override
    public double getValue(ItemStack stack) {
        return this.getValueItemStack(stack) ? 1.0 : 0.0;
    }

    @Override
    public int getWidthDesired() {
        int textWidth = Minecraft.getInstance().font.width(this.text.resolve(this.original).getString());
        int numberWidth = Minecraft.getInstance().font.width(SingleStatDisplayBoolean.getText(this.compareToValue).getString());
        int size = 1;
        if (textWidth + numberWidth > 70) {
            size = 2;
        }
        return 76 * size;
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        super.shouldRender(original, compareTo);
        return this.hasValueItemStack(original) || this.hasValueItemStack(compareTo);
    }

    public abstract boolean getValueItemStack(ItemStack var1);

    public abstract boolean hasValueItemStack(ItemStack var1);

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        double min = Math.min(this.minValue, Math.min(this.oldValue, this.compareToValue));
        double max = Math.max(this.maxValue, Math.max(this.oldValue, this.compareToValue));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        SingleStatDisplayBoolean.drawTextureWithEdge(drawContext, this.texture, this.getX(), this.getY(), 339, 6, 51, 19, this.width, this.height, 512, 512, 2);
        this.textWidget.setX(this.getX() + 3);
        this.textWidget.setY(this.getY() + 3);
        this.textWidget.setWidth(this.width - 25);
        this.statBar.setX(this.getX() + 2);
        this.statBar.setY(this.getY() + 15);
        this.statBar.setWidth(this.width - 4);
        this.statBar.setHeight(1);
        if (this.oldValue < this.compareToValue) {
            this.statBar.setPrimary((this.oldValue - min) / (max - min), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((this.compareToValue - min) / (max - min), this.getGreen());
            this.compareValue.textColor = this.getGreen();
        } else {
            this.statBar.setPrimary((this.compareToValue - min) / (max - min), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((this.oldValue - min) / (max - min), this.getRed());
            this.compareValue.textColor = this.getRed();
        }
        if (this.oldValue == this.compareToValue) {
            this.currentValue.setX(this.getX() - 3);
            this.currentValue.setY(this.getY() + 5);
            this.currentValue.setWidth(this.getWidth());
            this.currentValue.setText((Component)Component.literal((String)(SingleStatDisplayBoolean.getText(this.oldValue).getString() + this.postfix.getString())));
            this.currentValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.currentValue.render(drawContext, mouseX, mouseY, delta);
        } else {
            this.compareValue.setX(this.getX() - 3);
            this.compareValue.setY(this.getY() + 5);
            this.compareValue.setWidth(this.getWidth());
            this.compareValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.compareValue.setText((Component)Component.literal((String)(SingleStatDisplayBoolean.getText(this.compareToValue).getString() + this.postfix.getString())));
            this.compareValue.render(drawContext, mouseX, mouseY, delta);
        }
        this.statBar.render(drawContext, mouseX, mouseY, delta);
        this.textWidget.render(drawContext, mouseX, mouseY, delta);
    }

    public static Component getText(double value) {
        return SingleStatDisplayBoolean.getText(value > 0.0);
    }

    public static Component getText(boolean value) {
        if (value) {
            return Component.translatable((String)"miapi.ui.boolean.true");
        }
        return Component.translatable((String)"miapi.ui.boolean.false");
    }
}

