/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ParentHandledScreen;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.StatBar;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.statdisplay.SinglePropertyStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

@OnlyIn(value=Dist.CLIENT)
public abstract class SingleStatDisplayDouble
extends InteractAbleWidget
implements SingleStatDisplay,
Renderable {
    public ResourceLocation texture = CraftingScreen.BACKGROUND_TEXTURE;
    public ItemStack original = ItemStack.EMPTY;
    public ItemStack compareTo = ItemStack.EMPTY;
    public StatBar statBar;
    public ScrollingTextWidget currentValue;
    public ScrollingTextWidget compareValue;
    public ScrollingTextWidget centerValue;
    public ScrollingTextWidget textWidget;
    public double maxValue = 100.0;
    public double minValue = 0.0;
    public DecimalFormat modifierFormat;
    public DecimalFormat hoverFormat;
    public StatListWidget.TextGetter text;
    public StatListWidget.TextGetter hover;
    public Component postfix = Component.nullToEmpty((String)"");
    public boolean inverse = false;
    double oldValue = 0.0;
    double compareToValue = 0.0;

    protected SingleStatDisplayDouble(int x, int y, int width, int height, StatListWidget.TextGetter title, StatListWidget.TextGetter hover) {
        super(x, y, width, height, (Component)Component.empty());
        this.text = title;
        this.hover = hover;
        this.textWidget = new ScrollingTextWidget(x, y, 80, (Component)Component.empty(), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        this.currentValue = new ScrollingTextWidget(x, y, 50, (Component)Component.empty(), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        this.centerValue = new ScrollingTextWidget(x, y, 70, (Component)Component.empty(), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        this.centerValue.setOrientation(ScrollingTextWidget.Orientation.CENTERED);
        this.compareValue = new ScrollingTextWidget(x, y, 70, (Component)Component.empty(), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        this.compareValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
        this.statBar = new StatBar(0, 0, width, 1, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        this.modifierFormat = (DecimalFormat)Util.make((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public int getRed() {
        if (this.inverse) {
            return MiapiConfig.getClientConfig().guiColors.green.argb();
        }
        return MiapiConfig.getClientConfig().guiColors.red.argb();
    }

    public int getGreen() {
        if (this.inverse) {
            return MiapiConfig.getClientConfig().guiColors.red.argb();
        }
        return MiapiConfig.getClientConfig().guiColors.green.argb();
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        ItemStack mainStack = compareTo.isEmpty() ? original : compareTo;
        this.original = original;
        this.compareTo = compareTo;
        this.compareToValue = this.getValue(compareTo);
        this.oldValue = this.getValue(original);
        this.textWidget.setText(this.text.resolve(mainStack));
        this.compareValue.setText(Component.nullToEmpty((String)this.modifierFormat.format(this.compareToValue)));
        int textWidth = Minecraft.getInstance().font.width((FormattedText)this.text.resolve(original));
        int numberWidth = Minecraft.getInstance().font.width((FormattedText)this.compareValue.getText());
        int size = Math.min(3, Math.max(1, (textWidth + numberWidth) / 47));
        this.setWidth(51 * size);
        return true;
    }

    @Override
    public int getHeightDesired() {
        return 19;
    }

    @Override
    public int getWidthDesired() {
        int textWidth = Minecraft.getInstance().font.width(this.text.resolve(this.original).getString());
        int numberWidth = Minecraft.getInstance().font.width(this.compareValue.getText().getString());
        int size = 1;
        if (textWidth + numberWidth > 70) {
            size = 2;
        }
        return 76 * size;
    }

    public abstract double getValue(ItemStack var1);

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        double min = Math.min(this.minValue, Math.min(this.oldValue, this.compareToValue));
        double max = Math.max(this.maxValue, Math.max(this.oldValue, this.compareToValue));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        SingleStatDisplayDouble.drawTextureWithEdge(drawContext, this.texture, this.getX(), this.getY(), 339, 6, 51, 19, this.width, this.height, 512, 512, 2);
        this.textWidget.setX(this.getX() + 3);
        this.textWidget.setY(this.getY() + 3);
        this.textWidget.setWidth(this.width - 25);
        this.statBar.setX(this.getX() + 2);
        this.statBar.setY(this.getY() + 15);
        this.statBar.setWidth(this.width - 4);
        this.statBar.setHeight(1);
        if (this.oldValue < this.compareToValue) {
            this.statBar.setPrimary((this.oldValue - min) / (max - min), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((this.compareToValue - min) / (max - min), this.getGreen());
            this.compareValue.textColor = this.getGreen();
        } else {
            this.statBar.setPrimary((this.compareToValue - min) / (max - min), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((this.oldValue - min) / (max - min), this.getRed());
            this.compareValue.textColor = this.getRed();
        }
        if (this.oldValue == this.compareToValue) {
            this.currentValue.setX(this.getX() - 3);
            this.currentValue.setY(this.getY() + 5);
            this.currentValue.setWidth(this.getWidth());
            this.currentValue.setText((Component)Component.literal((String)(this.modifierFormat.format(this.oldValue) + this.postfix.getString())));
            this.currentValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.currentValue.render(drawContext, mouseX, mouseY, delta);
        } else {
            this.compareValue.setX(this.getX() - 3);
            this.compareValue.setY(this.getY() + 5);
            this.compareValue.setWidth(this.getWidth());
            this.compareValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.compareValue.setText((Component)Component.literal((String)(Component.nullToEmpty((String)this.modifierFormat.format(this.compareToValue)).getString() + this.postfix.getString())));
            this.compareValue.render(drawContext, mouseX, mouseY, delta);
        }
        this.statBar.render(drawContext, mouseX, mouseY, delta);
        this.textWidget.render(drawContext, mouseX, mouseY, delta);
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.isMouseOver(mouseX, mouseY)) {
            drawContext.renderComponentTooltip(Minecraft.getInstance().font, this.getHoverLines(drawContext, mouseX, mouseY, delta), mouseX, mouseY);
        }
    }

    public List<Component> getHoverLines(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.isMouseOver(mouseX, mouseY)) {
            Component text1 = this.hover.resolve(this.compareTo);
            ArrayList<Component> components = new ArrayList<Component>();
            if (!text1.getString().isEmpty()) {
                components.addAll(Arrays.stream(text1.getString().split("\n")).map(Component::literal).toList());
            }
            components.addAll(this.additionalHoverLines());
            components.addAll(this.getLinesForDouble(this.getResolvable(this.compareTo == null ? this.original : this.compareTo)));
            return components;
        }
        return List.of();
    }

    public List<Component> additionalHoverLines() {
        return List.of();
    }

    public DoubleOperationResolvable getResolvable(ItemStack stack) {
        return null;
    }

    public DecimalFormat getHoverFormat() {
        if (this.hoverFormat == null) {
            return this.modifierFormat;
        }
        return this.hoverFormat;
    }

    public List<Component> getLinesForDouble(@Nullable DoubleOperationResolvable resolvable) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (resolvable != null) {
            if (ParentHandledScreen.hasShiftDown()) {
                if (resolvable != null) {
                    resolvable.operations.forEach(operation1 -> {
                        if (operation1.solve() != 0.0) {
                            list.add((Component)Component.literal((String)SinglePropertyStatDisplay.stringForOperation(this.getHoverFormat(), operation1)).withStyle(ChatFormatting.GRAY));
                            if (ParentHandledScreen.hasAltDown()) {
                                operation1.source.ifPresent(list::add);
                                list.add((Component)Component.literal((String)("  " + operation1.value)).withStyle(ChatFormatting.DARK_GRAY));
                            }
                        }
                    });
                }
                list.add((Component)Component.translatable((String)"miapi.ui.stat_detail.shift_alt").withStyle(ChatFormatting.DARK_GRAY));
            } else {
                list.add((Component)Component.translatable((String)"miapi.ui.stat_detail.shift").withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        return list;
    }

    @Override
    public InteractAbleWidget getHoverWidget() {
        return null;
    }

    public static interface StatReaderHelper {
        public double getValue(ItemStack var1);

        public boolean hasValue(ItemStack var1);
    }
}

