/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay.material;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.material.StatDisplayWidget;

@OnlyIn(value=Dist.CLIENT)
public class MaterialGroupTitleWidget
extends InteractAbleWidget {
    ScrollingTextWidget scrollingTextWidget;
    Component hoverDescription;
    boolean hasHoverdescription;
    List<InteractAbleWidget> widgets;
    ItemStack itemStack;
    ItemStack compare;

    public MaterialGroupTitleWidget(int x, int y, int width, String materialKey, List<InteractAbleWidget> widgets, ItemStack itemStack, ItemStack compare) {
        super(x, y, width, 12, (Component)Component.literal((String)materialKey));
        this.scrollingTextWidget = new ScrollingTextWidget(x, y + 2, width, (Component)Component.translatableWithFallback((String)("miapi.material_property.category." + materialKey), (String)materialKey));
        this.scrollingTextWidget.setOrientation(ScrollingTextWidget.Orientation.CENTERED);
        this.hoverDescription = Component.translatableWithFallback((String)("miapi.material_property.category." + materialKey + ".description"), (String)materialKey);
        this.hasHoverdescription = !this.hoverDescription.getString().equals(materialKey);
        this.addChild(this.scrollingTextWidget);
        this.widgets = widgets;
        this.itemStack = itemStack;
        this.compare = compare;
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.renderHover(drawContext, mouseX, mouseY, delta);
        if (this.hasHoverdescription && this.isMouseOver(mouseX, mouseY)) {
            drawContext.renderTooltip(Minecraft.getInstance().font, this.hoverDescription, mouseX, mouseY);
        }
    }

    public void setX(int x) {
        super.setX(x);
        this.scrollingTextWidget.setX(x);
    }

    public void setY(int y) {
        super.setY(y);
        this.scrollingTextWidget.setY(y + 2);
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.scrollingTextWidget.setWidth(width);
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        for (InteractAbleWidget widget : this.widgets) {
            if (widget instanceof StatDisplayWidget) {
                StatDisplayWidget statDisplayWidget = (StatDisplayWidget)widget;
                statDisplayWidget.setItemsOriginal(this.itemStack, this.compare);
                continue;
            }
            if (!(widget instanceof SingleStatDisplay)) continue;
            SingleStatDisplay display = (SingleStatDisplay)((Object)widget);
            display.shouldRender(this.itemStack, this.compare);
        }
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }
}

