/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.redpxnda.nucleus.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import smartin.miapi.Miapi;
import smartin.miapi.client.GlintShader;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.client.model.ModelHolder;
import smartin.miapi.client.model.ModelTransformer;
import smartin.miapi.client.renderer.TrimRenderer;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.GlintProperty;
import smartin.miapi.modules.properties.render.AlphaOverwriteProperty;
import smartin.miapi.modules.properties.render.ColorProperty;
import smartin.miapi.modules.properties.render.EmissivityProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

@OnlyIn(value=Dist.CLIENT)
public class BakedMiapiModel
implements MiapiModel {
    ModuleInstance instance;
    BakedModel model;
    Matrix4f modelMatrix;
    ModelHolder modelHolder;
    RandomSource random = RandomSource.create();
    float[] colors;
    GlintProperty.GlintSettings settings;
    int skyLight;
    int blockLight;
    float alpha;

    public BakedMiapiModel(ModelHolder holder, ModuleInstance moduleInstance, ItemStack stack) {
        this.modelHolder = holder;
        this.instance = holder.colorProvider().adapt(moduleInstance);
        Color color = holder.colorProvider().getVertexColor().orElse(ColorProperty.getColor(stack, this.instance));
        this.colors = new float[]{color.redAsFloat(), color.greenAsFloat(), color.blueAsFloat()};
        this.modelMatrix = holder.matrix4f();
        this.model = holder.model();
        this.settings = GlintProperty.property.getGlintSettings(this.instance, stack);
        this.skyLight = holder.lightValues()[0];
        this.blockLight = holder.lightValues()[1];
        int[] propertyLight = EmissivityProperty.getLightValues(this.instance);
        int propertySky = propertyLight[0];
        int propertyBlock = propertyLight[1];
        this.alpha = AlphaOverwriteProperty.property.getData(moduleInstance).map(DoubleOperationResolvable::getValue).orElse(1.0).floatValue();
        if (propertySky > this.skyLight) {
            this.skyLight = propertySky;
        }
        if (propertyBlock > this.blockLight) {
            this.blockLight = propertyBlock;
        }
    }

    @Override
    public void render(PoseStack matrices, ItemStack stack, ItemDisplayContext transformationMode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int packedLight, int overlay) {
        Holder armorMaterial;
        assert (Minecraft.getInstance().level != null);
        Minecraft.getInstance().getProfiler().push("BakedModel");
        Minecraft.getInstance().getProfiler().push("BakedModel-logic");
        matrices.pushPose();
        int sky = LightTexture.sky((int)packedLight);
        int block = LightTexture.block((int)packedLight);
        if (this.skyLight > sky) {
            sky = this.skyLight;
        }
        if (this.blockLight > block) {
            block = this.blockLight;
        }
        int light = LightTexture.pack((int)block, (int)sky);
        Transform.applyPosition(matrices, this.modelMatrix);
        BakedModel currentModel = this.resolve(this.model, stack, entity, light);
        Minecraft.getInstance().getProfiler().pop();
        Minecraft.getInstance().getProfiler().push("BakedModel - quads");
        try {
            for (Direction dir : Direction.values()) {
                currentModel.getQuads(null, dir, RandomSource.create()).forEach(quad -> {
                    VertexConsumer vertexConsumer = this.modelHolder.colorProvider().getConsumer(vertexConsumers, quad.getSprite(), stack, this.instance, transformationMode);
                    vertexConsumer.putBulkData(matrices.last(), quad, this.colors[0], this.colors[1], this.colors[2], this.alpha, light, overlay);
                });
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("rendering error in module " + String.valueOf(this.instance.moduleID) + " " + String.valueOf(MaterialProperty.getMaterial(this.instance)), (Throwable)e);
        }
        Minecraft.getInstance().getProfiler().pop();
        Minecraft.getInstance().getProfiler().push("BakedModel Glint");
        if (stack.hasFoil() && MiapiConfig.getClientConfig().enchantingGlint.enabled) {
            try {
                VertexConsumer altConsumer = vertexConsumers.getBuffer(GlintShader.modularItemGlint);
                for (Direction dir : Direction.values()) {
                    currentModel.getQuads(null, dir, RandomSource.create()).forEach(quad -> {
                        Color glintColor = this.settings.getColor();
                        altConsumer.putBulkData(matrices.last(), quad, glintColor.redAsFloat(), glintColor.greenAsFloat(), glintColor.blueAsFloat(), this.alpha, light, overlay);
                    });
                }
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("rendering glint error in module " + String.valueOf(this.instance.moduleID) + " " + String.valueOf(MaterialProperty.getMaterial(this.instance)), (Throwable)e);
            }
        }
        Minecraft.getInstance().getProfiler().pop();
        Minecraft.getInstance().getProfiler().push("TrimModel");
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            v0 = armorItem.getMaterial();
        } else {
            v0 = armorMaterial = null;
        }
        if (armorMaterial != null && !this.modelHolder.trimMode().equals((Object)TrimRenderer.TrimMode.NONE)) {
            ModelTransformer.getRescale(currentModel, this.random).forEach(quad -> TrimRenderer.renderTrims(matrices, quad, this.modelHolder.trimMode(), light, vertexConsumers, (Holder<ArmorMaterial>)armorMaterial, stack));
        }
        Minecraft.getInstance().getProfiler().pop();
        if (this.modelHolder.entityRendering()) {
            Minecraft.getInstance().getProfiler().push("EntityModel");
            ModelTransformer.getInverse(currentModel, this.random).forEach(quad -> {
                VertexConsumer vertexConsumer = this.modelHolder.colorProvider().getConsumer(vertexConsumers, quad.getSprite(), stack, this.instance, transformationMode);
                vertexConsumer.putBulkData(matrices.last(), quad, this.colors[0], this.colors[1], this.colors[2], this.alpha, light, overlay);
            });
            Minecraft.getInstance().getProfiler().pop();
        }
        matrices.popPose();
        Minecraft.getInstance().getProfiler().pop();
    }

    public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable LivingEntity entity, int light) {
        if (model.getOverrides() != null && !model.getOverrides().equals(ItemOverrides.EMPTY)) {
            BakedModel override = model.getOverrides().resolve(model, stack, Minecraft.getInstance().level, entity, light);
            if (model != null) {
                model = override;
            }
        }
        return model;
    }
}

