/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.model.item.BakedSingleModel;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;

@OnlyIn(value=Dist.CLIENT)
public class ColorUtil {
    private ColorUtil() {
    }

    public static BakedModel recolorModel(BakedModel originalModel, int color) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BakedQuad quad : originalModel.getQuads(null, null, RandomSource.create())) {
            builder.add((Object)ColorUtil.recolorBakedQuad(quad, color));
        }
        for (Direction dir : Direction.values()) {
            for (BakedQuad quad : originalModel.getQuads(null, dir, RandomSource.create())) {
                builder.add((Object)ColorUtil.recolorBakedQuad(quad, color));
            }
        }
        BakedSingleModel model = new BakedSingleModel((List<BakedQuad>)builder.build());
        model.overrideList = originalModel.getOverrides();
        return model;
    }

    public static BakedQuad recolorBakedQuad(BakedQuad originalQuad, int newColor) {
        return new BakedQuad(originalQuad.getVertices(), newColor, originalQuad.getDirection(), originalQuad.getSprite(), false);
    }

    public static int getModuleColor(ModuleInstance instance) {
        Material material = MaterialProperty.getMaterial(instance);
        if (material != null) {
            return material.getColor(instance);
        }
        return FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
    }
}

